package org.eclipse.tptp.logging.events.cbe;

import java.io.Serializable;

/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AssociationEngine.java,v 1.1 2006/09/06 17:53:59 cjin Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Interface representing an <code>AssociationEngine</code>.
 * <p>
 * The following description is from the Common Base Event v1.0.1 specification
 * entitled "Canonical Situation Data Format: The Common Base Event V1.0.1":
 * <p>
 * The AssociationEngine identifies the application that establishes
 * associations among related or associated events. In addition, it provides
 * properties to describe the types of the associations.
 * <p>
 * The AssociationEngine is a standalone entity in the XML schema and the
 * AssociatedEvents created by the application that is identified by the
 * AssociationEngine refer to it. This will eliminate the need to repeat the
 * same data in every associated event.
 * <p>
 * 
 * 
 * @author Paul E. Slauenwhite
 * @version February 5, 2006
 * @since 1.0.1
 */
public interface AssociationEngine extends Cloneable, Serializable {

    /**
     * <P>
     * Value for the <em><b>Type</b></em> attribute.
     * </P>
     * <P>
     * The association represents containment of other events within a root
     * event.
     * </P>
     * 
     * @see #getType()
     */
    String TYPE_CONTAIN = "Contain";

    /**
     * <P>
     * Value for the <em><b>Type</b></em> attribute.
     * </P>
     * <P>
     * The association represents a causality allowing the associated event to
     * point to the cause of the situation.
     * </P>
     * 
     * @see #getType()
     */
    String TYPE_CAUSED_BY = "CausedBy";

    /**
     * Value for the <em><b>Type</b></em> attribute.
     * <P>
     * The association represents a relationship where an event points to an
     * event that fixes or results in the situation becoming irrelevant.
     * </P>
     * 
     * @see #getType()
     */
    String TYPE_CLEARED = "Cleared";

    /**
     * Value for the <em><b>Type</b></em> attribute.
     * <P>
     * The association represents a collection of events together compose a
     * single event.
     * </P>
     * 
     * @see #getType()
     */
    String TYPE_MULTI_PART = "MultiPart";

    /**
     * Value for the <em><b>Type</b></em> attribute.
     * <P>
     * The association represents a relationship between a child and parent
     * event based on a correlation algorithm specified in the name of the
     * association.
     * </P>
     * 
     * @see #getType()
     */
    String TYPE_CORRELATED = "Correlated";

    /**
     * <P>
     * Returns the value of the '<em><b>Id</b></em>' attribute.
     * </P>
     *  
     * 
     * @return the value of the '<em>Id</em>' attribute.
     * @see #setId(String)
     */
    String getId();

    /**
     * <P>
     * Sets the value of the '
     * {@link org.eclipse.tptp.logging.events.cbe.AssociationEngine#getId <em>Id</em>}'
     * attribute.
     * </P>
     * 
     * <P>
     * The primary identifier for the element. This property <em>must</em> be
     * globally unique. The recommend value for this is either a 128 bit or 256
     * bit Globally Unique Id (represented as hex string). Once this value is
     * set it <em>must</em> never be changed. This is a <em>required</em>
     * property.
     * </P>
     * 
     * 
     * @param value
     *            the new value of the '<em>Id</em>' attribute.
     * @see #getId()
     */
    void setId(String value);

    /**
     * <P>
     * Returns the value of the '<em><b>Type</b></em>' attribute.
     * </P>
     *  
     * 
     * @return the value of the '<em>Type</em>' attribute.
     * @see #setType(String)
     */
    String getType();

    /**
     * <P>
     * Sets the value of the '
     * {@link org.eclipse.tptp.logging.events.cbe.AssociationEngine#getType <em>Type</em>}'
     * attribute.
     * </P>
     * 
     * <P>
     * This property should contain the type of association created by this
     * AssociationEngine. Some well defined associations are:
     * <UL>
     * <LI>Contains</LI>
     * <LI>Cleared</LI>
     * <LI>CausedBy</LI>
     * <LI>MultiPart</LI>
     * <LI>Correlated
     * </UL>
     * </P>
     * <P>
     * This is a <em>required</em> property. The string length for this
     * property <em>must not</em> exceed 64 characters.
     * </P>
     * 
     * 
     * @param value
     *            the new value of the '<em>Type</em>' attribute.
     * @see #getType()
     */
    void setType(String value);

    /**
     * <P>
     * Returns the value of the '<em><b>Name</b></em>' attribute.
     * </P>
     *  
     * 
     * @return the value of the '<em>Name</em>' attribute.
     * @see #setName(String)
     */
    String getName();

    /**
     * <P>
     * Sets the value of the '
     * {@link org.eclipse.tptp.logging.events.cbe.AssociationEngine#getName <em>Name</em>}'
     * attribute.
     * </P>
     * 
     * <P>
     * The name of the application that creates the association (for example, my
     * correlation engine name). This is a <em>required</em> property. The
     * string length for this property <em>must not</em> exceed 64 characters.
     * </P>
     * 
     * 
     * @param value
     *            the new value of the '<em>Name</em>' attribute.
     * @see #getName()
     */
    void setName(String value);

    /**
     * </P>
     * Checks whether the contents of this object conforms to the CBE
     * specification.
     * </P>
     * 
     * @throws ValidationException
     *             if the object does not follow the CBE specification.
     */
    void validate() throws ValidationException;

    /**
     * Resets the object's properties to their initial (e.g. null) state, except
     * the <code>id</code> property.
     * <p>
     * This API assigns a new unique <code>GUID</code> to the <code>id</code>
     * property.
     * <p>
     * 
     * @since 1.0
     */
    void init();
} // AssociationEngine
