package org.eclipse.tptp.logging.events.cbe;

/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AvailableSituation.java,v 1.1 2006/09/06 17:53:59 cjin Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Interface representing an <code>AvailableSituation</code>.
 * <p>
 * The following description is from the Common Base Event v1.0.1 specification
 * entitled "Canonical Situation Data Format: The Common Base Event V1.0.1":
 * <p>
 * The AvailableSituation deals with the situations reported from the component
 * regarding its operational state and availability. This situation provides a
 * context for operations that can be performed on the component by
 * distinguishing if a product is installed, operational, and ready to process
 * functional requests. Or, operational and ready/not ready to process
 * management requests. Existing messages include words like those that indicate
 * it is ready to take requests, both online and offline. For example:
 * <p>
 * <ul>
 * <li>ADMC0013I: SOAP connector available at port 8880</li>
 * <br>
 * <li>ADMC0026I: RMI Connector available at port 2809</li>
 * </ul>
 * <p>
 * 
 * 
 * @author Paul E. Slauenwhite
 * @version February 5, 2006
 * @since 1.0.1
 */
public interface AvailableSituation extends SituationType {

    /**
     * <P>
     * Returns the value of the '<em><b>Operation Disposition</b></em>'
     * attribute.
     * </P>
     *  
     * 
     * @return the value of the '<em>Operation Disposition</em>' attribute.
     * @see #setOperationDisposition(String)
     */
    String getOperationDisposition();

    /**
     * <P>
     * Sets the value of the '
     * {@link org.eclipse.tptp.logging.events.cbe.AvailableSituation#getOperationDisposition <em>Operation Disposition</em>}'
     * attribute.
     * </P>
     * 
     * <P>
     * This property specifies the operational state of the component reported
     * by the situation. The operationalDisposition is a string with the values
     * such as:
     * <UL>
     * <LI>STARTABLE</LI>
     * <LI>NONSTARTABLE</LI>
     * </UL>
     * </P>
     * <P>
     * This is a <em>required</em> property and once it is set it
     * <em>must not</em> change. The string length for this property
     * <em>must not</em> exceed 64 characters.
     * </P>
     * 
     * 
     * @param value
     *            the new value of the '<em>Operation Disposition</em>'
     *            attribute.
     * @see #getOperationDisposition()
     */
    void setOperationDisposition(String value);

    /**
     * <P>
     * Returns the value of the '<em><b>Availability Disposition</b></em>'
     * attribute.
     * </P>
     *  
     * 
     * @return the value of the '<em>Availability Disposition</em>'
     *         attribute.
     * @see #setAvailabilityDisposition(String)
     */
    String getAvailabilityDisposition();

    /**
     * <P>
     * Sets the value of the '
     * {@link org.eclipse.tptp.logging.events.cbe.AvailableSituation#getAvailabilityDisposition <em>Availability Disposition</em>}'
     * attribute.
     * </P>
     * 
     * <P>
     * This property specifies the availability disposition of an entity or
     * component that caused the situation to be reported.
     * <P>
     * The availabilityDisposition is a string with the following set of values:
     * <UL>
     * <LI>AVAILABLE</LI>
     * <LI>NOT AVAILABLE</LI>
     * </UL>
     * This is a <em>required</em> property and once it is set it
     * <em>must not</em> change. The string length for this property
     * <em>must not</em> exceed 64 characters.
     * </P>
     * 
     * 
     * @param value
     *            the new value of the '<em>Availability Disposition</em>'
     *            attribute.
     * @see #getAvailabilityDisposition()
     */
    void setAvailabilityDisposition(String value);

    /**
     * <P>
     * Returns the value of the '<em><b>Processing Disposition</b></em>'
     * attribute.
     * </P>
     *  
     * 
     * @return the value of the '<em>Processing Disposition</em>' attribute.
     * @see #setProcessingDisposition(String)
     */
    String getProcessingDisposition();

    /**
     * <P>
     * Sets the value of the '
     * {@link org.eclipse.tptp.logging.events.cbe.AvailableSituation#getProcessingDisposition <em>Processing Disposition</em>}'
     * attribute.
     * </P>
     * 
     * <P>
     * This property specifies the processing disposition of a component
     * operation that caused the situation to be reported.
     * <P>
     * The processingDisposition is a string with the following set of values:
     * <UL>
     * <LI>FUNCTION_PROCESS</LI>
     * <LI>FUNCTION_BLOCK</LI>
     * <LI>MGMTTASK_PROCESS</LI>
     * <LI>MGMTTASK_BLOCKED</LI>
     * </UL>
     * This is a <em>required</em> property and once it is set it
     * <em>must not</em> change. The string length for this property
     * <em>must not</em> exceed 64 characters.
     * </P>
     * 
     * 
     * @param value
     *            the new value of the '<em>Processing Disposition</em>'
     *            attribute.
     * @see #getProcessingDisposition()
     */
    void setProcessingDisposition(String value);

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * All components are initialized to either zero or null.
     * 
     * @since 1.0
     */
    void init();
} // AvailableSituation
