package org.eclipse.tptp.logging.events.cbe;

/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CompletionException.java,v 1.2 2008/01/24 02:52:26 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Class representing a <code>CompletionException</code>.
 * <p>
 * This exception thrown by {@link ContentHandler#completeEvent}method to
 * indicate that an event could not be completed.
 * <p>
 * 
 * 
 * @author Paul E. Slauenwhite
 * @version April 28, 2005
 * @since March 10, 2005
 * @since 1.0.1
 */
public class CompletionException extends EventException {

    /**
     * Stream-Unique IDentifier (SUID) of this class.
     * <p>
     * NOTE:  This value MUST not be modified unless an incompatible 
     *        change is introduced.  
     * <p>
     * See the 'Java Object Serialization Specification' for more details.
     * <p>
     * Compatible changes include:
     * <ul>
     * <li>Adding, modifying access or modifying <code>static</code>/<code>transient</code> to non-<code>static</code>/non-<code>transient</code> of fields.</li>
     * <li>Adding or removing classes.</li>
     * <li>Adding or removing <code>writeObject</code>/<code>readObject</code> methods.</li>
     * <li>Adding <code>java.io.Serializable</code> inheritance.</li>
     * </ul>
     * <p>
     * Incompatible changes include:
     * <ul>
     * <li>Deleting, modifying non-<code>static</code>/non-<code>transient</code> to <code>static</code>/<code>transient</code> or modifying the declared type of fields.</li>
     * <li>Modifying the hierarchy or interchanging/removing <code>java.io.Serializable</code>/<code>java.io.Externalizable</code> inheritance of the class.</li>
     * <li>Modifying <code>writeObject</code>/<code>readObject</code> methods.</li>
     * <li>Adding <code>writeReplace</code>/<code>readResolve</code> methods.</li>
     * </ul>
     */
    protected static final long serialVersionUID = -8172000819822434632L;

    /**
     * Simple constructor.
     */
    public CompletionException() {
        super();
    }

    /**
     * Constructs a <code>CompletionException</code> with the specified detail
     * message.
     * 
     * @param message
     *            the detail message
     */
    public CompletionException(String message) {
        super(message);
    }

    /**
     * Constructs a <code>CompletionException</code> with the specified detail
     * message and a nested exception.
     * 
     * @param message
     *            the detail message
     * @param cause
     *            The nested exception, or <code>null</code>, if a nested
     *            exception is not appropriate.
     */
    public CompletionException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Creates a <code>CompletionException</code> with a detail message,
     * message translation information (resource bundle, message key and message
     * substitutions).
     * 
     * @param key
     *            The message key.
     * @param resourceBundleName
     *            The name of the message ResourceBundle to use.
     */
    public CompletionException(String key, String resourceBundleName) {
        super(key, resourceBundleName, null);
    }

    /**
     * Construct a new <code>CompletionException</code> with a null detail
     * message and a cause field set to the specified Throwable. Subsequent
     * calls to the {@link #initCause(Throwable)} method on this instance will result in an
     * exception. The value of the cause field may be retrieved at any time via
     * the {@link #getCause()} method.
     * 
     * @param cause
     *            the Throwable that was caught and is considered the root cause
     *            of this exception. Null is tolerated.
     */
    public CompletionException(Throwable cause) {
        super(cause);
    }

    /**
     * Creates a <code>CompletionException</code> with a detail message,
     * message translation information (resource bundle, message key and message
     * substitutions).
     * 
     * @param key
     *            The message key.
     * @param resourceBundleName
     *            The name of the message ResourceBundle to use.
     * @param parameters
     *            An array of elements to be inserted into the message.
     */
    public CompletionException(String key, String resourceBundleName, Object[] parameters) {
        super(key, resourceBundleName, parameters);
    }

    /**
     * Creates a <code>CompletionException</code> with a detail message,
     * message translation information (resource bundle, message key and message
     * substitutions) and a nested exception.
     * 
     * @param key
     *            The message key.
     * @param resourceBundleName
     *            The name of the message ResourceBundle to use.
     * @param parameters
     *            An array of elements to be inserted into the message.
     * @param cause
     *            The nested exception, or <code>null</code>, if a nested
     *            exception is not appropriate.
     */
    public CompletionException(String key, String resourceBundleName, Object[] parameters, Throwable cause) {
        super(key, resourceBundleName, parameters, cause);
    }
}
