package org.eclipse.tptp.logging.events.cbe;

import java.io.Serializable;

/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ComponentIdentification.java,v 1.1 2006/09/06 17:54:00 cjin Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Interface representing a <code>ComponentIdentification</code>.
 * <p>
 * The following description is from the Common Base Event v1.0.1 specification
 * entitled "Canonical Situation Data Format: The Common Base Event V1.0.1":
 * <p>
 * Component identification provides a collection of attributes that are
 * required to uniquely identify a component. The same data is used to identify
 * both the reporter and the affected component.
 * <p>
 * 
 * 
 * @author Paul E. Slauenwhite
 * @version February 5, 2006
 * @since 1.0.1
 */
public interface ComponentIdentification extends Cloneable, Serializable {

    /**
     * <p>
     * Well-known type for the '<em><b>Component Id Type</b></em>'
     * attribute.
     * </p>
     * 
     * @see #getComponentIdType()
     */
    String COMPONENT_ID_TYPE_PRODUCT_NAME = "ProductName";

    /**
     * <p>
     * Well-known type for the '<em><b>Component Id Type</b></em>'
     * attribute.
     * </p>
     * 
     * @see #getComponentIdType()
     */
    String COMPONENT_ID_TYPE_DEVICE_NAME = "DeviceName";

    /**
     * <p>
     * Well-known type for the '<em><b>Component Id Type</b></em>'
     * attribute.
     * </p>
     * 
     * @see #getComponentIdType()
     */
    String COMPONENT_ID_TYPE_SYSTEM_NAME = "SystemName";

    /**
     * <p>
     * Well-known type for the '<em><b>Component Id Type</b></em>'
     * attribute.
     * </p>
     * 
     * @see #getComponentIdType()
     */
    String COMPONENT_ID_TYPE_SERVICE_NAME = "ServiceName";

    /**
     * <p>
     * Well-known type for the '<em><b>Component Id Type</b></em>'
     * attribute.
     * </p>
     * 
     * @see #getComponentIdType()
     */
    String COMPONENT_ID_TYPE_PROCESS = "Process";

    /**
     * <p>
     * Well-known type for the '<em><b>Component Id Type</b></em>'
     * attribute.
     * </p>
     * 
     * @see #getComponentIdType()
     */
    String COMPONENT_ID_TYPE_APPLICATION = "Application";

    /**
     * <p>
     * Well-known type for the '<em><b>Component Id Type</b></em>'
     * attribute.
     * </p>
     * 
     * @see #getComponentIdType()
     */
    String COMPONENT_ID_TYPE_UNKNOWN = "Unknown";

    /**
     * <p>
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * </p>
     * 
     * @see #getLocationType()
     */
    String LOCATION_TYPE_UNKNOWN = "Unknown";

    /**
     * <p>
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * </p>
     * 
     * @see #getLocationType()
     */
    String LOCATION_TYPE_IPV4 = "IPV4";

    /**
     * <p>
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * </p>
     * 
     * @see #getLocationType()
     */
    String LOCATION_TYPE_IPV6 = "IPV6";

    /**
     * <p>
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * </p>
     * 
     * @see #getLocationType()
     */
    String LOCATION_TYPE_NWA = "NWA";

    /**
     * <p>
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * </p>
     * 
     * @see #getLocationType()
     */
    String LOCATION_TYPE_ISDN = "ISDN";

    /**
     * <p>
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * </p>
     * 
     * @see #getLocationType()
     */
    String LOCATION_TYPE_ICD = "ICD";

    /**
     * <p>
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * </p>
     * 
     * @see #getLocationType()
     */
    String LOCATION_TYPE_OID_OSI = "OID-OSI";

    /**
     * <p>
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * </p>
     * 
     * @see #getLocationType()
     */
    String LOCATION_TYPE_DIAL = "Dial";

    /**
     * <p>
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * </p>
     * 
     * @see #getLocationType()
     */
    String LOCATION_TYPE_HWA = "HWA";

    /**
     * <p>
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * </p>
     * 
     * @see #getLocationType()
     */
    String LOCATION_TYPE_HID = "HID";

    /**
     * <p>
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * </p>
     * 
     * @see #getLocationType()
     */
    String LOCATION_TYPE_X25 = "X25";

    /**
     * <p>
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * </p>
     * 
     * @see #getLocationType()
     */
    String LOCATION_TYPE_DCC = "DCC";

    /**
     * <p>
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * </p>
     * 
     * @see #getLocationType()
     */
    String LOCATION_TYPE_SNA = "SNA";

    /**
     * <p>
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * </p>
     * 
     * @see #getLocationType()
     */
    String LOCATION_TYPE_IPX = "IPX";

    /**
     * <p>
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * </p>
     * 
     * @see #getLocationType()
     */
    String LOCATION_TYPE_E_164 = "E.164";

    /**
     * <p>
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * </p>
     * 
     * @see #getLocationType()
     */
    String LOCATION_TYPE_HOSTNAME = "Hostname";

    /**
     * <p>
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * </p>
     * 
     * @see #getLocationType()
     */
    String LOCATION_TYPE_FQ_HOSTNAME = "FQHostname";

    /**
     * <p>
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * </p>
     * 
     * @see #getLocationType()
     */
    String LOCATION_TYPE_DEVICE_NAME = "Devicename";

    /**
     * <p>
     * Returns the value of the '<em><b>Application</b></em>' attribute.
     * </p>
     *  
     * 
     * @return the value of the '<em>Application</em>' attribute.
     * @see #setApplication(String)
     */
    String getApplication();

    /**
     * <p>
     * Sets the value of the '
     * {@link org.eclipse.tptp.logging.events.cbe.ComponentIdentification#getApplication <em>Application</em>}'
     * attribute.
     * </p>
     *  
     * 
     * @param value
     *            the new value of the '<em>Application</em>' attribute.
     * @see #getApplication()
     */
    void setApplication(String value);

    /**
     * <p>
     * Returns the value of the '<em><b>Component</b></em>' attribute.
     * </p>
     *  
     * 
     * @return the value of the '<em>Component</em>' attribute.
     * @see #setComponent(String)
     */
    String getComponent();

    /**
     * <p>
     * Sets the value of the '
     * {@link org.eclipse.tptp.logging.events.cbe.ComponentIdentification#getComponent <em>Component</em>}'
     * attribute.
     * </p>
     *  
     * 
     * @param value
     *            the new value of the '<em>Component</em>' attribute.
     * @see #getComponent()
     */
    void setComponent(String value);

    /**
     * Returns the value of the '<em><b>Component Type</b></em>' attribute.
     * 
     * <p>
     * If the meaning of the '<em>Component Type</em>' attribute isn't
     * clear, there really should be more of a description here...
     * </p>
     * 
     * 
     * @return the value of the '<em>Component Type</em>' attribute.
     * @see #setComponentType(String)
     */
    String getComponentType();

    /**
     * <p>
     * Sets the value of the '
     * {@link org.eclipse.tptp.logging.events.cbe.ComponentIdentification#getComponentType <em>Component Type</em>}'
     * attribute.
     * </p>
     *  
     * 
     * @param value
     *            the new value of the '<em>Component Type</em>' attribute.
     * @see #getComponentType()
     */
    void setComponentType(String value);

    /**
     * <p>
     * Returns the value of the '<em><b>Component Id Type</b></em>'
     * attribute.
     * </p>
     *  
     * 
     * @return the value of the '<em>Component Id Type</em>' attribute.
     * @see #setComponentIdType(String)
     */
    String getComponentIdType();

    /**
     * <p>
     * Sets the value of the '
     * {@link org.eclipse.tptp.logging.events.cbe.ComponentIdentification#getComponentIdType <em>Component Id Type</em>}'
     * attribute.
     * </p>
     *  
     * 
     * @param value
     *            the new value of the '<em>Component Id Type</em>'
     *            attribute.
     * @see #getComponentIdType()
     */
    void setComponentIdType(String value);

    /**
     * <p>
     * Returns the value of the '<em><b>Execution Environment</b></em>'
     * attribute.
     * </p>
     *  
     * 
     * @return the value of the '<em>Execution Environment</em>' attribute.
     * @see #setExecutionEnvironment(String)
     */
    String getExecutionEnvironment();

    /**
     * <p>
     * Sets the value of the '
     * {@link org.eclipse.tptp.logging.events.cbe.ComponentIdentification#getExecutionEnvironment <em>Execution Environment</em>}'
     * attribute.
     * </p>
     *  
     * 
     * @param value
     *            the new value of the '<em>Execution Environment</em>'
     *            attribute.
     * @see #getExecutionEnvironment()
     */
    void setExecutionEnvironment(String value);

    /**
     * <p>
     * Returns the value of the '<em><b>Instance Id</b></em>' attribute.
     * </p>
     *  
     * 
     * @return the value of the '<em>Instance Id</em>' attribute.
     * @see #setInstanceId(String)
     */
    String getInstanceId();

    /**
     * <p>
     * Sets the value of the '
     * {@link org.eclipse.tptp.logging.events.cbe.ComponentIdentification#getInstanceId <em>Instance Id</em>}'
     * attribute.
     * </p>
     *  
     * 
     * @param value
     *            the new value of the '<em>Instance Id</em>' attribute.
     * @see #getInstanceId()
     */
    void setInstanceId(String value);

    /**
     * <p>
     * Returns the value of the '<em><b>Location</b></em>' attribute.
     * </p>
     *  
     * 
     * @return the value of the '<em>Location</em>' attribute.
     * @see #setLocation(String)
     */
    String getLocation();

    /**
     * <p>
     * Sets the value of the '
     * {@link org.eclipse.tptp.logging.events.cbe.ComponentIdentification#getLocation <em>Location</em>}'
     * attribute.
     * </p>
     *  
     * 
     * @param value
     *            the new value of the '<em>Location</em>' attribute.
     * @see #getLocation()
     */
    void setLocation(String value);

    /**
     * <p>
     * Returns the value of the '<em><b>Location Type</b></em>' attribute.
     * </p>
     *  
     * 
     * @return the value of the '<em>Location Type</em>' attribute.
     * @see #setLocationType(String)
     */
    String getLocationType();

    /**
     * <p>
     * Sets the value of the '
     * {@link org.eclipse.tptp.logging.events.cbe.ComponentIdentification#getLocationType <em>Location Type</em>}'
     * attribute.
     * </p>
     *  
     * 
     * @param value
     *            the new value of the '<em>Location Type</em>' attribute.
     * @see #getLocationType()
     */
    void setLocationType(String value);

    /**
     * <p>
     * Returns the value of the '<em><b>Process Id</b></em>' attribute.
     * </p>
     *  
     * 
     * @return the value of the '<em>Process Id</em>' attribute.
     * @see #setProcessId(String)
     */
    String getProcessId();

    /**
     * <p>
     * Sets the value of the '
     * {@link org.eclipse.tptp.logging.events.cbe.ComponentIdentification#getProcessId <em>Process Id</em>}'
     * attribute.
     * </p>
     *  
     * 
     * @param value
     *            the new value of the '<em>Process Id</em>' attribute.
     * @see #getProcessId()
     */
    void setProcessId(String value);

    /**
     * <p>
     * Returns the value of the '<em><b>Sub Component</b></em>' attribute.
     * </p>
     *  
     * 
     * @return the value of the '<em>Sub Component</em>' attribute.
     * @see #setSubComponent(String)
     */
    String getSubComponent();

    /**
     * <p>
     * Sets the value of the '
     * {@link org.eclipse.tptp.logging.events.cbe.ComponentIdentification#getSubComponent <em>Sub Component</em>}'
     * attribute.
     * </p>
     *  
     * 
     * @param value
     *            the new value of the '<em>Sub Component</em>' attribute.
     * @see #getSubComponent()
     */
    void setSubComponent(String value);

    /**
     * <p>
     * Returns the value of the '<em><b>Thread Id</b></em>' attribute.
     * </p>
     *  
     * 
     * @return the value of the '<em>Thread Id</em>' attribute.
     * @see #setThreadId(String)
     */
    String getThreadId();

    /**
     * <p>
     * Sets the value of the '
     * {@link org.eclipse.tptp.logging.events.cbe.ComponentIdentification#getThreadId <em>Thread Id</em>}'
     * attribute.
     * </p>
     *  
     * 
     * @param value
     *            the new value of the '<em>Thread Id</em>' attribute.
     * @see #getThreadId()
     */
    void setThreadId(String value);

    /**
     * <p>
     * Checks whether the contents of this object conform to the CBE
     * specification.
     * </p>
     * 
     * @throws ValidationException
     *             if the object does not follow the CBE specification.
     */
    void validate() throws ValidationException;

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * All components are initialized to either zero or null.
     * 
     * @since 1.0
     */
    void init();
} // ComponentIdentification
