package org.eclipse.tptp.logging.events.cbe;

/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ConfigureSituation.java,v 1.1 2006/09/06 17:54:00 cjin Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Interface representing a <code>ConfigureSituation</code>.
 * <p>
 * The following description is from the Common Base Event v1.0.1 specification
 * entitled "Canonical Situation Data Format: The Common Base Event V1.0.1":
 * <p>
 * The ConfigureSituation deals with the components identifying their
 * configuration. Any changes that a component makes to its configuration should
 * be logged using this category. Additionally, messages that describe current
 * configuration state fall into this category. Existing message include words
 * like port number is, address is, and process id, for example:
 * <p>
 * <code>ADFS0134I: File transfer is configured with host="9.27.11.13", port="9090", securityEnabled="false".</code>
 * <p>
 * 
 * 
 * @author Paul E. Slauenwhite
 * @version February 5, 2006
 * @since 1.0.1
 */
public interface ConfigureSituation extends SituationType {

    /**
     * <p>
     * Returns the value of the '<em><b>Success Disposition</b></em>'
     * attribute.
     * </p>
     *  
     * 
     * @return the value of the '<em>Success Disposition</em>' attribute.
     * @see #setSuccessDisposition(String)
     */
    String getSuccessDisposition();

    /**
     * <p>
     * Sets the value of the '
     * {@link org.eclipse.tptp.logging.events.cbe.ConfigureSituation#getSuccessDisposition <em>Success Disposition</em>}'
     * attribute.
     * </p>
     * 
     * <P>
     * This property specifies whether or not the operation that caused the
     * situation to be reported was successful. The successDisposition is a
     * string with the following set of values:
     * <UL>
     * <LI>SUCCESSFUL</LI>
     * <LI>UNSUCCESSFUL</LI>
     * </UL>
     * </p>
     * <p>
     * This is a <em>required</em> property and once it is set it
     * <em>must not</em> change. The string length for this property
     * <em>must not</em> exceed 64 characters.
     * </p>
     * 
     * 
     * @param value
     *            the new value of the '<em>Success Disposition</em>'
     *            attribute.
     * @see #getSuccessDisposition()
     */
    void setSuccessDisposition(String value);

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * All components are initialized to either zero or null.
     * 
     * @since 1.0
     */
    void init();
} // ConfigureSituation
