package org.eclipse.tptp.logging.events.cbe;

/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ConnectSituation.java,v 1.1 2006/09/06 17:53:59 cjin Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Interface representing a <code>ConnectSituation</code>.
 * <p>
 * The following description is from the Common Base Event v1.0.1 specification
 * entitled "Canonical Situation Data Format: The Common Base Event V1.0.1":
 * <p>
 * The ConnectSituation deals with the situations that identify aspects about a
 * connection to another component. Messages that say a connection failed, that
 * a connection was created, or that a connection was ended all fall into this
 * category. Existing messages include words like connection reset, connection
 * failed, and failed to get a connection, for example:
 * <p>
 * <ul>
 * <li>DBMN0015W: Failure while creating connection {0}</li>
 * <br>
 * <li>DBMN0023W: Failed to close a connection {0}</li>
 * </ul>
 * <p>
 * 
 * 
 * @author Paul E. Slauenwhite
 * @version February 5, 2006
 * @since 1.0.1
 */
public interface ConnectSituation extends SituationType {

    /**
     * <p>
     * Returns the value of the '<em><b>Success Disposition</b></em>'
     * attribute.
     * </p>
     *  
     * 
     * @return the value of the '<em>Success Disposition</em>' attribute.
     * @see #setSuccessDisposition(String)
     */
    String getSuccessDisposition();

    /**
     * Sets the value of the '
     * {@link org.eclipse.tptp.logging.events.cbe.ConnectSituation#getSuccessDisposition <em>Success Disposition</em>}'
     * attribute. 
     * <P>
     * This property specifies whether or not the operation that caused the
     * situation to be reported was successful. The successDisposition is a
     * string with the following set of values:
     * <UL>
     * <LI>SUCCESSFUL</LI>
     * <LI>UNSUCCESSFUL</LI>
     * </UL>
     * </p>
     * <p>
     * This is a <em>required</em> property and once it is set it
     * <em>must not</em> change. The string length for this property
     * <em>must not</em> exceed 64 characters.
     * </p>
     * 
     * 
     * @param value
     *            the new value of the '<em>Success Disposition</em>'
     *            attribute.
     * @see #getSuccessDisposition()
     */
    void setSuccessDisposition(String value);

    /**
     * <p>
     * Returns the value of the '<em><b>Situation Disposition</b></em>'
     * attribute.
     * </p>
     *  
     * 
     * @return the value of the '<em>Situation Disposition</em>' attribute.
     * @see #setSituationDisposition(String)
     */
    String getSituationDisposition();

    /**
     * Sets the value of the '
     * {@link org.eclipse.tptp.logging.events.cbe.ConnectSituation#getSituationDisposition <em>Situation Disposition</em>}'
     * attribute. 
     * <P>
     * This property specifies the situation disposition that is a
     * representation of the parameters necessary to describe the situation. The
     * situationDisposition is a string with the following set of values:
     * <UL>
     * <LI>INUSE</LI>
     * <LI>FREED</LI>
     * <LI>CLOSED</LI>
     * <LI>AVAILABLE</LI>
     * </UL>
     * </p>
     * <p>
     * This is a <em>required</em> property and once it is set it
     * <em>must not</em> change. The string length for this property
     * <em>must not</em> exceed 64 characters.
     * </p>
     * 
     * 
     * @param value
     *            the new value of the '<em>Situation Disposition</em>'
     *            attribute.
     * @see #getSituationDisposition()
     */
    void setSituationDisposition(String value);

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * All components are initialized to either zero or null.
     * 
     * @since 1.0
     */
    void init();
} // ConnectSituation
