package org.eclipse.tptp.logging.events.cbe;

/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ContentHandler.java,v 1.1 2006/09/06 17:53:59 cjin Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Interface representing a <code>ContentHandler</code>.
 * <p>
 * Instances of <code>CommonBaseEvent</code> use a content handler to complete
 * the contents of the event instance or even modify existing fields.
 * <p>
 * 
 * 
 * @author  Paul E. Slauenwhite
 * @version February 9, 2006
 * @since   1.0.1
 */
public interface ContentHandler {

    /**
     * <p>
     * Allows the content handler to modify or complete the contents of the
     * event passed as a parameter.
     * </p>
     * 
     * @param event
     *            event to modified or completed.
     * 
     * @throws CompletionException
     *             if the event cannot be completed for whatever reason.
     */
    void completeEvent(CommonBaseEvent event) throws CompletionException;
}
