package org.eclipse.tptp.logging.events.cbe;

import java.io.Serializable;

/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ContextDataElement.java,v 1.1 2006/09/06 17:53:59 cjin Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Interface representing a <code>ContextDataElement</code>.
 * <p>
 * The following description is from the Common Base Event v1.0.1 specification
 * entitled "Canonical Situation Data Format: The Common Base Event V1.0.1":
 * <p>
 * The ContextDataElement type defines the contexts that this event references.
 * This complex type holds data that is used to assist with problem diagnostics
 * by correlating messages or events generated during execution of a unit of
 * work.
 * <p>
 * 
 * 
 * @author Paul E. Slauenwhite
 * @version February 5, 2006
 * @since 1.0.1
 */
public interface ContextDataElement extends Cloneable, Serializable {

    /**
     * <p>
     * Returns the value of the '<em><b>Context Id</b></em>' attribute.
     * </p>
     *  
     * 
     * @return the value of the '<em>Context Id</em>' attribute.
     * @see #setContextId(String)
     */
    String getContextId();

    /**
     * Sets the value of the '
     * {@link org.eclipse.tptp.logging.events.cbe.ContextDataElement#getContextId <em>Context Id</em>}'
     * attribute. 
     * <P>
     * This property is the reference to the globally unique identifier of the
     * element that contains the context.
     * </P>
     * <P>
     * This is <em>required</em> unless contextValue specifies a value.
     * </P>
     * 
     * 
     * @param value
     *            the new value of the '<em>Context Id</em>' attribute.
     * @see #getContextId()
     */
    void setContextId(String value);

    /**
     * <p>
     * Returns the value of the '<em><b>Context Value</b></em>' attribute.
     * </p>
     *  
     * 
     * @return the value of the '<em>Context Value</em>' attribute.
     * @see #setContextValue(String)
     */
    String getContextValue();

    /**
     * Sets the value of the '
     * {@link org.eclipse.tptp.logging.events.cbe.ContextDataElement#getContextValue <em>Context Value</em>}'
     * attribute. 
     * <P>
     * The value of the context with respect to the implementation of the
     * context.
     * </P>
     * <P>
     * This is <em>required</em> unless contextId specifies a value. The
     * string length for this property <em>must not</em> exceed 1024
     * characters.
     * </P>
     * 
     * 
     * @param value
     *            the new value of the '<em>Context Value</em>' attribute.
     * @see #getContextValue()
     */
    void setContextValue(String value);

    /**
     * <p>
     * Returns the value of the '<em><b>Name</b></em>' attribute.
     * </p>
     *  
     * 
     * @return the value of the '<em>Name</em>' attribute.
     * @see #setName(String)
     */
    String getName();

    /**
     * Sets the value of the '
     * {@link org.eclipse.tptp.logging.events.cbe.ContextDataElement#getName <em>Name</em>}'
     * attribute. 
     * <P>
     * Name of the application that created this context data element.
     * </P>
     * <P>
     * This is a <em>required</em> property. The string length for this
     * property <em>must not</em> exceed 64 characters.
     * </P>
     * 
     * 
     * @param value
     *            the new value of the '<em>Name</em>' attribute.
     * @see #getName()
     */
    void setName(String value);

    /**
     * <p>
     * Returns the value of the '<em><b>Type</b></em>' attribute.
     * </p>
     *  
     * 
     * @return the value of the '<em>Type</em>' attribute.
     * @see #setType(String)
     */
    String getType();

    /**
     * Sets the value of the '
     * {@link org.eclipse.tptp.logging.events.cbe.ContextDataElement#getType <em>Type</em>}'
     * attribute. 
     * <P>
     * The data type of the contextValue property.
     * </P>
     * <P>
     * This is a <em>required</em> property. The string length for this
     * property <em>must not</em> exceed 64 characters.
     * </P>
     * 
     * 
     * @param value
     *            the new value of the '<em>Type</em>' attribute.
     * @see #getType()
     */
    void setType(String value);

    /**
     * <p>
     * Checks whether the contents of this object conforms to the CBE
     * specification.
     * </p>
     * 
     * @throws ValidationException
     *             if the object does not follow the CBE specification.
     */
    void validate() throws ValidationException;

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * All components are initialized to either zero or null.
     * 
     * @since 1.0
     */
    void init();
} // ContextDataElement
