package org.eclipse.tptp.logging.events.cbe;

/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DependencySituation.java,v 1.1 2006/09/06 17:54:00 cjin Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Interface representing a <code>DependencySituation</code>.
 * <p>
 * The following description is from the Common Base Event v1.0.1 specification
 * entitled "Canonical Situation Data Format: The Common Base Event V1.0.1":
 * <p>
 * The DependencySituation deals with the situations that components produce to
 * say that they cannot find some component or feature they need. This category
 * includes messages about not finding the version of the component that was
 * expected. Messages that say a resource was not found or that an application
 * or subsystem that was unavailable also fall into this category. Existing
 * messages include words like "could not find", and "no such component", for
 * example:
 * <p>
 * <ul>
 * <li>WSVR0017E: Error encountered binding the J2EE resource, Pet Store JMS
 * Queue Connection Factory, as jms/queue/QueueConnectionFactory from
 * resources.xml no resource binder found</li>
 * </ul>
 * <p>
 * 
 * 
 * @author Paul E. Slauenwhite
 * @version February 5, 2006
 * @since 1.0.1
 */
public interface DependencySituation extends SituationType {

    /**
     * <p>
     * Returns the value of the '<em><b>Dependency Disposition</b></em>'
     * attribute.
     * </p>
     *  
     * 
     * @return the value of the '<em>Dependency Disposition</em>' attribute.
     * @see #setDependencyDisposition(String)
     */
    String getDependencyDisposition();

    /**
     * Sets the value of the '
     * {@link org.eclipse.tptp.logging.events.cbe.DependencySituation#getDependencyDisposition <em>Dependency Disposition</em>}'
     * attribute. 
     * <P>
     * This property specifies the dependency disposition of a feature of a
     * component that caused the situation to be reported. The
     * featureDisposition is a string with the following set of values:
     * <UL>
     * <LI>MET</LI>
     * <LI>NOT MET</LI>
     * </UL>
     * </p>
     * <p>
     * This is a <em>required</em> property and once it is set it
     * <em>must not</em> change. The string length for this property
     * <em>must not</em> exceed 64 characters.
     * </P>
     * 
     * 
     * @param value
     *            the new value of the '<em>Dependency Disposition</em>'
     *            attribute.
     * @see #getDependencyDisposition()
     */
    void setDependencyDisposition(String value);

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * All components are initialized to either zero or null.
     * 
     * @since 1.0
     */
    void init();
} // DependencySituation
