package org.eclipse.tptp.logging.events.cbe;

/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DestroySituation.java,v 1.1 2006/09/06 17:53:59 cjin Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Interface representing a <code>DestroySituation</code>.
 * <p>
 * The following description is from the Common Base Event v1.0.1 specification
 * entitled "Canonical Situation Data Format: The Common Base Event V1.0.1":
 * <p>
 * The DestroySituation deals with the situations documenting when an entity or
 * component was removed or destroyed. Messages telling that a document was
 * destroyed or a file was deleted all fall into this category. Existing message
 * include words like "was created", "about to create", and "now exists", for
 * example:
 * <p>
 * <ul>
 * <li>CONM6007I: The connection pool was destroyed for data source
 * (UDDI.Datasource.techs8.server1).</li>
 * </ul>
 * <p>
 * 
 * 
 * @author Paul E. Slauenwhite
 * @version February 5, 2006
 * @since 1.0.1
 */
public interface DestroySituation extends SituationType {

    /**
     * <p>
     * Returns the value of the '<em><b>Success Disposition</b></em>'
     * attribute.
     * </p>
     *  
     * 
     * @return the value of the '<em>Success Disposition</em>' attribute.
     * @see #setSuccessDisposition(String)
     */
    String getSuccessDisposition();

    /**
     * Sets the value of the '
     * {@link org.eclipse.tptp.logging.events.cbe.DestroySituation#getSuccessDisposition <em>Success Disposition</em>}'
     * attribute. 
     * <P>
     * This property specifies whether or not the operation that caused the
     * situation to be reported was successful. The successDisposition is a
     * string with the following set of values:
     * <UL>
     * <LI>SUCCESSFUL</LI>
     * <LI>UNSUCCESSFUL</LI>
     * </UL>
     * 
     * This is a <em>required</em> property and once it is set it
     * <em>must not</em> change. The string length for this property
     * <em>must not</em> exceed 64 characters.
     * </P>
     * 
     * 
     * @param value
     *            the new value of the '<em>Success Disposition</em>'
     *            attribute.
     * @see #getSuccessDisposition()
     */
    void setSuccessDisposition(String value);

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * All components are initialized to either zero or null.
     * 
     * @since 1.0
     */
    void init();
} // DestroySituation
