package org.eclipse.tptp.logging.events.cbe;

import org.eclipse.tptp.logging.events.cbe.impl.EventFactoryImpl;

/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: EventFactory.java,v 1.1 2006/09/06 17:53:59 cjin Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Interface representing an <code>EventFactory</code>.
 * <p>
 * It provides a create method for each non-abstract class of the model.
 * <p>
 * 
 * 
 * @author Paul E. Slauenwhite
 * @version February 5, 2006
 * @since 1.0.1
 */
public interface EventFactory {

    /**
     * The singleton instance of the factory.  <!--
     * end-user-doc -->
     * 
     */
    EventFactory eINSTANCE = new EventFactoryImpl();

    /**
     * Sets the <code>ContentHandler</code> associated with this event factory
     * instance.
     * <p>
     * <code>ContentHandler</code> s associated with this event factory
     * instance are assigned to each newly create event instance.
     * <p>
     * 
     * @param contentHandler
     *            The new <code>ContentHandler</code> associated with this
     *            event factory instance.
     */
    void setContentHandler(ContentHandler contentHandler);

    /**
     * Gets the <code>ContentHandler</code> associated with this event factory
     * instance.
     * <p>
     * <code>ContentHandler</code> s associated with this event factory
     * instance are assigned to each newly create event instance.
     * <p>
     * 
     * @return The <code>ContentHandler</code> associated with this event
     *         factory instance, otherwise null.
     */
    ContentHandler getContentHandler();

    /**
     * Sets the complete event configuration flag for this event factory
     * instance.
     * <p>
     * The complete event configuration flag instructs the event factory
     * instance to automatically complete newly create event instances using the
     * <code>ContentHandler</code> associated with this event factory
     * instance, if any.
     * <p>
     * If the complete event configuration flag is false, the event factory will
     * not automatically complete newly create event instances.
     * <p>
     * By default, the complete event configuration flag is false.
     * <p>
     * 
     * @param completeEvent
     *            The complete event configuration flag.
     */
    void setCompleteEvent(boolean completeEvent);

    /**
     * Gets the complete event configuration flag for this event factory
     * instance.
     * <p>
     * The complete event configuration flag instructs the event factory
     * instance to automatically complete newly create event instances using the
     * <code>ContentHandler</code> associated with this event factory
     * instance, if any.
     * <p>
     * If the complete event configuration flag is false, the event factory will
     * not automatically complete newly create event instances.
     * <p>
     * By default, the complete event configuration flag is false.
     * <p>
     * 
     * @return True if the complete event configuration flag is set, otherwise
     *         false.
     */
    boolean getCompleteEvent();

    /**
     * <p>
     * Returns a new object of class '<em>Associated Event</em>'.
     * </p>
     *  
     * 
     * @return a new object of class '<em>Associated Event</em>'.
     */
    AssociatedEvent createAssociatedEvent();

    /**
     * <p>
     * Returns a new object of class '<em>Association Engine</em>'.
     * </p>
     *  
     * 
     * @return a new object of class '<em>Association Engine</em>'.
     */
    AssociationEngine createAssociationEngine();

    /**
     * <p>
     * Returns a new object of class '<em>Available Situation</em>'.
     * </p>
     *  
     * 
     * @return a new object of class '<em>Available Situation</em>'.
     */
    AvailableSituation createAvailableSituation();

    /**
     * <p>
     * Returns a new object of class '<em>Common Base Event</em>'.
     * </p>
     *  
     * 
     * @return a new object of class '<em>Common Base Event</em>'.
     */
    CommonBaseEvent createCommonBaseEvent();

    /**
     * <p>
     * Returns a new object of class '<em>Common Base Event</em>'.
     * </p>
     * <P>
     * 
     * @param extensionName
     *            the extension name for the newly returned event or null.
     * 
     * @return a new object of class '<em>Common Base Event</em>'.
     */
    CommonBaseEvent createCommonBaseEvent(String extensionName);

    /**
     * <p>
     * Returns a new object of class '<em>Common Base Event</em>'.
     * </p>
     * 
     * @param extensionName
     *            the extension name for the newly returned event or null.
     * @param creationTime
     *            the creation time, in xsd:dateTime format, for the newly
     *            created event or -1.
     * 
     * @return a new object of class '<em>Common Base Event</em>'.
     */
    CommonBaseEvent createCommonBaseEvent(String extensionName, long creationTime);

    /**
     * <p>
     * Returns a new object of class '<em>Common Base Event</em>'.
     * </p>
     * 
     * @param severity
     *            the severity of the event being created or -1
     * @param situation
     *            the situation of the event being created or null
     * @param msg
     *            the msg of the CommonBaseEvent created or null
     * 
     * @return a new object of class '<em>Common Base Event</em>'.
     */
    CommonBaseEvent createCommonBaseEvent(short severity, Situation situation, String msg);

    /**
     * <p>
     * Returns a new object of class '<em>Common Base Event</em>'.
     * </p>
     * 
     * @param severity
     *            the severity of the event being created or -1
     * @param situation
     *            the situation of the event being created or null
     * @param msgCatalogId
     *            the msgCatalogId of the MsgDataElement of the CommonBaseEvent
     *            being created or null
     * @param msgCatalogTokens
     *            the msgCatalogTokens of the MsgDataElement of the
     *            CommonBaseEvent being created or null
     * @param msgId
     *            the msgId of the MsgDataElement of the CommonBaseEvent being
     *            created or null
     * @param msg
     *            the msg of the CommonBaseEvent created or null
     * 
     * @return a new object of class '<em>Common Base Event</em>'.
     */
    CommonBaseEvent createCommonBaseEvent(short severity, Situation situation, String msgCatalogId, String[] msgCatalogTokens, String msgId, String msg);

    /**
     * <p>
     * Returns a new object of class '<em>Common Base Event</em>'.
     * </p>
     * 
     * @param severity
     *            the severity of the event being created or -1
     * @param reporterCompId
     *            the reporter component Id of the event being created or null
     * @param sourceCompId
     *            the source component Id of the event being created or null
     * @param situation
     *            the situation of the event being created or null
     * @param msg
     *            the msg of the CommonBaseEvent created or null
     * 
     * @return a new object of class '<em>Common Base Event</em>'.
     */
    CommonBaseEvent createCommonBaseEvent(short severity, ComponentIdentification reporterCompId, ComponentIdentification sourceCompId, Situation situation, String msg);

    /**
     * <p>
     * Returns a new object of class '<em>Common Base Event</em>'.
     * </p>
     * 
     * @param severity
     *            the severity of the event being created or -1
     * @param reporterCompId
     *            the reporter component Id of the event being created or null
     * @param sourceCompId
     *            the source component Id of the event being created or null
     * @param situation
     *            the situation of the event being created or null
     * @param msgCatalogId
     *            the msgCatalogId of the MsgDataElement of the CommonBaseEvent
     *            being created or null
     * @param msgCatalogTokens
     *            the msgCatalogTokens of the MsgDataElement of the
     *            CommonBaseEvent being created or null
     * @param msgId
     *            the msgId of the MsgDataElement of the CommonBaseEvent being
     *            created or null
     * @param msg
     *            the msg of the CommonBaseEvent created or null
     * 
     * @return a new object of class '<em>Common Base Event</em>'.
     */
    CommonBaseEvent createCommonBaseEvent(short severity, ComponentIdentification reporterCompId, ComponentIdentification sourceCompId, Situation situation, String msgCatalogId, String[] msgCatalogTokens, String msgId, String msg);

    /**
     * <p>
     * Returns a new object of class '<em>Component Identification</em>'.
     * </p>
     *  
     * 
     * @return a new object of class '<em>Component Identification</em>'.
     */
    ComponentIdentification createComponentIdentification();

    /**
     * <p>
     * Returns a new object of class '<em>Configure Situation</em>'.
     * </p>
     *  
     * 
     * @return a new object of class '<em>Configure Situation</em>'.
     */
    ConfigureSituation createConfigureSituation();

    /**
     * <p>
     * Returns a new object of class '<em>Connect Situation</em>'.
     * </p>
     *  
     * 
     * @return a new object of class '<em>Connect Situation</em>'.
     */
    ConnectSituation createConnectSituation();

    /**
     * <p>
     * Returns a new object of class '<em>Context Data Element</em>'.
     * </p>
     *  
     * 
     * @return a new object of class '<em>Context Data Element</em>'.
     */
    ContextDataElement createContextDataElement();

    /**
     * <p>
     * Returns a new object of class '<em>Create Situation</em>'.
     * </p>
     *  
     * 
     * @return a new object of class '<em>Create Situation</em>'.
     */
    CreateSituation createCreateSituation();

    /**
     * <p>
     * Returns a new object of class '<em>Dependency Situation</em>'.
     * </p>
     *  
     * 
     * @return a new object of class '<em>Dependency Situation</em>'.
     */
    DependencySituation createDependencySituation();

    /**
     * <p>
     * Returns a new object of class '<em>Destroy Situation</em>'.
     * </p>
     *  
     * 
     * @return a new object of class '<em>Destroy Situation</em>'.
     */
    DestroySituation createDestroySituation();

    /**
     * <p>
     * Returns a new object of class '<em>Extended Data Element</em>'.
     * </p>
     *  
     * 
     * @return a new object of class '<em>Extended Data Element</em>'.
     */
    ExtendedDataElement createExtendedDataElement();

    /**
     * <p>
     * Returns a new object of class '<em>Feature Situation</em>'.
     * </p>
     *  
     * 
     * @return a new object of class '<em>Feature Situation</em>'.
     */
    FeatureSituation createFeatureSituation();

    /**
     * Produces a globally unique identifier according to the Open Group
     * algorithm.
     * <P>
     * The algorithm is described in
     * {@link <a href="http://www.opengroup.org/dce/info/draft-leach-uuids-guids-01.txt">http://www.opengroup.org/dce/info/draft-leach-uuids-guids-01.txt</a>}
     * </p>
     * <P>
     * The produced identifier is always prefixed with "CE" so that it does not
     * clash with identifiers produced by another application using the same
     * algorithm.
     * </p>
     * 
     * @return a globally unique identifier according to the algorithm above.
     */
    String createGlobalInstanceId();

    /**
     * <p>
     * Returns a new object of class '<em>Msg Catalog Token</em>'.
     * </p>
     *  
     * 
     * @return a new object of class '<em>Msg Catalog Token</em>'.
     */
    MsgCatalogToken createMsgCatalogToken();

    /**
     * <p>
     * Returns a new object of class '<em>Msg Data Element</em>'.
     * </p>
     *  
     * 
     * @return a new object of class '<em>Msg Data Element</em>'.
     */
    MsgDataElement createMsgDataElement();

    /**
     * <p>
     * Returns a new object of class '<em>Other Situation</em>'.
     * </p>
     *  
     * 
     * @return a new object of class '<em>Other Situation</em>'.
     */
    OtherSituation createOtherSituation();

    /**
     * <p>
     * Returns a new object of class '<em>Report Situation</em>'.
     * </p>
     *  
     * 
     * @return a new object of class '<em>Report Situation</em>'.
     */
    ReportSituation createReportSituation();

    /**
     * <p>
     * Returns a new object of class '<em>Request Situation</em>'.
     * </p>
     *  
     * 
     * @return a new object of class '<em>Request Situation</em>'.
     */
    RequestSituation createRequestSituation();

    /**
     * <p>
     * Returns a new object of class '<em>Situation</em>'.
     * </p>
     *  
     * 
     * @return a new object of class '<em>Situation</em>'.
     */
    Situation createSituation();

    /**
     * <p>
     * Returns a new object of class '<em>Start Situation</em>'.
     * </p>
     *  
     * 
     * @return a new object of class '<em>Start Situation</em>'.
     */
    StartSituation createStartSituation();

    /**
     * <p>
     * Returns a new object of class '<em>Stop Situation</em>'.
     * </p>
     *  
     * 
     * @return a new object of class '<em>Stop Situation</em>'.
     */
    StopSituation createStopSituation();

} // EventFactory
