package org.eclipse.tptp.logging.events.cbe;

import org.eclipse.tptp.logging.events.cbe.impl.EventFactoryImpl;

/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: EventFactoryFactory.java,v 1.2 2008/01/24 02:29:31 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Class representing an <code>EventFactoryFactory</code>.
 * <p>
 * Factory for <code>EventFactory</code> instances.
 * <p>
 * 
 * 
 * @author     Paul E. Slauenwhite
 * @version    February 9, 2006
 * @since      1.0.1
 * @deprecated As of TPTP v4.0.0, replaced by
 *             <code>org.eclipse.tptp.logging.events.cbe.EventFactoryHome</code>.
 */
public final class EventFactoryFactory {

    /**
     * <p>
     * Creates a simple <code>EventFactory</code> object.
     * </p>
     * 
     * @return the created instance.
     */
    public static EventFactory createEventFactory() {
        return new EventFactoryImpl();
    }

    /**
     * <p>
     * Creates an <code>EventFactory</code> object associated with a
     * <code>ContentHandler</code>.
     * </p>
     * 
     * @param handler
     *            handler to be associated with the factory.
     * 
     * @return the created instance.
     */
    public static EventFactory createEventFactory(ContentHandler handler) {
        EventFactoryImpl result = new EventFactoryImpl();
        result.setContentHandler(handler);
        return result;
    }

    /*
     * Private methods.
     */

    /**
     * Private constructor to prevent instantiation of this class.
     */
    protected EventFactoryFactory() {
    }
}
