package org.eclipse.tptp.logging.events.cbe;

/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FeatureSituation.java,v 1.1 2006/09/06 17:53:59 cjin Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Interface representing a <code>FeatureSituation</code>.
 * <p>
 * The following description is from the Common Base Event v1.0.1 specification
 * entitled "Canonical Situation Data Format: The Common Base Event V1.0.1":
 * <p>
 * The FeatureSituation deals with the situations that announce that a feature
 * of a component is now ready (or not ready) for service requests. Situations
 * that indicate things like services being available and services or features
 * being unavailable fall into this category. Existing situations include words
 * like "now available", "currently available", and "transport is listening on
 * port 123", for example:
 * <p>
 * <ul>
 * <li>SRVE0171I: Transport HTTPS is listening on port 9443</li>
 * <br>
 * <li>MSGS0601I: WebSphere Embedded Messaging has not been installed</li>
 * </ul>
 * <p>
 * 
 * 
 * @author Paul E. Slauenwhite
 * @version February 5, 2006
 * @since 1.0.1
 */
public interface FeatureSituation extends SituationType {

    /**
     * <p>
     * Returns the value of the '<em><b>Feature Disposition</b></em>'
     * attribute.
     * </p>
     *  
     * 
     * @return the value of the '<em>Feature Disposition</em>' attribute.
     * @see #setFeatureDisposition(String)
     */
    String getFeatureDisposition();

    /**
     * Sets the value of the '
     * {@link org.eclipse.tptp.logging.events.cbe.FeatureSituation#getFeatureDisposition <em>Feature Disposition</em>}'
     * attribute. 
     * <P>
     * This property specifies the availability disposition of a feature of a
     * component that caused the situation to be reported. The
     * featureDisposition is a string with the following set of values:
     * <UL>
     * <LI>AVAILABLE</LI>
     * <LI>NOT AVAILABLE</LI>
     * </UL>
     * </p>
     * <p>
     * This is a <em>required</em> property and once it is set it
     * <em>must not</em> change. The string length for this property
     * <em>must not</em> exceed 64 characters.
     * </P>
     * 
     * 
     * @param value
     *            the new value of the '<em>Feature Disposition</em>'
     *            attribute.
     * @see #getFeatureDisposition()
     */
    void setFeatureDisposition(String value);

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * All components are initialized to either zero or null.
     * 
     * @since 1.0
     */
    void init();
} // FeatureSituation
