package org.eclipse.tptp.logging.events.cbe;

import java.io.Serializable;

/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MsgCatalogToken.java,v 1.1 2006/09/06 17:53:59 cjin Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Interface representing a <code>MsgCatalogToken</code>.
 * <p>
 * The following description is from the Common Base Event v1.0.1 specification
 * entitled "Canonical Situation Data Format: The Common Base Event V1.0.1":
 * <p>
 * A string used as substitution value for resolving an internationalized
 * message into formatted text.
 * <p>
 * 
 * 
 * @author Paul E. Slauenwhite
 * @version February 5, 2006
 * @since 1.0.1
 */
public interface MsgCatalogToken extends Cloneable, Serializable {

    /**
     * <p>
     * Returns the value of the '<em><b>Value</b></em>' attribute.
     * </p>
     *  
     * 
     * @return the value of the '<em>Value</em>' attribute.
     * @see #setValue(String)
     */
    String getValue();

    /**
     * Sets the value of the '
     * {@link org.eclipse.tptp.logging.events.cbe.MsgCatalogToken#getValue <em>Value</em>}'
     * attribute. 
     * <P>
     * The string length for value <em>must not</em> exceed 256 characters.
     * </P>
     * 
     * 
     * @param value
     *            the new value of the '<em>Value</em>' attribute.
     * @see #getValue()
     */
    void setValue(String value);

    /**
     * <p>
     * Checks whether the contents of the instance conform to the CBE
     * specification.
     * </p>
     * 
     * @throws ValidationException
     *             if the message catalog token does not follow the CBE
     *             specification.
     */
    void validate() throws ValidationException;

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * All components are initialized to either zero or null.
     * 
     * @since 1.0
     */
    void init();
} // MsgCatalogToken
