package org.eclipse.tptp.logging.events.cbe;

/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OtherSituation.java,v 1.1 2006/09/06 17:53:59 cjin Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Interface representing an <code>OtherSituation</code>.
 * <p>
 * The following description is from the Common Base Event v1.0.1 specification
 * entitled "Canonical Situation Data Format: The Common Base Event V1.0.1":
 * <p>
 * The OtherSituation category is to provide support for the situation that is
 * product specific requirement other than the predefined categories.
 * <p>
 * 
 * 
 * @author Paul E. Slauenwhite
 * @version February 5, 2006
 * @since 1.0.1
 */
public interface OtherSituation extends SituationType {

    /**
     * <p>
     * Returns the value of the '<em><b>Any</b></em>' attribute.
     * </p>
     *  
     * 
     * @return the value of the '<em>Any</em>' attribute.
     * @see #setAny(String)
     */
    String getAny();

    /**
     * Sets the value of the '
     * {@link org.eclipse.tptp.logging.events.cbe.OtherSituation#getAny <em>Any</em>}'
     * attribute. 
     * <p>
     * The CBE specification does not restrict the contents of this value in any
     * way.
     * </P>
     * 
     * 
     * @param value
     *            the new value of the '<em>Any</em>' attribute.
     * @see #getAny()
     */
    void setAny(String value);

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * All components are initialized to either zero or null.
     * 
     * @since 1.0
     */
    void init();
} // OtherSituation
