package org.eclipse.tptp.logging.events.cbe;

/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ReportSituation.java,v 1.1 2006/09/06 17:53:59 cjin Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Interface representing a <code>ReportSituation</code>.
 * <p>
 * The following description is from the Common Base Event v1.0.1 specification
 * entitled "Canonical Situation Data Format: The Common Base Event V1.0.1":
 * <p>
 * The ReportSituation deals with the situations reported from the component,
 * such as heartbeat or performance information. Data such as current CPU
 * utilization, current memory heap size, etc. would fall into this category.
 * Existing messages include words like "utilization value is", "buffer size
 * is", and "number of threads is", for example:
 * <p>
 * <ul>
 * <li>IEE890I WTO Buffers in console backup storage = 1024</li>
 * </ul>
 * <p>
 * 
 * 
 * @author Paul E. Slauenwhite
 * @version February 5, 2006
 * @since 1.0.1
 */
public interface ReportSituation extends SituationType {

    /**
     * <p>
     * Returns the value of the '<em><b>Report Category</b></em>'
     * attribute.
     * </p>
     *  
     * 
     * @return the value of the '<em>Report Category</em>' attribute.
     * @see #setReportCategory(String)
     */
    String getReportCategory();

    /**
     * Sets the value of the '
     * {@link org.eclipse.tptp.logging.events.cbe.ReportSituation#getReportCategory <em>Report Category</em>}'
     * attribute. 
     * <P>
     * This property specifies the category of the reported situation. The
     * reportCategory is a string with the following set of values:
     * <UL>
     * <LI>PERFORMANCE</LI>
     * <LI>SECURITY</LI>
     * <LI>HEARTBEAT</LI>
     * <LI>STATUS</LI>
     * </UL>
     * This is a <em>required</em> property and once it is set it
     * <em>must not</em> change. The string length for this property
     * <em>must not</em> exceed 64 characters.
     * </P>
     * 
     * 
     * @param value
     *            the new value of the '<em>Report Category</em>' attribute.
     * @see #getReportCategory()
     */
    void setReportCategory(String value);

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * All components are initialized to either zero or null.
     * 
     * @since 1.0
     */
    void init();
} // ReportSituation
