package org.eclipse.tptp.logging.events.cbe;

/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: StartSituation.java,v 1.1 2006/09/06 17:54:00 cjin Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Interface representing a <code>StartSituation</code>.
 * <p>
 * The following description is from the Common Base Event v1.0.1 specification
 * entitled "Canonical Situation Data Format: The Common Base Event V1.0.1":
 * <p>
 * The StartSituation deals with the start up process for a component. Messages
 * that indicate that a component has begun the startup process, that it has
 * finished the startup process, or that it has aborted the startup process all
 * fall into this category. Existing messages include words like "starting",
 * "started", "initializing", and "initialized", for example:
 * <p>
 * <ul>
 * <li>DIA3206I The TCP/IP protocol support was started successfully.</li>
 * <br>
 * <li>DIA3000I "%1S" protocol support was successfully started.</li>
 * <br>
 * <li>DIA3001E "%1S" protocol support was not successfully started.</li>
 * <br>
 * <li>WSVR0037I: Starting EJB jar: {0}</li>
 * </ul>
 * <p>
 * 
 * 
 * @author Paul E. Slauenwhite
 * @version February 5, 2006
 * @since 1.0.1
 */
public interface StartSituation extends SituationType {

    /**
     * <p>
     * Returns the value of the '<em><b>Success Disposition</b></em>'
     * attribute.
     * </p>
     *  
     * 
     * @return the value of the '<em>Success Disposition</em>' attribute.
     * @see #setSuccessDisposition(String)
     */
    String getSuccessDisposition();

    /**
     * Sets the value of the '
     * {@link org.eclipse.tptp.logging.events.cbe.StartSituation#getSuccessDisposition <em>Success Disposition</em>}'
     * attribute. 
     * <P>
     * This property specifies whether or not the operation that caused the
     * situation to be reported was successful. The successDisposition is a
     * string with the following set of values:
     * <UL>
     * <LI>SUCCESSFUL</LI>
     * <LI>UNSUCCESSFUL</LI>
     * </UL>
     * </p>
     * <p>
     * This is a <em>required</em> property and once it is set it
     * <em>must not</em> change. The string length for this property
     * <em>must not</em> exceed 64 characters.
     * </P>
     * 
     * 
     * @param value
     *            the new value of the '<em>Success Disposition</em>'
     *            attribute.
     * @see #getSuccessDisposition()
     */
    void setSuccessDisposition(String value);

    /**
     * <p>
     * Returns the value of the '<em><b>Situation Qualifier</b></em>'
     * attribute.
     * </p>
     *  
     * 
     * @return the value of the '<em>Situation Qualifier</em>' attribute.
     * @see #setSituationQualifier(String)
     */
    String getSituationQualifier();

    /**
     * Sets the value of the '
     * {@link org.eclipse.tptp.logging.events.cbe.StartSituation#getSituationQualifier <em>Situation Qualifier</em>}'
     * attribute. 
     * <P>
     * This property specifies the situation qualifiers that are representation
     * of the parameters necessary to describe the situation.
     * </p>
     * <p>
     * The situationQualifier is a string with the following set of values:
     * <UL>
     * <LI>START INITIATED</LI>
     * <LI>RESTART INITIATED</LI>
     * <LI>START COMPLETED</LI>
     * </UL>
     * </p>
     * <p>
     * This is a <em>required</em> property and once it is set it
     * <em>must not</em> change. The string length for this property
     * <em>must not</em> exceed 64 characters.
     * </P>
     * 
     * 
     * @param value
     *            the new value of the '<em>Situation Qualifier</em>'
     *            attribute.
     * @see #getSituationQualifier()
     */
    void setSituationQualifier(String value);

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * All components are initialized to either zero or null.
     * 
     * @since 1.0
     */
    void init();
} // StartSituation
