package org.eclipse.tptp.logging.events.cbe.impl;

import org.eclipse.hyades.internal.logging.core.internationalization.InternationalizationUtilities;
import org.eclipse.hyades.logging.core.LoggingCoreResourceBundle;
import org.eclipse.tptp.logging.events.cbe.AssociationEngine;
import org.eclipse.tptp.logging.events.cbe.MissingPropertyException;
import org.eclipse.tptp.logging.events.cbe.ValidationException;

/**********************************************************************
 * Copyright (c) 2005, 2006,2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AssociationEngineImpl.java,v 1.2 2007/04/09 04:35:53 cjin Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Class representing an implementation of an <code>AssociationEngine</code>.
 * <p>
 * The following description is from the Common Base Event v1.0.1 specification
 * entitled "Canonical Situation Data Format: The Common Base Event V1.0.1":
 * <p>
 * The AssociationEngine identifies the application that establishes
 * associations among related or associated events. In addition, it provides
 * properties to describe the types of the associations.
 * <p>
 * The AssociationEngine is a standalone entity in the XML schema and the
 * AssociatedEvents created by the application that is identified by the
 * AssociationEngine refer to it. This will eliminate the need to repeat the
 * same data in every associated event.
 * <p>
 * 
 * @author Cindy Jin
 * @author Paul E. Slauenwhite
 * @version March 30, 2007
 * @since 1.0.1
 */
public class AssociationEngineImpl implements AssociationEngine {

    /** Automatically generated javadoc for: serialVersionUID */
    private static final long serialVersionUID = -6792679299982203134L;

    /**
     * The cached value of the '{@link #getId() <em>Id</em>}' attribute. <!--
     * begin-user-doc --> 
     * 
     * @see #getId()
     */
    protected String id = null;

    /**
     * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
     *  
     * 
     * @see #getName()
     */
    protected String name = null;

    /**
     * The cached value of the '{@link #getType() <em>Type</em>}' attribute.
     *  
     * 
     * @see #getType()
     */
    protected String type = null;

    /**
     *  
     * 
     */
    protected AssociationEngineImpl() {
        super();
    }

    /**
     *  
     * 
     */
    public void setId(String newId) {
        id = newId;
    }

    /**
     *  
     * 
     */
    public String getId() {
        return id;
    }

    /**
     *  
     * 
     */
    public void setName(String newName) {
        name = newName;
    }

    /**
     *  
     * 
     */
    public String getName() {
        return name;
    }

    /**
     *  
     * 
     */
    public void setType(String newType) {
        type = newType;
    }

    /**
     *  
     * 
     */
    public String getType() {
        return type;
    }

    /**
     * Overrides the <code>java.lang.Object</code>'s equals() API to 
     * determine if the parameter <code>object</code> is equal to this object.
     * <p>
     * 
     * @param object The <code>java.lang.Object</code> to be compared to this object.
     * @return True, if this object is the same as the parameter <code>object</code>, otherwise false.
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object object) {

        synchronized (this) {
            
            //Check if the parameter object is the same object reference as this object (e.g. equal):
            if (this == object){
                return true;
            }
            else {

                //Check if the parameter object is null and is the a different type as this object(e.g. not equal):
                if ((object != null) && (getClass() == object.getClass())) {

                    //Compare the value(s) of all object properties:
                    Object thisObjectsProperty = getId();
                    Object parameterObjectsProperty = ((AssociationEngineImpl) (object)).getId();

                    if (((thisObjectsProperty != null) && (thisObjectsProperty.equals(parameterObjectsProperty))) || ((thisObjectsProperty == null) && (parameterObjectsProperty == null))) {

                        thisObjectsProperty = getName();
                        parameterObjectsProperty = ((AssociationEngineImpl) (object)).getName();

                        if (((thisObjectsProperty != null) && (thisObjectsProperty.equals(parameterObjectsProperty))) || ((thisObjectsProperty == null) && (parameterObjectsProperty == null))) {

                            thisObjectsProperty = getType();
                            parameterObjectsProperty = ((AssociationEngineImpl) (object)).getType();

                            if (((thisObjectsProperty != null) && (thisObjectsProperty.equals(parameterObjectsProperty))) || ((thisObjectsProperty == null) && (parameterObjectsProperty == null))) {
                                return true;
                            }
                        }
                    }
                }
            }

            return false;
        }
    }

    /**
     *  
     * 
     */
    public String toString() {

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (id: ");
        result.append(id);
        result.append(", name: ");
        result.append(name);
        result.append(", type: ");
        result.append(type);
        result.append(')');
        return result.toString();
    }

    /**
     * Checks whether the contents of the instance conform to the Common Base Event 
     * specification as described in "Canonical Situation Data Format: The Common Base Event 
     * V1.0.1".
     * <p>
     * 
     * @throws ValidationException If the event instance does not conform to the Common Base Event specification.
     */
    public void validate() throws ValidationException {

        synchronized (this) {

            //Step 1:  Check for required properties:
            if(name == null){
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString("LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", "CommonBaseEvent.AssociatedEvent.AssociationEngine.Name")); 
            }

            if(type == null){
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString("LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", "CommonBaseEvent.AssociatedEvent.AssociationEngine.Type")); 
            }

            if(id == null){
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString("LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", "CommonBaseEvent.AssociatedEvent.AssociationEngine.Id")); 
            }

            //Step 2:  Check content of each property:
            if(name.length() > 64){
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LENGTH_EXC_", "CommonBaseEvent.AssociatedEvent.AssociationEngine.Name", name, new Integer(name.length()), new Integer(64)));
            }

            if(type.length() > 64){
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LENGTH_EXC_", "CommonBaseEvent.AssociatedEvent.AssociationEngine.Name", name, new Integer(name.length()), new Integer(64)));
            }
            
            if((id.length() < 32) || (id.length() > 64)){
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_GLOBAL_INSTANCE_ID_LENGTH_EXC_","CommonBaseEvent.AssociatedEvent.AssociationEngine.Id", id));
            }
            else if(!Character.isLetter(InternationalizationUtilities.charAt(id,0))){
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_GLOBAL_INSTANCE_ID_EXC_","CommonBaseEvent.AssociatedEvent.AssociationEngine.Id", id));
            }
        }
    }

    /**
     * Return a cloned (copy by value) object of this object. 
     * <p>
     * This is a deep copy version, in which all the objects 
     * within this object will be copied by value.
     * <p>
     * 
     * @return Object The cloned (copy by value) object of this object.
     * @throws CloneNotSupportedException If a instance variable of this object does not implement the <code>Cloneable</code> interface.   
     */
    public Object clone() throws CloneNotSupportedException {

        synchronized (this) {

            AssociationEngineImpl copy = ((AssociationEngineImpl) (super.clone()));

            if(this.id != null){
                copy.setId(new String(this.id));                                
            }

            if(this.name != null){
                copy.setName(new String(this.name));                                
            }

            if(this.type != null){
                copy.setType(new String(this.type));                                
            }

            return copy;
        }
    }

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * <p>
     * 
     * @since 1.0
     */
    public void init() {

        setName(null);
        setType(null);
        setId(null);
    }
}