package org.eclipse.tptp.logging.events.cbe.impl;

import org.eclipse.hyades.logging.core.LoggingCoreResourceBundle;
import org.eclipse.tptp.logging.events.cbe.AvailableSituation;
import org.eclipse.tptp.logging.events.cbe.MissingPropertyException;
import org.eclipse.tptp.logging.events.cbe.ValidationException;

/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AvailableSituationImpl.java,v 1.1 2006/09/06 17:54:04 cjin Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Class representing an implementation of an <code>AvailableSituation</code>.
 * <p>
 * The following description is from the Common Base Event v1.0.1 specification
 * entitled "Canonical Situation Data Format: The Common Base Event V1.0.1":
 * <p>
 * The AvailableSituation deals with the situations reported from the component
 * regarding its operational state and availability. This situation provides a
 * context for operations that can be performed on the component by
 * distinguishing if a product is installed, operational, and ready to process
 * functional requests. Or, operational and ready/not ready to process
 * management requests. Existing messages include words like those that indicate
 * it is ready to take requests, both online and offline. For example:
 * <p>
 * <ul>
 * <li>ADMC0013I: SOAP connector available at port 8880</li>
 * <br>
 * <li>ADMC0026I: RMI Connector available at port 2809</li>
 * </ul>
 * <p>
 * 
 * 
 * @author Paul E. Slauenwhite
 * @version February 5, 2006
 * @since 1.0.1
 */
public class AvailableSituationImpl extends SituationTypeImpl implements AvailableSituation {

    /** Automatically generated javadoc for: serialVersionUID */
    private static final long serialVersionUID = 8909448887998100984L;

    /**
     * The cached value of the '
     * {@link #getOperationDisposition() <em>Operation Disposition</em>}'
     * attribute.  
     * 
     * @see #getOperationDisposition()
     */
    protected String operationDisposition = null;

    /**
     * The cached value of the '
     * {@link #getAvailabilityDisposition() <em>Availability Disposition</em>}'
     * attribute.  
     * 
     * @see #getAvailabilityDisposition()
     */
    protected String availabilityDisposition = null;

    /**
     * The cached value of the '
     * {@link #getProcessingDisposition() <em>Processing Disposition</em>}'
     * attribute.  
     * 
     * @see #getProcessingDisposition()
     */
    protected String processingDisposition = null;

    /**
     *  
     * 
     */
    protected AvailableSituationImpl() {
        super();
    }

    /**
     *  
     * 
     */
    public String getOperationDisposition() {
        return operationDisposition;
    }

    /**
     *  
     * 
     */
    public void setOperationDisposition(String newOperationDisposition) {
        operationDisposition = newOperationDisposition;
    }

    /**
     *  
     * 
     */
    public String getAvailabilityDisposition() {
        return availabilityDisposition;
    }

    /**
     *  
     * 
     */
    public void setAvailabilityDisposition(String newAvailabilityDisposition) {
        availabilityDisposition = newAvailabilityDisposition;
    }

    /**
     *  
     * 
     */
    public String getProcessingDisposition() {
        return processingDisposition;
    }

    /**
     *  
     * 
     */
    public void setProcessingDisposition(String newProcessingDisposition) {
        processingDisposition = newProcessingDisposition;
    }

    /**
     *  
     * 
     */
    public String toString() {

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (operationDisposition: ");
        result.append(operationDisposition);
        result.append(", availabilityDisposition: ");
        result.append(availabilityDisposition);
        result.append(", processingDisposition: ");
        result.append(processingDisposition);
        result.append(')');
        return result.toString();
    }

    /**
     * Checks whether the contents of the instance conform to the Common Base Event 
     * specification as described in "Canonical Situation Data Format: The Common Base Event 
     * V1.0.1".
     * <p>
     * 
     * @throws ValidationException If the event instance does not conform to the Common Base Event specification.
     */
    public void validate() throws ValidationException {

        synchronized (this) {

            super.validate();

            //Step 1:  Check for required properties:
            if(operationDisposition == null){
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString("LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", "CommonBaseEvent.Situation.AvailableSituation.OperationDisposition")); 
            }

            if(availabilityDisposition == null){
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString("LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", "CommonBaseEvent.Situation.AvailableSituation.AvailabilityDisposition")); 
            }

            if(processingDisposition == null){
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString("LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", "CommonBaseEvent.Situation.AvailableSituation.ProcessingDisposition")); 
            }

            //Step 2:  Check content of each property:
            if(operationDisposition.length() > 64){
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LENGTH_EXC_", "CommonBaseEvent.Situation.AvailableSituation.OperationDisposition", operationDisposition, new Integer(operationDisposition.length()), new Integer(64)));
            }

            if(availabilityDisposition.length() > 64){
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LENGTH_EXC_", "CommonBaseEvent.Situation.AvailableSituation.AvailabilityDisposition", availabilityDisposition, new Integer(availabilityDisposition.length()), new Integer(64)));
            }

            if(processingDisposition.length() > 64){
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LENGTH_EXC_", "CommonBaseEvent.Situation.AvailableSituation.ProcessingDisposition", processingDisposition, new Integer(processingDisposition.length()), new Integer(64)));
            }
        }
    }

    /**
     * Return a cloned (copy by value) object of this object. 
     * <p>
     * This is a deep copy version, in which all the objects 
     * within this object will be copied by value.
     * <p>
     * 
     * @return Object The cloned (copy by value) object of this object.
     * @throws CloneNotSupportedException If a instance variable of this object does not implement the <code>Cloneable</code> interface.   
     */
    public Object clone() throws CloneNotSupportedException {

        synchronized (this) {

            AvailableSituationImpl copy = ((AvailableSituationImpl) (super.clone()));

            if(this.availabilityDisposition != null){
                copy.setAvailabilityDisposition(new String(this.availabilityDisposition));                                
            }

            if(this.operationDisposition != null){
                copy.setOperationDisposition(new String(this.operationDisposition));                                
            }

            if(this.processingDisposition != null){
                copy.setProcessingDisposition(new String(this.processingDisposition));                                
            }

            return copy;
        }
    }

    /**
     * Overrides the <code>java.lang.Object</code>'s equals() API to 
     * determine if the parameter <code>object</code> is equal to this object.
     * <p>
     * 
     * @param object The <code>java.lang.Object</code> to be compared to this object.
     * @return True, if this object is the same as the parameter <code>object</code>, otherwise false.
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object object) {

        synchronized (this) {
            
            //Check if the parameter object is the same object reference as this object (e.g. equal):
            if (this == object){
                return true;
            }
            else {

                //Check if the parameter object is null and is the a different type as this object(e.g. not equal):
                if ((object != null) && (getClass() == object.getClass())) {

                    //Compare the value(s) of all object properties:
                    Object thisObjectsProperty = getOperationDisposition();
                    Object parameterObjectsProperty = ((AvailableSituationImpl) (object)).getOperationDisposition();

                    if (((thisObjectsProperty != null) && (thisObjectsProperty.equals(parameterObjectsProperty))) || ((thisObjectsProperty == null) && (parameterObjectsProperty == null))) {

                        thisObjectsProperty = getProcessingDisposition();
                        parameterObjectsProperty = ((AvailableSituationImpl) (object)).getProcessingDisposition();

                        if (((thisObjectsProperty != null) && (thisObjectsProperty.equals(parameterObjectsProperty))) || ((thisObjectsProperty == null) && (parameterObjectsProperty == null))) {

                            thisObjectsProperty = getAvailabilityDisposition();
                            parameterObjectsProperty = ((AvailableSituationImpl) (object)).getAvailabilityDisposition();

                            if (((thisObjectsProperty != null) && (thisObjectsProperty.equals(parameterObjectsProperty))) || ((thisObjectsProperty == null) && (parameterObjectsProperty == null)))
                                return true;
                        }
                    }
                }
            }

            return false;
        }
    }

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * All components are initialized to either zero or null.
     * 
     * @since 1.0
     */
    public void init() {

        super.init();

        setAvailabilityDisposition(null);
        setOperationDisposition(null);
        setProcessingDisposition(null);
    }
}
