package org.eclipse.tptp.logging.events.cbe.impl;

import org.eclipse.hyades.logging.core.LoggingCoreResourceBundle;
import org.eclipse.tptp.logging.events.cbe.ComponentIdentification;
import org.eclipse.tptp.logging.events.cbe.MissingPropertyException;
import org.eclipse.tptp.logging.events.cbe.ValidationException;

/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ComponentIdentificationImpl.java,v 1.1 2006/09/06 17:54:04 cjin Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Interface representing a <code>ComponentIdentification</code>.
 * <p>
 * The following description is from the Common Base Event v1.0.1 specification
 * entitled "Canonical Situation Data Format: The Common Base Event V1.0.1":
 * <p>
 * Component identification provides a collection of attributes that are
 * required to uniquely identify a component. The same data is used to identify
 * both the reporter and the affected component.
 * <p>
 * 
 * 
 * @author Paul E. Slauenwhite
 * @version February 5, 2006
 * @since 1.0.1
 */
public class ComponentIdentificationImpl implements ComponentIdentification {

    /** Automatically generated javadoc for: serialVersionUID */
    private static final long serialVersionUID = 6775338617504967755L;

    /**
     * The cached value of the '{@link #getApplication() <em>Application</em>}'
     * attribute.  
     * 
     * @see #getApplication()
     */
    protected String application = null;

    /**
     * The cached value of the '{@link #getComponent() <em>Component</em>}'
     * attribute.  
     * 
     * @see #getComponent()
     */
    protected String component = null;

    /**
     * The cached value of the '
     * {@link #getComponentType() <em>Component Type</em>}' attribute. <!--
     * begin-user-doc --> 
     * 
     * @see #getComponentType()
     */
    protected String componentType = null;

    /**
     * The cached value of the '
     * {@link #getComponentIdType() <em>Component Id Type</em>}' attribute.
     *  
     * 
     * @see #getComponentIdType()
     */
    protected String componentIdType = null;

    /**
     * The cached value of the '
     * {@link #getExecutionEnvironment() <em>Execution Environment</em>}'
     * attribute.  
     * 
     * @see #getExecutionEnvironment()
     */
    protected String executionEnvironment = null;

    /**
     * The cached value of the '{@link #getInstanceId() <em>Instance Id</em>}'
     * attribute.  
     * 
     * @see #getInstanceId()
     */
    protected String instanceId = null;

    /**
     * The cached value of the '{@link #getLocation() <em>Location</em>}'
     * attribute.  
     * 
     * @see #getLocation()
     */
    protected String location = null;

    /**
     * The cached value of the '
     * {@link #getLocationType() <em>Location Type</em>}' attribute. <!--
     * begin-user-doc --> 
     * 
     * @see #getLocationType()
     */
    protected String locationType = null;

    /**
     * The cached value of the '{@link #getProcessId() <em>Process Id</em>}'
     * attribute.  
     * 
     * @see #getProcessId()
     */
    protected String processId = null;

    /**
     * The cached value of the '
     * {@link #getSubComponent() <em>Sub Component</em>}' attribute. <!--
     * begin-user-doc --> 
     * 
     * @see #getSubComponent()
     */
    protected String subComponent = null;

    /**
     * The cached value of the '{@link #getThreadId() <em>Thread Id</em>}'
     * attribute.  
     * 
     * @see #getThreadId()
     */
    protected String threadId = null;

    /**
     *  
     * 
     */
    protected ComponentIdentificationImpl() {
        super();
    }

    /**
     *  
     * 
     */
    public void setApplication(String newApplication) {
        application = newApplication;
    }

    /**
     *  
     * 
     */
    public String getApplication() {
        return application;
    }

    /**
     *  
     * 
     */
    public void setComponent(String newComponent) {
        component = newComponent;
    }

    /**
     *  
     * 
     */
    public String getComponent() {
        return component;
    }

    /**
     *  
     * 
     */
    public void setComponentIdType(String newComponentIdType) {
        componentIdType = newComponentIdType;
    }

    /**
     *  
     * 
     */
    public String getComponentIdType() {
        return componentIdType;
    }

    /**
     *  
     * 
     */
    public void setComponentType(String newComponentType) {
        componentType = newComponentType;
    }

    /**
     *  
     * 
     */
    public String getComponentType() {
        return componentType;
    }

    /**
     *  
     * 
     */
    public void setExecutionEnvironment(String newExecutionEnvironment) {
        executionEnvironment = newExecutionEnvironment;
    }

    /**
     *  
     * 
     */
    public String getExecutionEnvironment() {
        return executionEnvironment;
    }

    /**
     *  
     * 
     */
    public void setInstanceId(String newInstanceId) {
        instanceId = newInstanceId;
    }

    /**
     *  
     * 
     */
    public String getInstanceId() {
        return instanceId;
    }

    /**
     *  
     * 
     */
    public void setLocation(String newLocation) {
        location = newLocation;
    }

    /**
     *  
     * 
     */
    public String getLocation() {
        return location;
    }

    /**
     *  
     * 
     */
    public void setLocationType(String newLocationType) {
        locationType = newLocationType;
    }

    /**
     *  
     * 
     */
    public String getLocationType() {
        return locationType;
    }

    /**
     *  
     * 
     */
    public void setProcessId(String newProcessId) {
        processId = newProcessId;
    }

    /**
     *  
     * 
     */
    public String getProcessId() {
        return processId;
    }

    /**
     *  
     * 
     */
    public void setSubComponent(String newSubComponent) {
        subComponent = newSubComponent;
    }

    /**
     *  
     * 
     */
    public String getSubComponent() {
        return subComponent;
    }

    /**
     *  
     * 
     */
    public void setThreadId(String newThreadId) {
        threadId = newThreadId;
    }

    /**
     *  
     * 
     */
    public String getThreadId() {
        return threadId;
    }

    /**
     * Overrides the <code>java.lang.Object</code>'s equals() API to 
     * determine if the parameter <code>object</code> is equal to this object.
     * <p>
     * 
     * @param object The <code>java.lang.Object</code> to be compared to this object.
     * @return True, if this object is the same as the parameter <code>object</code>, otherwise false.
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object object) {

        synchronized (this) {
            
            //Check if the parameter object is the same object reference as this object (e.g. equal):
            if (this == object){
                return true;
            }
            else {

                //Check if the parameter object is null and is the a different type as this object(e.g. not equal):
                if ((object != null) && (getClass() == object.getClass())) {

                    //Compare the value(s) of all object properties:
                    Object thisObjectsProperty = getLocation();
                    Object parameterObjectsProperty = ((ComponentIdentificationImpl) (object)).getLocation();

                    if (((thisObjectsProperty != null) && (thisObjectsProperty.equals(parameterObjectsProperty))) || ((thisObjectsProperty == null) && (parameterObjectsProperty == null))) {
                        
                        thisObjectsProperty = getLocationType();
                        parameterObjectsProperty = ((ComponentIdentificationImpl) (object)).getLocationType();

                        if (((thisObjectsProperty != null) && (thisObjectsProperty.equals(parameterObjectsProperty))) || ((thisObjectsProperty == null) && (parameterObjectsProperty == null))) {
                        
                            thisObjectsProperty = getApplication();
                            parameterObjectsProperty = ((ComponentIdentificationImpl) (object)).getApplication();

                            if (((thisObjectsProperty != null) && (thisObjectsProperty.equals(parameterObjectsProperty))) || ((thisObjectsProperty == null) && (parameterObjectsProperty == null))) {
                            
                                thisObjectsProperty = getExecutionEnvironment();
                                parameterObjectsProperty = ((ComponentIdentificationImpl) (object)).getExecutionEnvironment();

                                if (((thisObjectsProperty != null) && (thisObjectsProperty.equals(parameterObjectsProperty))) || ((thisObjectsProperty == null) && (parameterObjectsProperty == null))) {
                                    
                                    thisObjectsProperty = getComponent();
                                    parameterObjectsProperty = ((ComponentIdentificationImpl) (object)).getComponent();

                                    if (((thisObjectsProperty != null) && (thisObjectsProperty.equals(parameterObjectsProperty))) || ((thisObjectsProperty == null) && (parameterObjectsProperty == null))) {
                                        
                                        thisObjectsProperty = getSubComponent();
                                        parameterObjectsProperty = ((ComponentIdentificationImpl) (object)).getSubComponent();

                                        if (((thisObjectsProperty != null) && (thisObjectsProperty.equals(parameterObjectsProperty))) || ((thisObjectsProperty == null) && (parameterObjectsProperty == null))) {
                                            
                                            thisObjectsProperty = getComponentIdType();
                                            parameterObjectsProperty = ((ComponentIdentificationImpl) (object)).getComponentIdType();

                                            if (((thisObjectsProperty != null) && (thisObjectsProperty.equals(parameterObjectsProperty))) || ((thisObjectsProperty == null) && (parameterObjectsProperty == null))) {
                                                
                                                thisObjectsProperty = getInstanceId();
                                                parameterObjectsProperty = ((ComponentIdentificationImpl) (object)).getInstanceId();

                                                if (((thisObjectsProperty != null) && (thisObjectsProperty.equals(parameterObjectsProperty))) || ((thisObjectsProperty == null) && (parameterObjectsProperty == null))) {
                                                    
                                                    thisObjectsProperty = getProcessId();
                                                    parameterObjectsProperty = ((ComponentIdentificationImpl) (object)).getProcessId();

                                                    if (((thisObjectsProperty != null) && (thisObjectsProperty.equals(parameterObjectsProperty))) || ((thisObjectsProperty == null) && (parameterObjectsProperty == null))) {
                                                        
                                                        thisObjectsProperty = getThreadId();
                                                        parameterObjectsProperty = ((ComponentIdentificationImpl) (object)).getThreadId();

                                                        if (((thisObjectsProperty != null) && (thisObjectsProperty.equals(parameterObjectsProperty))) || ((thisObjectsProperty == null) && (parameterObjectsProperty == null))) {

                                                            thisObjectsProperty = getComponentType();
                                                            parameterObjectsProperty = ((ComponentIdentificationImpl) (object)).getComponentType();

                                                            if (((thisObjectsProperty != null) && (thisObjectsProperty.equals(parameterObjectsProperty))) || ((thisObjectsProperty == null) && (parameterObjectsProperty == null))) {
                                                                return true;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }

            return false;
        }
    }

    /**
     *  
     * 
     */
    public String toString() {

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (application: ");
        result.append(application);
        result.append(", component: ");
        result.append(component);
        result.append(", componentType: ");
        result.append(componentType);
        result.append(", componentIdType: ");
        result.append(componentIdType);
        result.append(", executionEnvironment: ");
        result.append(executionEnvironment);
        result.append(", instanceId: ");
        result.append(instanceId);
        result.append(", location: ");
        result.append(location);
        result.append(", locationType: ");
        result.append(locationType);
        result.append(", processId: ");
        result.append(processId);
        result.append(", subComponent: ");
        result.append(subComponent);
        result.append(", threadId: ");
        result.append(threadId);
        result.append(')');
        return result.toString();
    }

    /**
     * Checks whether the contents of the instance conform to the Common Base Event 
     * specification as described in "Canonical Situation Data Format: The Common Base Event 
     * V1.0.1".
     * <p>
     * 
     * @throws ValidationException If the event instance does not conform to the Common Base Event specification.
     */
    public void validate() throws ValidationException {

        synchronized (this) {
            
            //Step 1:  Check for required properties:
            if(location == null){
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString("LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", "CommonBaseEvent.ComponentIdentification.Location")); 
            }

            if(locationType == null){
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString("LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", "CommonBaseEvent.ComponentIdentification.LocationType")); 
            }

            if(component == null){
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString("LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", "CommonBaseEvent.ComponentIdentification.Component")); 
            }

            if(subComponent == null){
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString("LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", "CommonBaseEvent.ComponentIdentification.SubComponent")); 
            }

            if(componentIdType == null){
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString("LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", "CommonBaseEvent.ComponentIdentification.ComponentIdType")); 
            }

            if(componentType == null){
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString("LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", "CommonBaseEvent.ComponentIdentification.ComponentType")); 
            }

            //Step 2:  Check content of each property:
            if(location.length() > 256){
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LENGTH_EXC_", "CommonBaseEvent.ComponentIdentification.Location", location, new Integer(location.length()), new Integer(256)));
            }

            if(component.length() > 256){
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LENGTH_EXC_", "CommonBaseEvent.ComponentIdentification.Component", component, new Integer(component.length()), new Integer(256)));
            }

            if(subComponent.length() > 512){
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LENGTH_EXC_", "CommonBaseEvent.ComponentIdentification.SubComponent", subComponent, new Integer(subComponent.length()), new Integer(512)));
            }

            if(componentIdType.length() > 32){
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LENGTH_EXC_", "CommonBaseEvent.ComponentIdentification.ComponentIdType", componentIdType, new Integer(componentIdType.length()), new Integer(32)));
            }

            if(componentType.length() > 512){
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LENGTH_EXC_", "CommonBaseEvent.ComponentIdentification.ComponentType", componentType, new Integer(componentType.length()), new Integer(512)));
            }

            if((instanceId != null) && (instanceId.length() > 128)){
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LENGTH_EXC_", "CommonBaseEvent.ComponentIdentification.InstanceId", instanceId, new Integer(instanceId.length()), new Integer(128)));
            }

            if((processId != null) && (processId.length() > 64)){
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LENGTH_EXC_", "CommonBaseEvent.ComponentIdentification.ProcessId", processId, new Integer(processId.length()), new Integer(64)));
            }

            if((threadId != null) && (threadId.length() > 64)){
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LENGTH_EXC_", "CommonBaseEvent.ComponentIdentification.ThreadId", threadId, new Integer(threadId.length()), new Integer(64)));
            }

            if((application != null) && (application.length() > 256)){
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LENGTH_EXC_", "CommonBaseEvent.ComponentIdentification.Application", application, new Integer(application.length()), new Integer(256)));
            }

            if((executionEnvironment != null) && (executionEnvironment.length() > 256)){
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LENGTH_EXC_", "CommonBaseEvent.ComponentIdentification.ExecutionEnvironment", executionEnvironment, new Integer(executionEnvironment.length()), new Integer(256)));
            }

            if(locationType.length() > 32){
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LENGTH_EXC_","CommonBaseEvent.ComponentIdentification.LocationType", locationType, new Integer(locationType.length()), new Integer(32)));
            }
            else if((!locationType.equals(LOCATION_TYPE_UNKNOWN)) && (!locationType.equals(LOCATION_TYPE_IPV4)) && (!locationType.equals(LOCATION_TYPE_IPV6)) && (!locationType.equals(LOCATION_TYPE_NWA)) && (!locationType.equals(LOCATION_TYPE_ISDN)) && (!locationType.equals(LOCATION_TYPE_ICD)) && (!locationType.equals(LOCATION_TYPE_OID_OSI)) && (!locationType.equals(LOCATION_TYPE_DIAL)) && (!locationType.equals(LOCATION_TYPE_HWA)) && (!locationType.equals(LOCATION_TYPE_HID)) && (!locationType.equals(LOCATION_TYPE_X25)) && (!locationType.equals(LOCATION_TYPE_DCC)) && (!locationType.equals(LOCATION_TYPE_SNA)) && (!locationType.equals(LOCATION_TYPE_IPX)) && (!locationType.equals(LOCATION_TYPE_E_164)) && (!locationType.equals(LOCATION_TYPE_HOSTNAME)) && (!locationType.equals(LOCATION_TYPE_FQ_HOSTNAME)) && (!locationType.equals(LOCATION_TYPE_DEVICE_NAME))){
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_COMPONENT_IDENTIFICATION_INVALID_LOCATION_TYPE_EXC_", "CommonBaseEvent.ComponentIdentification.LocationType", locationType)); 
            }
        }
    }

    /**
     * Return a cloned (copy by value) object of this object. 
     * <p>
     * This is a deep copy version, in which all the objects 
     * within this object will be copied by value.
     * <p>
     * 
     * @return Object The cloned (copy by value) object of this object.
     * @throws CloneNotSupportedException If a instance variable of this object does not implement the <code>Cloneable</code> interface.   
     */
    public Object clone() throws CloneNotSupportedException {

        synchronized (this) {

            ComponentIdentificationImpl copy = ((ComponentIdentificationImpl) (super.clone()));

            if(this.application != null){
                copy.setApplication(new String(this.application));                                
            }

            if(this.component != null){
                copy.setComponent(new String(this.component));                                
            }

            if(this.componentIdType != null){
                copy.setComponentIdType(new String(this.componentIdType));                                
            }

            if(this.componentType != null){
                copy.setComponentType(new String(this.componentType));                                
            }

            if(this.executionEnvironment != null){
                copy.setExecutionEnvironment(new String(this.executionEnvironment));                                
            }

            if(this.instanceId != null){
                copy.setInstanceId(new String(this.instanceId));                                
            }

            if(this.location != null){
                copy.setLocation(new String(this.location));                                
            }

            if(this.locationType != null){
                copy.setLocationType(new String(this.locationType));                                
            }

            if(this.processId != null){
                copy.setProcessId(new String(this.processId));                                
            }

            if(this.subComponent != null){
                copy.setSubComponent(new String(this.subComponent));                                
            }

            if(this.threadId != null){
                copy.setThreadId(new String(this.threadId));                                
            }

            return copy;
        }
    }

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * All components are initialized to either zero or null.
     * 
     * @since 1.0
     */
    public void init() {

        setApplication(null);
        setComponent(null);
        setComponentIdType(null);
        setComponentType(null);
        setExecutionEnvironment(null);
        setInstanceId(null);
        setLocation(null);
        setLocationType(null);
        setProcessId(null);
        setSubComponent(null);
        setThreadId(null);
    }
}