package org.eclipse.tptp.logging.events.cbe.impl;

import org.eclipse.hyades.logging.core.LoggingCoreResourceBundle;
import org.eclipse.tptp.logging.events.cbe.ConnectSituation;
import org.eclipse.tptp.logging.events.cbe.MissingPropertyException;
import org.eclipse.tptp.logging.events.cbe.ValidationException;

/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ConnectSituationImpl.java,v 1.1 2006/09/06 17:54:04 cjin Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Interface representing a <code>ConnectSituation</code>.
 * <p>
 * The following description is from the Common Base Event v1.0.1 specification
 * entitled "Canonical Situation Data Format: The Common Base Event V1.0.1":
 * <p>
 * The ConnectSituation deals with the situations that identify aspects about a
 * connection to another component. Messages that say a connection failed, that
 * a connection was created, or that a connection was ended all fall into this
 * category. Existing messages include words like connection reset, connection
 * failed, and failed to get a connection, for example:
 * <p>
 * <ul>
 * <li>DBMN0015W: Failure while creating connection {0}</li>
 * <br>
 * <li>DBMN0023W: Failed to close a connection {0}</li>
 * </ul>
 * <p>
 * 
 * 
 * @author Paul E. Slauenwhite
 * @version February 5, 2006
 * @since 1.0.1
 */
public class ConnectSituationImpl extends SituationTypeImpl implements ConnectSituation {

    /** Automatically generated javadoc for: serialVersionUID */
    private static final long serialVersionUID = 2872460422753085360L;

    /**
     * The cached value of the '
     * {@link #getSuccessDisposition() <em>Success Disposition</em>}'
     * attribute.  
     * 
     * @see #getSuccessDisposition()
     */
    protected String successDisposition = null;

    /**
     * The cached value of the '
     * {@link #getSituationDisposition() <em>Situation Disposition</em>}'
     * attribute.  
     * 
     * @see #getSituationDisposition()
     */
    protected String situationDisposition = null;

    /**
     *  
     * 
     */
    protected ConnectSituationImpl() {
        super();
    }

    /**
     *  
     * 
     */
    public String getSuccessDisposition() {
        return successDisposition;
    }

    /**
     *  
     * 
     */
    public void setSuccessDisposition(String newSuccessDisposition) {
        successDisposition = newSuccessDisposition;
    }

    /**
     *  
     * 
     */
    public String getSituationDisposition() {
        return situationDisposition;
    }

    /**
     *  
     * 
     */
    public void setSituationDisposition(String newSituationDisposition) {
        situationDisposition = newSituationDisposition;
    }

    /**
     *  
     * 
     */
    public String toString() {

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (successDisposition: ");
        result.append(successDisposition);
        result.append(", situationDisposition: ");
        result.append(situationDisposition);
        result.append(')');
        return result.toString();
    }

    /**
     * Checks whether the contents of the instance conform to the Common Base Event 
     * specification as described in "Canonical Situation Data Format: The Common Base Event 
     * V1.0.1".
     * <p>
     * 
     * @throws ValidationException If the event instance does not conform to the Common Base Event specification.
     */
    public void validate() throws ValidationException {

        synchronized (this) {

            super.validate();

            //Step 1:  Check for required properties:
            if(successDisposition == null){
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString("LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", "CommonBaseEvent.Situation.ConnectSituation.SuccessDisposition")); 
            }

            if(situationDisposition == null){
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString("LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", "CommonBaseEvent.Situation.ConnectSituation.SituationDisposition")); 
            }

            //Step 2:  Check content of each property:
            if(successDisposition.length() > 64){
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LENGTH_EXC_", "CommonBaseEvent.Situation.ConnectSituation.SuccessDisposition", successDisposition, new Integer(successDisposition.length()), new Integer(64)));
            }

            if(situationDisposition.length() > 64){
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LENGTH_EXC_", "CommonBaseEvent.Situation.ConnectSituation.SituationDisposition", situationDisposition, new Integer(situationDisposition.length()), new Integer(64)));
            }
}
    }

    /**
     * Return a cloned (copy by value) object of this object. 
     * <p>
     * This is a deep copy version, in which all the objects 
     * within this object will be copied by value.
     * <p>
     * 
     * @return Object The cloned (copy by value) object of this object.
     * @throws CloneNotSupportedException If a instance variable of this object does not implement the <code>Cloneable</code> interface.   
     */
    public Object clone() throws CloneNotSupportedException {

        synchronized (this) {

            ConnectSituationImpl copy = ((ConnectSituationImpl) (super.clone()));

            if(this.situationDisposition != null){
                copy.setSituationDisposition(new String(this.situationDisposition));                                
            }

            if(this.successDisposition != null){
                copy.setSuccessDisposition(new String(this.successDisposition));                                
            }

            return copy;
        }            
    }

    /**
     * Overrides the <code>java.lang.Object</code>'s equals() API to 
     * determine if the parameter <code>object</code> is equal to this object.
     * <p>
     * 
     * @param object The <code>java.lang.Object</code> to be compared to this object.
     * @return True, if this object is the same as the parameter <code>object</code>, otherwise false.
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object object) {

        synchronized (this) {
            
            //Check if the parameter object is the same object reference as this object (e.g. equal):
            if (this == object){
                return true;
            }
            else {

                //Check if the parameter object is null and is the a different type as this object(e.g. not equal):
                if ((object != null) && (getClass() == object.getClass())) {

                    //Compare the value(s) of all object properties:
                    Object thisObjectsProperty = getSituationDisposition();
                    Object parameterObjectsProperty = ((ConnectSituationImpl) (object)).getSituationDisposition();

                    if (((thisObjectsProperty != null) && (thisObjectsProperty.equals(parameterObjectsProperty))) || ((thisObjectsProperty == null) && (parameterObjectsProperty == null))) {

                        thisObjectsProperty = getSuccessDisposition();
                        parameterObjectsProperty = ((ConnectSituationImpl) (object)).getSuccessDisposition();

                        if (((thisObjectsProperty != null) && (thisObjectsProperty.equals(parameterObjectsProperty))) || ((thisObjectsProperty == null) && (parameterObjectsProperty == null))){
                            return true;
                        }
                    }
                }
            }

            return false;
        }
    }

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * All components are initialized to either zero or null.
     * 
     * @since 1.0
     */
    public void init() {

        super.init();

        setSituationDisposition(null);
        setSuccessDisposition(null);
    }
} // ConnectSituationImpl
