package org.eclipse.tptp.logging.events.cbe.impl;

import org.eclipse.hyades.internal.logging.core.internationalization.InternationalizationUtilities;
import org.eclipse.hyades.logging.core.LoggingCoreResourceBundle;
import org.eclipse.tptp.logging.events.cbe.ContextDataElement;
import org.eclipse.tptp.logging.events.cbe.MissingPropertyException;
import org.eclipse.tptp.logging.events.cbe.ValidationException;

/**********************************************************************
 * Copyright (c) 2005, 2006, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ContextDataElementImpl.java,v 1.2 2007/04/09 04:35:53 cjin Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Interface representing a <code>ContextDataElement</code>.
 * <p>
 * The following description is from the Common Base Event v1.0.1 specification
 * entitled "Canonical Situation Data Format: The Common Base Event V1.0.1":
 * <p>
 * The ContextDataElement type defines the contexts that this event references.
 * This complex type holds data that is used to assist with problem diagnostics
 * by correlating messages or events generated during execution of a unit of
 * work.
 * <p>
 * 
 * @author cindyjin
 * @author Paul E. Slauenwhite
 * @version March 30, 2007
 * @since 1.0.1
 */
public class ContextDataElementImpl implements ContextDataElement {

    /** Automatically generated javadoc for: serialVersionUID */
    private static final long serialVersionUID = 1340201980987934512L;

    /**
     * The cached value of the '{@link #getContextId() <em>Context Id</em>}'
     * attribute.  
     * 
     * @see #getContextId()
     */
    protected String contextId = null;

    /**
     * The cached value of the '
     * {@link #getContextValue() <em>Context Value</em>}' attribute. <!--
     * begin-user-doc --> 
     * 
     * @see #getContextValue()
     */
    protected String contextValue = null;

    /**
     * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
     *  
     * 
     * @see #getName()
     */
    protected String name = null;

    /**
     * The cached value of the '{@link #getType() <em>Type</em>}' attribute.
     *  
     * 
     * @see #getType()
     */
    protected String type = null;

    /**
     *  
     * 
     */
    protected ContextDataElementImpl() {
        super();
    }

    /**
     *  
     * 
     */
    public String getContextId() {
        return contextId;
    }

    /**
     *  
     * 
     */
    public void setContextId(String newContextId) {
        contextId = newContextId;
    }

    /**
     *  
     * 
     */
    public String getContextValue() {
        return contextValue;
    }

    /**
     *  
     * 
     */
    public void setContextValue(String newContextValue) {
        contextValue = newContextValue;
    }

    /**
     *  
     * 
     */
    public String getName() {
        return name;
    }

    /**
     *  
     * 
     */
    public void setName(String newName) {
        name = newName;
    }

    /**
     *  
     * 
     */
    public String getType() {
        return type;
    }

    /**
     *  
     * 
     */
    public void setType(String newType) {
        type = newType;
    }

    /**
     *  
     * 
     */
    public String toString() {

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (contextId: ");
        result.append(contextId);
        result.append(", contextValue: ");
        result.append(contextValue);
        result.append(", name: ");
        result.append(name);
        result.append(", type: ");
        result.append(type);
        result.append(')');
        return result.toString();
    }

    /**
     * Checks whether the contents of the instance conform to the Common Base Event 
     * specification as described in "Canonical Situation Data Format: The Common Base Event 
     * V1.0.1".
     * <p>
     * 
     * @throws ValidationException If the event instance does not conform to the Common Base Event specification.
     */
    public void validate() throws ValidationException {

        synchronized (this) {

            //Step 1:  Check for required properties:
            if(name == null){
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString("LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", "CommonBaseEvent.ContextDataElement.Name")); 
            }
            
            if(type == null){
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString("LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", "CommonBaseEvent.ContextDataElement.Type")); 
            }

            //Step 2:  Check for mutually exclusive properties:
            if(((contextValue == null) && (contextId == null)) || ((contextValue != null) && (contextId != null))){
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString("LOG_MUTUALLY_EXCLUSIVE_ATTRIBUTES_EXC_", "CommonBaseEvent.ContextDataElement.ContextValue", "CommonBaseEvent.ContextDataElement.ContextId"));                 
            }

            //Step 3:  Check content of each property:
            if(name.length() > 64){
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LENGTH_EXC_", "CommonBaseEvent.ContextDataElement.Name", name, new Integer(name.length()), new Integer(64)));
            }

            if(type.length() > 64){
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LENGTH_EXC_", "CommonBaseEvent.ContextDataElement.Type", type, new Integer(type.length()), new Integer(64)));
            }
            
            if(contextValue != null){
                
                if(contextValue.length() > 1024){
                    throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LENGTH_EXC_", "CommonBaseEvent.ContextDataElement.ContextValue", contextValue, new Integer(contextValue.length()), new Integer(1024)));
                }
            }
            else {
                
                if((contextId.length() < 32) || (contextId.length() > 64)){
                    throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_GLOBAL_INSTANCE_ID_LENGTH_EXC_","CommonBaseEvent.AssociatedEvent.ContextId", contextId));
                }
                else if(!Character.isLetter(InternationalizationUtilities.charAt(contextId,0))){
                    throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_GLOBAL_INSTANCE_ID_EXC_","CommonBaseEvent.AssociatedEvent.ContextId", contextId));
                }
            }
        }
    }

    /**
     * Overrides the <code>java.lang.Object</code>'s equals() API to 
     * determine if the parameter <code>object</code> is equal to this object.
     * <p>
     * 
     * @param object The <code>java.lang.Object</code> to be compared to this object.
     * @return True, if this object is the same as the parameter <code>object</code>, otherwise false.
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object object) {

        synchronized (this) {
            
            //Check if the parameter object is the same object reference as this object (e.g. equal):
            if (this == object){
                return true;
            }
            else {

                //Check if the parameter object is null and is the a different type as this object(e.g. not equal):
                if ((object != null) && (getClass() == object.getClass())) {

                    //Compare the value(s) of all object properties:
                    Object thisObjectsProperty = getContextId();
                    Object parameterObjectsProperty = ((ContextDataElementImpl) (object)).getContextId();

                    if (((thisObjectsProperty != null) && (thisObjectsProperty.equals(parameterObjectsProperty))) || ((thisObjectsProperty == null) && (parameterObjectsProperty == null))) {
                        
                        thisObjectsProperty = getType();
                        parameterObjectsProperty = ((ContextDataElementImpl) (object)).getType();

                        if (((thisObjectsProperty != null) && (thisObjectsProperty.equals(parameterObjectsProperty))) || ((thisObjectsProperty == null) && (parameterObjectsProperty == null))) {
                            
                            thisObjectsProperty = getName();
                            parameterObjectsProperty = ((ContextDataElementImpl) (object)).getName();

                            if (((thisObjectsProperty != null) && (thisObjectsProperty.equals(parameterObjectsProperty))) || ((thisObjectsProperty == null) && (parameterObjectsProperty == null))) {
                                
                                thisObjectsProperty = getContextValue();
                                parameterObjectsProperty = ((ContextDataElementImpl) (object)).getContextValue();

                                if (((thisObjectsProperty != null) && (thisObjectsProperty.equals(parameterObjectsProperty))) || ((thisObjectsProperty == null) && (parameterObjectsProperty == null))) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }

            return false;
        }
    }

    /**
     * Return a cloned (copy by value) object of this object. 
     * <p>
     * This is a deep copy version, in which all the objects 
     * within this object will be copied by value.
     * <p>
     * 
     * @return Object The cloned (copy by value) object of this object.
     * @throws CloneNotSupportedException If a instance variable of this object does not implement the <code>Cloneable</code> interface.   
     */
    public Object clone() throws CloneNotSupportedException {

        synchronized (this) {

            ContextDataElementImpl copy = ((ContextDataElementImpl) (super.clone()));

            if(this.contextId != null){
                copy.setContextId(new String(this.contextId));                                
            }

            if(this.contextValue != null){
                copy.setContextValue(new String(this.contextValue));                                
            }

            if(this.name != null){
                copy.setName(new String(this.name));                                
            }

            if(this.type != null){
                copy.setType(new String(this.type));                                
            }

            return copy;
        }            
    }

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * All components are initialized to either zero or null.
     * 
     * @since 1.0
     */
    public void init() {

        setContextId(null);
        setContextValue(null);
        setName(null);
        setType(null);
    }
}