package org.eclipse.tptp.logging.events.cbe.impl;

import org.eclipse.hyades.logging.core.LoggingCoreResourceBundle;
import org.eclipse.tptp.logging.events.cbe.DestroySituation;
import org.eclipse.tptp.logging.events.cbe.MissingPropertyException;
import org.eclipse.tptp.logging.events.cbe.ValidationException;

/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DestroySituationImpl.java,v 1.1 2006/09/06 17:54:04 cjin Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Interface representing a <code>DestroySituation</code>.
 * <p>
 * The following description is from the Common Base Event v1.0.1 specification
 * entitled "Canonical Situation Data Format: The Common Base Event V1.0.1":
 * <p>
 * The DestroySituation deals with the situations documenting when an entity or
 * component was removed or destroyed. Messages telling that a document was
 * destroyed or a file was deleted all fall into this category. Existing message
 * include words like "was created", "about to create", and "now exists", for
 * example:
 * <p>
 * <ul>
 * <li>CONM6007I: The connection pool was destroyed for data source
 * (UDDI.Datasource.techs8.server1).</li>
 * </ul>
 * <p>
 * 
 * 
 * @author Paul E. Slauenwhite
 * @version February 5, 2006
 * @since 1.0.1
 */
public class DestroySituationImpl extends SituationTypeImpl implements DestroySituation {

    /** Automatically generated javadoc for: serialVersionUID */
    private static final long serialVersionUID = -6561753088656143510L;

    /**
     * The cached value of the '
     * {@link #getSuccessDisposition() <em>Success Disposition</em>}'
     * attribute.  
     * 
     * @see #getSuccessDisposition()
     */
    protected String successDisposition = null;

    /**
     *  
     * 
     */
    protected DestroySituationImpl() {
        super();
    }

    /**
     *  
     * 
     */
    public String getSuccessDisposition() {
        return successDisposition;
    }

    /**
     *  
     * 
     */
    public void setSuccessDisposition(String newSuccessDisposition) {
        successDisposition = newSuccessDisposition;
    }

    /**
     *  
     * 
     */
    public String toString() {

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (successDisposition: ");
        result.append(successDisposition);
        result.append(')');
        return result.toString();
    }

    /**
     * Checks whether the contents of the instance conform to the Common Base Event 
     * specification as described in "Canonical Situation Data Format: The Common Base Event 
     * V1.0.1".
     * <p>
     * 
     * @throws ValidationException If the event instance does not conform to the Common Base Event specification.
     */
    public void validate() throws ValidationException {

        synchronized (this) {

            super.validate();

            //Step 1:  Check for required properties:
            if(successDisposition == null){
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString("LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", "CommonBaseEvent.Situation.DestroySituation.SuccessDisposition")); 
            }

            //Step 2:  Check content of each property:
            if(successDisposition.length() > 64){
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LENGTH_EXC_", "CommonBaseEvent.Situation.DestroySituation.SuccessDisposition", successDisposition, new Integer(successDisposition.length()), new Integer(64)));
            }
        }
    }

    /**
     * Return a cloned (copy by value) object of this object. 
     * <p>
     * This is a deep copy version, in which all the objects 
     * within this object will be copied by value.
     * <p>
     * 
     * @return Object The cloned (copy by value) object of this object.
     * @throws CloneNotSupportedException If a instance variable of this object does not implement the <code>Cloneable</code> interface.   
     */
    public Object clone() throws CloneNotSupportedException {

        synchronized (this) {

            DestroySituationImpl copy = ((DestroySituationImpl) (super.clone()));

            if(this.successDisposition != null){
                copy.setSuccessDisposition(new String(this.successDisposition));                                
            }

            return copy;
        }            
    }

    /**
     * Overrides the <code>java.lang.Object</code>'s equals() API to 
     * determine if the parameter <code>object</code> is equal to this object.
     * <p>
     * 
     * @param object The <code>java.lang.Object</code> to be compared to this object.
     * @return True, if this object is the same as the parameter <code>object</code>, otherwise false.
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object object) {

        synchronized (this) {
            
            //Check if the parameter object is the same object reference as this object (e.g. equal):
            if (this == object){
                return true;
            }
            else {

                //Check if the parameter object is null and is the a different type as this object(e.g. not equal):
                if ((object != null) && (getClass() == object.getClass())) {

                    //Compare the value(s) of all object properties:
                    Object thisObjectsProperty = getSuccessDisposition();
                    Object parameterObjectsProperty = ((DestroySituationImpl) (object)).getSuccessDisposition();

                    if (((thisObjectsProperty != null) && (thisObjectsProperty.equals(parameterObjectsProperty))) || ((thisObjectsProperty == null) && (parameterObjectsProperty == null))){
                        return true;
                    }
                }
            }

            return false;
        }
    }

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * All components are initialized to either zero or null.
     * 
     * @since 1.0
     */
    public void init() {

        super.init();

        setSuccessDisposition(null);
    }
}