package org.eclipse.tptp.logging.events.cbe.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;

import javax.naming.BinaryRefAddr;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;

import org.eclipse.hyades.logging.core.Guid;
import org.eclipse.hyades.logging.core.LoggingCoreResourceBundle;
import org.eclipse.tptp.logging.events.cbe.AssociatedEvent;
import org.eclipse.tptp.logging.events.cbe.AssociationEngine;
import org.eclipse.tptp.logging.events.cbe.AvailableSituation;
import org.eclipse.tptp.logging.events.cbe.CommonBaseEvent;
import org.eclipse.tptp.logging.events.cbe.CompletionException;
import org.eclipse.tptp.logging.events.cbe.ComponentIdentification;
import org.eclipse.tptp.logging.events.cbe.ConfigureSituation;
import org.eclipse.tptp.logging.events.cbe.ConnectSituation;
import org.eclipse.tptp.logging.events.cbe.ContentHandler;
import org.eclipse.tptp.logging.events.cbe.ContextDataElement;
import org.eclipse.tptp.logging.events.cbe.CreateSituation;
import org.eclipse.tptp.logging.events.cbe.DependencySituation;
import org.eclipse.tptp.logging.events.cbe.DestroySituation;
import org.eclipse.tptp.logging.events.cbe.EventFactory;
import org.eclipse.tptp.logging.events.cbe.ExtendedDataElement;
import org.eclipse.tptp.logging.events.cbe.FeatureSituation;
import org.eclipse.tptp.logging.events.cbe.MsgCatalogToken;
import org.eclipse.tptp.logging.events.cbe.MsgDataElement;
import org.eclipse.tptp.logging.events.cbe.OtherSituation;
import org.eclipse.tptp.logging.events.cbe.ReportSituation;
import org.eclipse.tptp.logging.events.cbe.RequestSituation;
import org.eclipse.tptp.logging.events.cbe.Situation;
import org.eclipse.tptp.logging.events.cbe.StartSituation;
import org.eclipse.tptp.logging.events.cbe.StopSituation;

/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: EventFactoryImpl.java,v 1.2 2008/01/24 02:29:31 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Class representing an implementation of an <code>EventFactory</code>.
 * <p>
 * It provides a create method for each non-abstract class of the model.
 * <p>
 * 
 * 
 * @author Paul E. Slauenwhite
 * @version February 5, 2006
 * @since 1.0.1
 */
public class EventFactoryImpl implements EventFactory, Serializable, Referenceable {

    /** Automatically generated javadoc for: serialVersionUID */
    private static final long serialVersionUID = -4678401577300618645L;

    /**
     * Name of the reference address for the mediation handlers in JNDI.
     * <P>
     * The <code>getReference</code> method encodes the mediation handlers in
     * their serialized form inside a reference address and uses this name for
     * that address.
     */
    public final static String CBE_INSTANCE_ADDRESS = "CBE.MediationHandler";

    /**
     * Prefix added to all guids produced from this class.
     * 
     * @see #createGlobalInstanceId()
     */
    static final private String GUID_PREFIX = "CE";

    /**
     * Content handler associated to this factory.
     */
    protected ContentHandler contentHandler = null;

    /**
     * Flag to determine if the associated content handler should be invoked
     * upon event creation.
     */
    protected boolean completeEvent = false;

    /**
     * Creates and instance of the factory.  <!--
     * end-user-doc -->
     * 
     */
    public EventFactoryImpl() {
        super();
    }

    /**
     *  
     * 
     */
    public AssociatedEvent createAssociatedEvent() {
        AssociatedEventImpl associatedEvent = new AssociatedEventImpl();
        return associatedEvent;
    }

    /**
     *  
     * 
     */
    public AssociationEngine createAssociationEngine() {

        AssociationEngineImpl associationEngine = new AssociationEngineImpl();

        return associationEngine;
    }

    /**
     *  
     * 
     */
    public AvailableSituation createAvailableSituation() {
        AvailableSituationImpl availableSituation = new AvailableSituationImpl();
        return availableSituation;
    }

    /**
     *  
     * 
     */
    public CommonBaseEvent createCommonBaseEventGen() {

        CommonBaseEventImpl commonBaseEvent = new CommonBaseEventImpl();

        return commonBaseEvent;
    }

    /**
     * @see org.eclipse.tptp.logging.events.cbe.EventFactory#createCommonBaseEvent()
     */
    public CommonBaseEvent createCommonBaseEvent() {

        CommonBaseEvent result = createCommonBaseEventGen();

        if (contentHandler != null) {

            result.setContentHandler(contentHandler);

            if (completeEvent) {

                try {
                    result.complete();
                } catch (CompletionException c) {
                    // Ignore the CompletionException and return the
                    // 'uncompleted' event.
                }
            }
        }

        return result;
    }

    /**
     * @see org.eclipse.tptp.logging.events.cbe.EventFactory#createCommonBaseEvent(String,
     *      long)
     */
    public CommonBaseEvent createCommonBaseEvent(String extensionName, long creationTime) {

        CommonBaseEvent result = createCommonBaseEvent(extensionName);

        if (creationTime != -1) {
            result.setCreationTimeAsLong(creationTime);
        }

        return result;
    }

    /**
     * @see org.eclipse.tptp.logging.events.cbe.EventFactory#createCommonBaseEvent(String)
     */
    public CommonBaseEvent createCommonBaseEvent(String extensionName) {

        CommonBaseEvent result = createCommonBaseEvent();

        if (extensionName != null) {
            result.setExtensionName(extensionName);
        }

        return result;
    }

    /**
     * @see org.eclipse.tptp.logging.events.cbe.EventFactory#createCommonBaseEvent(short,
     *      org.eclipse.tptp.logging.events.cbe.Situation,
     *      java.lang.String)
     */
    public CommonBaseEvent createCommonBaseEvent(short severity, Situation situation, String msg) {

        CommonBaseEvent result = createCommonBaseEvent();

        if (severity != -1) {
            result.setSeverity(severity);
        }

        if (situation != null) {
            result.setSituation(situation);
        }

        if (msg != null) {
            result.setMsg(msg);
        }

        return result;
    }

    /**
     * @see org.eclipse.tptp.logging.events.cbe.EventFactory#createCommonBaseEvent(short,
     *      org.eclipse.tptp.logging.events.cbe.Situation,
     *      java.lang.String, java.lang.String[], java.lang.String,
     *      java.lang.String)
     */
    public CommonBaseEvent createCommonBaseEvent(short severity, Situation situation, String msgCatalogId, String[] msgCatalogTokens, String msgId, String msg) {

        CommonBaseEvent result = createCommonBaseEvent(severity, situation, msg);

        if ((msgCatalogId != null) || (msgCatalogTokens != null) || (msgId != null)) {

            MsgDataElement msgDataElement = result.getMsgDataElement();

            if (msgDataElement == null) {

                msgDataElement = createMsgDataElement();

                result.setMsgDataElement(msgDataElement);
            }

            if (msgCatalogId != null) {
                msgDataElement.setMsgCatalogId(msgCatalogId);
            }

            if (msgCatalogTokens != null) {
                msgDataElement.setMsgCatalogTokensAsStrings(msgCatalogTokens);
            }

            if (msgId != null) {
                msgDataElement.setMsgId(msgId);
            }
        }

        return result;
    }

    /**
     * @see org.eclipse.tptp.logging.events.cbe.EventFactory#createCommonBaseEvent(short,
     *      org.eclipse.tptp.logging.events.cbe.ComponentIdentification,
     *      org.eclipse.tptp.logging.events.cbe.ComponentIdentification,
     *      org.eclipse.tptp.logging.events.cbe.Situation,
     *      java.lang.String)
     */
    public CommonBaseEvent createCommonBaseEvent(short severity, ComponentIdentification reporterCompId, ComponentIdentification sourceCompId, Situation situation, String msg) {

        CommonBaseEvent result = createCommonBaseEvent(severity, situation, msg);

        if (reporterCompId != null) {
            result.setReporterComponentId(reporterCompId);
        }

        if (sourceCompId != null) {
            result.setSourceComponentId(sourceCompId);
        }

        return result;
    }

    /**
     * @see org.eclipse.tptp.logging.events.cbe.EventFactory#createCommonBaseEvent(short,
     *      org.eclipse.tptp.logging.events.cbe.ComponentIdentification,
     *      org.eclipse.tptp.logging.events.cbe.ComponentIdentification,
     *      org.eclipse.tptp.logging.events.cbe.Situation,
     *      java.lang.String, java.lang.String[], java.lang.String,
     *      java.lang.String)
     */
    public CommonBaseEvent createCommonBaseEvent(short severity, ComponentIdentification reporterCompId, ComponentIdentification sourceCompId, Situation situation, String msgCatalogId, String[] msgCatalogTokens, String msgId, String msg) {

        CommonBaseEvent result = createCommonBaseEvent(severity, situation, msgCatalogId, msgCatalogTokens, msgId, msg);

        if (reporterCompId != null) {
            result.setReporterComponentId(reporterCompId);
        }

        if (sourceCompId != null) {
            result.setSourceComponentId(sourceCompId);
        }

        return result;
    }

    /**
     *  
     * 
     */
    public ComponentIdentification createComponentIdentification() {
        ComponentIdentificationImpl componentIdentification = new ComponentIdentificationImpl();
        return componentIdentification;
    }

    /**
     *  
     * 
     */
    public ConfigureSituation createConfigureSituation() {
        ConfigureSituationImpl configureSituation = new ConfigureSituationImpl();
        return configureSituation;
    }

    /**
     *  
     * 
     */
    public ConnectSituation createConnectSituation() {
        ConnectSituationImpl connectSituation = new ConnectSituationImpl();
        return connectSituation;
    }

    /**
     *  
     * 
     */
    public ContextDataElement createContextDataElement() {
        ContextDataElementImpl contextDataElement = new ContextDataElementImpl();
        return contextDataElement;
    }

    /**
     *  
     * 
     */
    public CreateSituation createCreateSituation() {
        CreateSituationImpl createSituation = new CreateSituationImpl();
        return createSituation;
    }

    /**
     *  
     * 
     */
    public DependencySituation createDependencySituation() {
        DependencySituationImpl dependencySituation = new DependencySituationImpl();
        return dependencySituation;
    }

    /**
     *  
     * 
     */
    public DestroySituation createDestroySituation() {
        DestroySituationImpl destroySituation = new DestroySituationImpl();
        return destroySituation;
    }

    /**
     *  
     * 
     */
    public ExtendedDataElement createExtendedDataElement() {
        ExtendedDataElementImpl extendedDataElement = new ExtendedDataElementImpl();
        return extendedDataElement;
    }

    /**
     *  
     * 
     */
    public FeatureSituation createFeatureSituation() {
        FeatureSituationImpl featureSituation = new FeatureSituationImpl();
        return featureSituation;
    }

    /**
     * Produces a globally unique identifier according to the Internet draft
     * draft-leach-uuids-guids-01 algorithm.
     * 
     * @link {http://www.opengroup.org/dce/info/draft-leach-uuids-guids-01.txt}
     * 
     * @return a globally unique identifier according to the algorith above.
     */
    public String createGlobalInstanceId() {
        Guid guid = new Guid();

        return (GUID_PREFIX + guid.toString());
    }

    /**
     *  
     * 
     */
    public MsgCatalogToken createMsgCatalogToken() {
        MsgCatalogTokenImpl msgCatalogToken = new MsgCatalogTokenImpl();
        return msgCatalogToken;
    }

    /**
     *  
     * 
     */
    public MsgDataElement createMsgDataElement() {
        MsgDataElementImpl msgDataElement = new MsgDataElementImpl();
        return msgDataElement;
    }

    /**
     *  
     * 
     */
    public OtherSituation createOtherSituation() {
        OtherSituationImpl otherSituation = new OtherSituationImpl();
        return otherSituation;
    }

    /**
     *  
     * 
     */
    public ReportSituation createReportSituation() {
        ReportSituationImpl reportSituation = new ReportSituationImpl();
        return reportSituation;
    }

    /**
     *  
     * 
     */
    public RequestSituation createRequestSituation() {
        RequestSituationImpl requestSituation = new RequestSituationImpl();
        return requestSituation;
    }

    /**
     *  
     * 
     */
    public Situation createSituation() {
        SituationImpl situation = new SituationImpl();
        return situation;
    }

    /**
     *  
     * 
     */
    public StartSituation createStartSituation() {
        StartSituationImpl startSituation = new StartSituationImpl();
        return startSituation;
    }

    /**
     *  
     * 
     */
    public StopSituation createStopSituation() {
        StopSituationImpl stopSituation = new StopSituationImpl();
        return stopSituation;
    }

    /*
     * @see org.eclipse.tptp.logging.events.cbe.EventFactory#setContentHandler(org.eclipse.tptp.logging.events.cbe.ContentHandler)
     */
    public void setContentHandler(ContentHandler value) {
        contentHandler = value;
    }

    /*
     * @see org.eclipse.tptp.logging.events.cbe.EventFactory#getContentHandler()
     */
    public ContentHandler getContentHandler() {
        return contentHandler;
    }

    /*
     * @see org.eclipse.tptp.logging.events.cbe.EventFactory#setCompleteEvent(boolean)
     */
    public void setCompleteEvent(boolean completeEvent) {
        this.completeEvent = completeEvent;
    }

    /*
     * @see org.eclipse.tptp.logging.events.cbe.EventFactory#getCompleteEvent()
     */
    public boolean getCompleteEvent() {
        return completeEvent;
    }

    /**
     * @see javax.naming.Referenceable#getReference()
     */
    public Reference getReference() throws NamingException {

        ByteArrayOutputStream bos = new ByteArrayOutputStream();

        try {
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            try {
                oos.writeObject(contentHandler);
            } finally {
                oos.close();
            }
        } catch (IOException e) {
            throw new NamingException(LoggingCoreResourceBundle.getString("LOG_FAILED_TO_SERIALIZE_CONTENT_HANDLER_EXC_", e.getLocalizedMessage()));
        }

        byte[] stream = bos.toByteArray();
        BinaryRefAddr refAddr = new BinaryRefAddr(CBE_INSTANCE_ADDRESS, stream);
        Reference result = new Reference(EventFactoryImpl.class.getName(), refAddr, EventFactoryObjectFactory.class.getName(), null); // factory
                                                                                                                                        // location

        return result;
    }

    /**
     * Accessor method to retrieve the instance of the singleton factory.
     * 
     * @return EventFactory
     */
    public static EventFactory getInstance() {
        return EventFactory.eINSTANCE;
    }
} // EventFactoryImpl
