package org.eclipse.tptp.logging.events.cbe.impl;

import org.eclipse.hyades.logging.core.LoggingCoreResourceBundle;
import org.eclipse.tptp.logging.events.cbe.FeatureSituation;
import org.eclipse.tptp.logging.events.cbe.MissingPropertyException;
import org.eclipse.tptp.logging.events.cbe.ValidationException;

/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FeatureSituationImpl.java,v 1.1 2006/09/06 17:54:04 cjin Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Interface representing a <code>FeatureSituation</code>.
 * <p>
 * The following description is from the Common Base Event v1.0.1 specification
 * entitled "Canonical Situation Data Format: The Common Base Event V1.0.1":
 * <p>
 * The FeatureSituation deals with the situations that announce that a feature
 * of a component is now ready (or not ready) for service requests. Situations
 * that indicate things like services being available and services or features
 * being unavailable fall into this category. Existing situations include words
 * like "now available", "currently available", and "transport is listening on
 * port 123", for example:
 * <p>
 * <ul>
 * <li>SRVE0171I: Transport HTTPS is listening on port 9443</li>
 * <br>
 * <li>MSGS0601I: WebSphere Embedded Messaging has not been installed</li>
 * </ul>
 * <p>
 * 
 * 
 * @author Paul E. Slauenwhite
 * @version February 5, 2006
 * @since 1.0.1
 */
public class FeatureSituationImpl extends SituationTypeImpl implements FeatureSituation {

    /** Automatically generated javadoc for: serialVersionUID */
    private static final long serialVersionUID = 6050554845460888366L;

    /**
     * The cached value of the '
     * {@link #getFeatureDisposition() <em>Feature Disposition</em>}'
     * attribute.  
     * 
     * @see #getFeatureDisposition()
     */
    protected String featureDisposition = null;

    /**
     *  
     * 
     */
    protected FeatureSituationImpl() {
        super();
    }

    /**
     *  
     * 
     */
    public String getFeatureDisposition() {
        return featureDisposition;
    }

    /**
     *  
     * 
     */
    public void setFeatureDisposition(String newFeatureDisposition) {
        featureDisposition = newFeatureDisposition;
    }

    /**
     *  
     * 
     */
    public String toString() {

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (featureDisposition: ");
        result.append(featureDisposition);
        result.append(')');
        return result.toString();
    }

    /**
     * Checks whether the contents of the instance conform to the Common Base Event 
     * specification as described in "Canonical Situation Data Format: The Common Base Event 
     * V1.0.1".
     * <p>
     * 
     * @throws ValidationException If the event instance does not conform to the Common Base Event specification.
     */
    public void validate() throws ValidationException {

        synchronized (this) {

            super.validate();

            //Step 1:  Check for required properties:
            if(featureDisposition == null){
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString("LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", "CommonBaseEvent.Situation.FeatureSituation.FeatureDisposition")); 
            }

            //Step 2:  Check content of each property:
            if(featureDisposition.length() > 64){
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LENGTH_EXC_", "CommonBaseEvent.Situation.FeatureSituation.FeatureDisposition", featureDisposition, new Integer(featureDisposition.length()), new Integer(64)));
            }
        }
    }

    /**
     * Return a cloned (copy by value) object of this object. 
     * <p>
     * This is a deep copy version, in which all the objects 
     * within this object will be copied by value.
     * <p>
     * 
     * @return Object The cloned (copy by value) object of this object.
     * @throws CloneNotSupportedException If a instance variable of this object does not implement the <code>Cloneable</code> interface.   
     */
    public Object clone() throws CloneNotSupportedException {

        synchronized (this) {

            FeatureSituationImpl copy = ((FeatureSituationImpl) (super.clone()));

            if(this.featureDisposition != null){
                copy.setFeatureDisposition(new String(this.featureDisposition));                                
            }

            return copy;
        }            
    }

    /**
     * Overrides the <code>java.lang.Object</code>'s equals() API to 
     * determine if the parameter <code>object</code> is equal to this object.
     * <p>
     * 
     * @param object The <code>java.lang.Object</code> to be compared to this object.
     * @return True, if this object is the same as the parameter <code>object</code>, otherwise false.
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object object) {

        synchronized (this) {
            
            //Check if the parameter object is the same object reference as this object (e.g. equal):
            if (this == object){
                return true;
            }
            else {

                //Check if the parameter object is null and is the a different type as this object(e.g. not equal):
                if ((object != null) && (getClass() == object.getClass())) {

                    //Compare the value(s) of all object properties:
                    Object thisObjectsProperty = getFeatureDisposition();
                    Object parameterObjectsProperty = ((FeatureSituationImpl) (object)).getFeatureDisposition();

                    if (((thisObjectsProperty != null) && (thisObjectsProperty.equals(parameterObjectsProperty))) || ((thisObjectsProperty == null) && (parameterObjectsProperty == null))){
                        return true;
                    }
                }
            }

            return false;
        }
    }

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * All components are initialized to either zero or null.
     * 
     * @since 1.0
     */
    public void init() {

        super.init();

        setFeatureDisposition(null);
    }
}