package org.eclipse.tptp.logging.events.cbe.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;

import org.eclipse.hyades.logging.core.LoggingCoreResourceBundle;
import org.eclipse.tptp.logging.events.cbe.EventFactory;
import org.eclipse.tptp.logging.events.cbe.MsgCatalogToken;
import org.eclipse.tptp.logging.events.cbe.MsgDataElement;
import org.eclipse.tptp.logging.events.cbe.ValidationException;

/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MsgDataElementImpl.java,v 1.1 2006/09/06 17:54:03 cjin Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Interface representing a <code>MsgDataElement</code>.
 * <p>
 * The following description is from the Common Base Event v1.0.1 specification
 * entitled "Canonical Situation Data Format: The Common Base Event V1.0.1":
 * <p>
 * The MsgDataElement represents the data that is used to specify all of the
 * related information that is associated with the message that this event
 * holds.
 * <p>
 * 
 * 
 * @author Paul E. Slauenwhite
 * @version February 5, 2006
 * @since 1.0.1
 */
public class MsgDataElementImpl implements MsgDataElement {

    /** Automatically generated javadoc for: serialVersionUID */
    private static final long serialVersionUID = -4093681142902289230L;

    /**
     * The cached value of the '{@link #getMsgIdType() <em>Msg Id Type</em>}'
     * attribute.  
     * 
     * @see #getMsgIdType()
     */
    protected String msgIdType = null;

    /**
     * The cached value of the '
     * {@link #getMsgCatalogType() <em>Msg Catalog Type</em>}' attribute. <!--
     * begin-user-doc --> 
     * 
     * @see #getMsgCatalogType()
     */
    protected String msgCatalogType = null;

    /**
     * The cached value of the '{@link #getMsgCatalog() <em>Msg Catalog</em>}'
     * attribute.  
     * 
     * @see #getMsgCatalog()
     */
    protected String msgCatalog = null;

    /**
     * The cached value of the '
     * {@link #getMsgCatalogId() <em>Msg Catalog Id</em>}' attribute. <!--
     * begin-user-doc --> 
     * 
     * @see #getMsgCatalogId()
     */
    protected String msgCatalogId = null;

    /**
     * The cached value of the '{@link #getMsgId() <em>Msg Id</em>}'
     * attribute.  
     * 
     * @see #getMsgId()
     */
    protected String msgId = null;

    /**
     * The cached value of the '{@link #getMsgLocale() <em>Msg Locale</em>}'
     * attribute.  
     * 
     * @see #getMsgLocale()
     */
    protected String msgLocale = null;

    /**
     * The cached value of the '
     * {@link #getMsgCatalogTokens() <em>Msg Catalog Tokens</em>}' containment
     * reference list.  
     * 
     * @see #getMsgCatalogTokens()
     */
    protected List msgCatalogTokens = null;

    /**
     *  
     * 
     */
    protected MsgDataElementImpl() {
        super();
    }

    /**
     *  
     * 
     */
    public String getMsgIdType() {
        return msgIdType;
    }

    /**
     *  
     * 
     */
    public void setMsgIdType(String newMsgIdType) {
        msgIdType = newMsgIdType;
    }

    /**
     *  
     * 
     */
    public String getMsgCatalogType() {
        return msgCatalogType;
    }

    /**
     *  
     * 
     */
    public void setMsgCatalogType(String newMsgCatalogType) {
        msgCatalogType = newMsgCatalogType;
    }

    /**
     *  
     * 
     */
    public String getMsgCatalog() {
        return msgCatalog;
    }

    /**
     *  
     * 
     */
    public void setMsgCatalog(String newMsgCatalog) {
        msgCatalog = newMsgCatalog;
    }

    /**
     *  
     * 
     */
    public String getMsgCatalogId() {
        return msgCatalogId;
    }

    /**
     *  
     * 
     */
    public void setMsgCatalogId(String newMsgCatalogId) {
        msgCatalogId = newMsgCatalogId;
    }

    /**
     *  
     * 
     */
    public String getMsgId() {
        return msgId;
    }

    /**
     *  
     * 
     */
    public void setMsgId(String newMsgId) {
        msgId = newMsgId;
    }

    /**
     *  
     * 
     */
    public String getMsgLocale() {
        return msgLocale;
    }

    /**
     *  
     * 
     */
    public void setMsgLocale(String newMsgLocale) {
        msgLocale = newMsgLocale;
    }

    /**
     *  
     * 
     */
    public List getMsgCatalogTokens() {
        if (msgCatalogTokens == null) {
            msgCatalogTokens = new ArrayList();
        }
        return msgCatalogTokens;
    }

    /**
     *  
     * 
     */
    public String toString() {

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (msgIdType: ");
        result.append(msgIdType);
        result.append(", msgCatalogType: ");
        result.append(msgCatalogType);
        result.append(", msgCatalog: ");
        result.append(msgCatalog);
        result.append(", msgCatalogId: ");
        result.append(msgCatalogId);
        result.append(", msgId: ");
        result.append(msgId);
        result.append(", msgLocale: ");
        result.append(msgLocale);
        result.append(", msgCatalogTokens: ");
        result.append(msgCatalogTokens);
        result.append(')');

        return result.toString();
    }

    /**
     * Checks whether the contents of the instance conform to the Common Base Event 
     * specification as described in "Canonical Situation Data Format: The Common Base Event 
     * V1.0.1".
     * <p>
     * 
     * @throws ValidationException If the event instance does not conform to the Common Base Event specification.
     */
    public void validate() throws ValidationException {

        synchronized (this) {

            //Step 1:  Check for mutually inclusive properties:
            if(!(((msgCatalog == null) && (msgCatalogType == null) && (msgCatalogId == null)) || ((msgCatalog != null) && (msgCatalogType != null) && (msgCatalogId != null)))){
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_MISSING_ATTRIBUTES_EXC_", "[CommonBaseEvent.MsgDataElement.MsgCatalog, CommonBaseEvent.MsgDataElement.MsgCatalogType, CommonBaseEvent.MsgDataElement.MsgCatalogId]"));
            }

            if(!(((msgId == null) && (msgIdType == null)) || ((msgId != null) && (msgIdType != null)))){
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_MISSING_ATTRIBUTES_EXC_", "[CommonBaseEvent.MsgDataElement.MsgId, CommonBaseEvent.MsgDataElement.MsgIdType]"));
            }

            //Step 2:  Check content of each property:
            if((msgId != null) && (msgId.length() > 256)){
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LENGTH_EXC_", "CommonBaseEvent.MsgDataElement.MsgId", msgId, new Integer(msgId.length()), new Integer(256)));
            }

            if((msgIdType != null) && (msgIdType.length() > 32)){
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LENGTH_EXC_", "CommonBaseEvent.MsgDataElement.MsgIdType", msgIdType, new Integer(msgIdType.length()), new Integer(32)));
            }
            
            if((msgCatalogId != null) && (msgCatalogId.length() > 64)){
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LENGTH_EXC_", "CommonBaseEvent.MsgDataElement.MsgCatalogId", msgCatalogId, new Integer(msgCatalogId.length()), new Integer(64)));
            }

            if((msgCatalog != null) && (msgCatalog.length() > 128)){
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LENGTH_EXC_", "CommonBaseEvent.MsgDataElement.MsgCatalog", msgCatalog, new Integer(msgCatalog.length()), new Integer(128)));
            }

            if((msgCatalogType != null) && (msgCatalogType.length() > 32)){
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LENGTH_EXC_", "CommonBaseEvent.MsgDataElement.MsgCatalogType", msgCatalogType, new Integer(msgCatalogType.length()), new Integer(32)));
            }

            if((msgLocale != null) && (msgLocale.length() > 11)){
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LENGTH_EXC_", "CommonBaseEvent.MsgDataElement.MsgLocale", msgLocale, new Integer(msgCatalogType.length()), new Integer(11)));
            }

            if (msgCatalogTokens != null) {

                ListIterator iterator = msgCatalogTokens.listIterator();
                MsgCatalogToken msgCatalogToken = null;

                while (iterator.hasNext()) {

                    msgCatalogToken = ((MsgCatalogToken) (iterator.next()));

                    try {
                        msgCatalogToken.validate();
                    } 
                    catch (ValidationException v) {
                        throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LIST_ELEMENT_ATTRIBUTE_EXC_", "CommonBaseEvent.MsgDataElement.MsgCatalogToken".concat("[").concat(String.valueOf(iterator.nextIndex())).concat("]")), v);
                    }
                }
            }
        }
    }

    /**
     * @see org.eclipse.tptp.logging.events.cbe.MsgDataElement#addMsgCatalogToken(org.eclipse.tptp.logging.events.cbe.MsgCatalogToken)
     */
    public MsgCatalogToken addMsgCatalogToken(MsgCatalogToken value) {
        getMsgCatalogTokens().add(value);
        return value;
    }

    /**
     * @see org.eclipse.tptp.logging.events.cbe.MsgDataElement#addMsgCatalogTokenAsString(String)
     */
    public MsgCatalogToken addMsgCatalogTokenAsString(String value) {
        MsgCatalogToken mct = EventFactory.eINSTANCE.createMsgCatalogToken();
        mct.setValue(value);
        return addMsgCatalogToken(mct);
    }

    /**
     * Removes all msgCatalogTokens that this event is referencing
     */
    public void clearMsgCatalogTokens() {
        getMsgCatalogTokens().clear();
    }

    /**
     * @see org.eclipse.tptp.logging.events.cbe.MsgDataElement#getMsgCatalogTokensAsStrings()
     */
    public String[] getMsgCatalogTokensAsStrings() {
        List tokens = getMsgCatalogTokens();
        String[] strTokens = new String[tokens.size()];
        for (int i = 0; i < tokens.size(); i++) {
            MsgCatalogToken element_i = (MsgCatalogToken) tokens.get(i);
            if (element_i == null)
                strTokens[i] = null;
            else
                strTokens[i] = new String((element_i).getValue());
        }
        return strTokens;
    }

    /**
     * @see org.eclipse.tptp.logging.events.cbe.MsgDataElement#setMsgCatalogTokensAsStrings(String[])
     */
    public void setMsgCatalogTokensAsStrings(String[] msgCatalogTokens) {
        List tokens = getMsgCatalogTokens();
        tokens.clear();
        MsgCatalogToken mct;
        for (int i = 0; i < msgCatalogTokens.length; i++) {
            mct = EventFactory.eINSTANCE.createMsgCatalogToken();
            mct.setValue(msgCatalogTokens[i]);
            tokens.add(mct);
        }
    }

    /**
     * @see org.eclipse.tptp.logging.events.cbe.MsgDataElement#setMsgCatalogTokens(org.eclipse.tptp.logging.events.cbe.MsgCatalogToken[])
     */
    public void setMsgCatalogTokens(MsgCatalogToken[] msgCatalogTokens) {
        List tokens = getMsgCatalogTokens();
        tokens.clear();
        tokens.addAll(Arrays.asList(msgCatalogTokens));
    }

    /**
     * Overrides the <code>java.lang.Object</code>'s equals() API to 
     * determine if the parameter <code>object</code> is equal to this object.
     * <p>
     * 
     * @param object The <code>java.lang.Object</code> to be compared to this object.
     * @return True, if this object is the same as the parameter <code>object</code>, otherwise false.
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object object) {

        synchronized (this) {
            
            //Check if the parameter object is the same object reference as this object (e.g. equal):
            if (this == object){
                return true;
            }
            else {

                //Check if the parameter object is null and is the a different type as this object(e.g. not equal):
                if ((object != null) && (getClass() == object.getClass())) {

                    //Compare the value(s) of all object properties:
                    Object thisObjectsProperty = getMsgId();
                    Object parameterObjectsProperty = ((MsgDataElementImpl) (object)).getMsgId();

                    if (((thisObjectsProperty != null) && (thisObjectsProperty.equals(parameterObjectsProperty))) || ((thisObjectsProperty == null) && (parameterObjectsProperty == null))) {
                        
                        thisObjectsProperty = getMsgIdType();
                        parameterObjectsProperty = ((MsgDataElementImpl) (object)).getMsgIdType();

                        if (((thisObjectsProperty != null) && (thisObjectsProperty.equals(parameterObjectsProperty))) || ((thisObjectsProperty == null) && (parameterObjectsProperty == null))) {
                            
                            thisObjectsProperty = getMsgCatalogId();
                            parameterObjectsProperty = ((MsgDataElementImpl) (object)).getMsgCatalogId();

                            if (((thisObjectsProperty != null) && (thisObjectsProperty.equals(parameterObjectsProperty))) || ((thisObjectsProperty == null) && (parameterObjectsProperty == null))) {
                                
                                thisObjectsProperty = getMsgCatalog();
                                parameterObjectsProperty = ((MsgDataElementImpl) (object)).getMsgCatalog();

                                if (((thisObjectsProperty != null) && (thisObjectsProperty.equals(parameterObjectsProperty))) || ((thisObjectsProperty == null) && (parameterObjectsProperty == null))) {
                                    
                                    thisObjectsProperty = getMsgLocale();
                                    parameterObjectsProperty = ((MsgDataElementImpl) (object)).getMsgLocale();

                                    if (((thisObjectsProperty != null) && (thisObjectsProperty.equals(parameterObjectsProperty))) || ((thisObjectsProperty == null) && (parameterObjectsProperty == null))) {
                                        
                                        thisObjectsProperty = getMsgCatalogType();
                                        parameterObjectsProperty = ((MsgDataElementImpl) (object)).getMsgCatalogType();

                                        if (((thisObjectsProperty != null) && (thisObjectsProperty.equals(parameterObjectsProperty))) || ((thisObjectsProperty == null) && (parameterObjectsProperty == null))) {

                                            List thisObjectsListProperty = getMsgCatalogTokens();
                                            List parameterObjectsListProperty = ((MsgDataElementImpl) (object)).getMsgCatalogTokens();
                
                                            if (((thisObjectsListProperty != null) && (thisObjectsListProperty.equals(parameterObjectsListProperty))) || (((thisObjectsListProperty == null) || (thisObjectsListProperty.size() == 0)) && ((parameterObjectsListProperty == null) || (parameterObjectsListProperty.size() == 0)))) {
                                                return true;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }

            return false;
        }
    }
    
    /**
     * Return a cloned (copy by value) object of this object. 
     * <p>
     * This is a deep copy version, in which all the objects 
     * within this object will be copied by value.
     * <p>
     * 
     * @return Object The cloned (copy by value) object of this object.
     * @throws CloneNotSupportedException If a instance variable of this object does not implement the <code>Cloneable</code> interface.   
     */
    public Object clone() throws CloneNotSupportedException {

        synchronized (this) {

            MsgDataElementImpl copy = ((MsgDataElementImpl) (super.clone()));

            if(this.msgCatalog != null){
                copy.setMsgCatalog(new String(this.msgCatalog));                                
            }

            if(this.msgCatalogId != null){
                copy.setMsgCatalogId(new String(this.msgCatalogId));                                
            }

            if (this.msgCatalogTokens != null) {

                copy.msgCatalogTokens = new ArrayList();

                for (int counter = 0; counter < this.msgCatalogTokens.size(); counter++) {
                    
                    try{
                        copy.addMsgCatalogToken(((MsgCatalogToken)(((MsgCatalogTokenImpl)(this.msgCatalogTokens.get(counter))).clone())));
                    } 
                    catch (ClassCastException c) {
                        //Ignore since cloning is supported.
                    }
                }
            }

            if(this.msgCatalogType != null){
                copy.setMsgCatalogType(new String(this.msgCatalogType));                                
            }

            if(this.msgId != null){
                copy.setMsgId(new String(this.msgId));                                
            }

            if(this.msgIdType != null){
                copy.setMsgIdType(new String(this.msgIdType));                                
            }

            if(this.msgLocale != null){
                copy.setMsgLocale(new String(this.msgLocale));                                
            }

            return copy;
        }            
    }

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * All components are initialized to either zero or null.
     * 
     * @since 1.0
     */
    public void init() {

        setMsgCatalog(null);
        setMsgCatalogId(null);
        setMsgCatalogType(null);
        setMsgId(null);
        setMsgIdType(null);
        setMsgLocale(null);

        clearMsgCatalogTokens();
    }
} // MsgDataElementImpl
