package org.eclipse.tptp.logging.events.cbe.impl;

import org.eclipse.hyades.logging.core.LoggingCoreResourceBundle;
import org.eclipse.tptp.logging.events.cbe.MissingPropertyException;
import org.eclipse.tptp.logging.events.cbe.OtherSituation;
import org.eclipse.tptp.logging.events.cbe.ValidationException;

/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OtherSituationImpl.java,v 1.1 2006/09/06 17:54:04 cjin Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Class representing an implementation of an <code>OtherSituation</code>.
 * <p>
 * The following description is from the Common Base Event v1.0.1 specification
 * entitled "Canonical Situation Data Format: The Common Base Event V1.0.1":
 * <p>
 * The OtherSituation category is to provide support for the situation that is
 * product specific requirement other than the predefined categories.
 * <p>
 * 
 * 
 * @author Paul E. Slauenwhite
 * @version February 5, 2006
 * @since 1.0.1
 */
public class OtherSituationImpl extends SituationTypeImpl implements OtherSituation {

    /** Automatically generated javadoc for: serialVersionUID */
    private static final long serialVersionUID = -5897367805519026920L;

    /**
     * The cached value of the '{@link #getAny() <em>Any</em>}' attribute.
     *  
     * 
     * @see #getAny()
     */
    protected String any = null;

    /**
     *  
     * 
     */
    protected OtherSituationImpl() {
        super();
    }

    /**
     *  
     * 
     */
    public String getAny() {
        return any;
    }

    /**
     *  
     * 
     */
    public void setAny(String newAny) {
        any = newAny;
    }

    /**
     *  
     * 
     */
    public String toString() {
     
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (any: ");
        result.append(any);
        result.append(')');
        return result.toString();
    }

    /**
     * Checks whether the contents of the instance conform to the Common Base Event 
     * specification as described in "Canonical Situation Data Format: The Common Base Event 
     * V1.0.1".
     * <p>
     * 
     * @throws ValidationException If the event instance does not conform to the Common Base Event specification.
     */
    public void validate() throws ValidationException {

        synchronized (this) {

            super.validate();

            //Step 1:  Check for required properties:
            if(any == null){
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString("LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", "CommonBaseEvent.Situation.OtherSituation.Any")); 
            }
        }
    }
    
    /**
     * Return a cloned (copy by value) object of this object. 
     * <p>
     * This is a deep copy version, in which all the objects 
     * within this object will be copied by value.
     * <p>
     * 
     * @return Object The cloned (copy by value) object of this object.
     * @throws CloneNotSupportedException If a instance variable of this object does not implement the <code>Cloneable</code> interface.   
     */
    public Object clone() throws CloneNotSupportedException {

        synchronized (this) {

            OtherSituationImpl copy = ((OtherSituationImpl) (super.clone()));

            if(this.any != null){
                copy.setAny(new String(this.any));                                
            }

            return copy;
        }            
    }

    /**
     * Overrides the <code>java.lang.Object</code>'s equals() API to 
     * determine if the parameter <code>object</code> is equal to this object.
     * <p>
     * 
     * @param object The <code>java.lang.Object</code> to be compared to this object.
     * @return True, if this object is the same as the parameter <code>object</code>, otherwise false.
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object object) {

        synchronized (this) {
            
            //Check if the parameter object is the same object reference as this object (e.g. equal):
            if (this == object){
                return true;
            }
            else {

                //Check if the parameter object is null and is the a different type as this object(e.g. not equal):
                if ((object != null) && (getClass() == object.getClass())) {

                    //Compare the value(s) of all object properties:
                    Object thisObjectsProperty = getAny();
                    Object parameterObjectsProperty = ((OtherSituationImpl) (object)).getAny();

                    if (((thisObjectsProperty != null) && (thisObjectsProperty.equals(parameterObjectsProperty))) || ((thisObjectsProperty == null) && (parameterObjectsProperty == null))){
                        return true;
                    }
                }
            }

            return false;
        }
    }

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * All components are initialized to either zero or null.
     * 
     * @since 1.0
     */
    public void init() {

        super.init();

        setAny(null);
    }
} 