package org.eclipse.tptp.logging.events.cbe.impl;

import org.eclipse.hyades.logging.core.LoggingCoreResourceBundle;
import org.eclipse.tptp.logging.events.cbe.AvailableSituation;
import org.eclipse.tptp.logging.events.cbe.ConfigureSituation;
import org.eclipse.tptp.logging.events.cbe.ConnectSituation;
import org.eclipse.tptp.logging.events.cbe.CreateSituation;
import org.eclipse.tptp.logging.events.cbe.DependencySituation;
import org.eclipse.tptp.logging.events.cbe.DestroySituation;
import org.eclipse.tptp.logging.events.cbe.EventFactory;
import org.eclipse.tptp.logging.events.cbe.FeatureSituation;
import org.eclipse.tptp.logging.events.cbe.MissingPropertyException;
import org.eclipse.tptp.logging.events.cbe.OtherSituation;
import org.eclipse.tptp.logging.events.cbe.ReportSituation;
import org.eclipse.tptp.logging.events.cbe.RequestSituation;
import org.eclipse.tptp.logging.events.cbe.Situation;
import org.eclipse.tptp.logging.events.cbe.SituationType;
import org.eclipse.tptp.logging.events.cbe.StartSituation;
import org.eclipse.tptp.logging.events.cbe.StopSituation;
import org.eclipse.tptp.logging.events.cbe.ValidationException;

/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SituationImpl.java,v 1.1 2006/09/06 17:54:04 cjin Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Interface representing a <code>Situation</code>.
 * <p>
 * 
 * 
 * @author Paul E. Slauenwhite
 * @version February 5, 2006
 * @since 1.0.1
 */
public class SituationImpl implements Situation {

    /** Automatically generated javadoc for: serialVersionUID */
    private static final long serialVersionUID = 8478109585082201367L;

    /**
     * The cached value of the '
     * {@link #getCategoryName() <em>Category Name</em>}' attribute. <!--
     * begin-user-doc --> 
     * 
     * @see #getCategoryName()
     */
    protected String categoryName = null;

    /**
     * The cached value of the '
     * {@link #getSituationType() <em>Situation Type</em>}' containment
     * reference.  
     * 
     * @see #getSituationType()
     */
    protected SituationType situationType = null;

    /**
     *  
     * 
     */
    protected SituationImpl() {
        super();
    }

    /**
     * @see org.eclipse.tptp.logging.events.cbe.Situation#setAvailableSituation(String,
     *      String, String,String)
     */
    public void setAvailableSituation(String reasoningScope, String availabilityDisposition, String operationDisposition, String processingDisposition) {
        AvailableSituation as = EventFactory.eINSTANCE.createAvailableSituation();
        as.setReasoningScope(reasoningScope);
        as.setAvailabilityDisposition(availabilityDisposition);
        as.setOperationDisposition(operationDisposition);
        as.setProcessingDisposition(processingDisposition);
        setSituationType(as);
        setCategoryName(AVAILABLE_SITUATION_CATEGORY);
    }

    /**
     *  
     * 
     */
    public void setCategoryName(String newCategoryName) {
        categoryName = newCategoryName;
    }

    /**
     *  
     * 
     */
    public String getCategoryName() {
        return categoryName;
    }

    /**
     * @see org.eclipse.tptp.logging.events.cbe.Situation#setConfigureSituation(String,String)
     */
    public void setConfigureSituation(String reasoningScope, String successDisposition) {
        ConfigureSituation cs = EventFactory.eINSTANCE.createConfigureSituation();
        cs.setReasoningScope(reasoningScope);
        cs.setSuccessDisposition(successDisposition);
        setSituationType(cs);
        setCategoryName(CONFIGURE_SITUATION_CATEGORY);
    }

    /**
     * @see org.eclipse.tptp.logging.events.cbe.Situation#setConnectSituation(String,
     *      String,String)
     */
    public void setConnectSituation(String reasoningScope, String situationDisposition, String successDisposition) {
        ConnectSituation cs = EventFactory.eINSTANCE.createConnectSituation();
        cs.setReasoningScope(reasoningScope);
        cs.setSituationDisposition(situationDisposition);
        cs.setSuccessDisposition(successDisposition);
        setSituationType(cs);
        setCategoryName(CONNECT_SITUATION_CATEGORY);
    }

    /**
     * @see org.eclipse.tptp.logging.events.cbe.Situation#setCreateSituation(String,String)
     */
    public void setCreateSituation(String reasoningScope, String successDisposition) {
        CreateSituation cs = EventFactory.eINSTANCE.createCreateSituation();
        cs.setReasoningScope(reasoningScope);
        cs.setSuccessDisposition(successDisposition);
        setSituationType(cs);
        setCategoryName(CREATE_SITUATION_CATEGORY);
    }

    /**
     * @see org.eclipse.tptp.logging.events.cbe.Situation#setDependencySituation(String,String)
     */
    public void setDependencySituation(String reasoningScope, String dependencyDisposition) {
        DependencySituation ds = EventFactory.eINSTANCE.createDependencySituation();
        ds.setReasoningScope(reasoningScope);
        ds.setDependencyDisposition(dependencyDisposition);
        setSituationType(ds);
        setCategoryName(DEPENDENCY_SITUATION_CATEGORY);
    }

    /**
     * @see org.eclipse.tptp.logging.events.cbe.Situation#setDestroySituation(String,String)
     */
    public void setDestroySituation(String reasoningScope, String successDisposition) {
        DestroySituation ds = EventFactory.eINSTANCE.createDestroySituation();
        ds.setReasoningScope(reasoningScope);
        ds.setSuccessDisposition(successDisposition);
        setSituationType(ds);
        setCategoryName(DESTROY_SITUATION_CATEGORY);
    }

    /**
     * @see org.eclipse.tptp.logging.events.cbe.Situation#setFeatureSituation(String,String)
     */
    public void setFeatureSituation(String reasoningScope, String featureDisposition) {
        FeatureSituation fs = EventFactory.eINSTANCE.createFeatureSituation();
        fs.setReasoningScope(reasoningScope);
        fs.setFeatureDisposition(featureDisposition);
        setSituationType(fs);
        setCategoryName(FEATURE_SITUATION_CATEGORY);
    }

    /**
     * @see org.eclipse.tptp.logging.events.cbe.Situation#setOtherSituation(String,String)
     */
    public void setOtherSituation(String reasoningScope, String any) {
        OtherSituation os = EventFactory.eINSTANCE.createOtherSituation();
        os.setReasoningScope(reasoningScope);
        os.setAny(any);
        setSituationType(os);
        setCategoryName(OTHER_SITUATION_CATEGORY);
    }

    /**
     * @see org.eclipse.tptp.logging.events.cbe.Situation#setReportSituation(String,String)
     */
    public void setReportSituation(String reasoningScope, String reportCategory) {
        ReportSituation rs = EventFactory.eINSTANCE.createReportSituation();
        rs.setReasoningScope(reasoningScope);
        rs.setReportCategory(reportCategory);
        setSituationType(rs);
        setCategoryName(REPORT_SITUATION_CATEGORY);
    }

    /**
     * @see org.eclipse.tptp.logging.events.cbe.Situation#setRequestSituation(String,
     *      String,String)
     */
    public void setRequestSituation(String reasoningScope, String situationQualifier, String successDisposition) {
        RequestSituation rs = EventFactory.eINSTANCE.createRequestSituation();
        rs.setReasoningScope(reasoningScope);
        rs.setSituationQualifier(situationQualifier);
        rs.setSuccessDisposition(successDisposition);
        setSituationType(rs);
        setCategoryName(REQUEST_SITUATION_CATEGORY);
    }

    /**
     *  
     * 
     */
    public void setSituationType(SituationType newSituationType) {
        situationType = newSituationType;
    }

    /**
     *  
     * 
     */
    public SituationType getSituationType() {
        return situationType;
    }

    /**
     * @see org.eclipse.tptp.logging.events.cbe.Situation#setStartSituation(String,
     *      String,String)
     */
    public void setStartSituation(String reasoningScope, String situationQualifier, String successDisposition) {
        StartSituation ss = EventFactory.eINSTANCE.createStartSituation();
        ss.setReasoningScope(reasoningScope);
        ss.setSituationQualifier(situationQualifier);
        ss.setSuccessDisposition(successDisposition);
        setSituationType(ss);
        setCategoryName(START_SITUATION_CATEGORY);
    }

    /**
     * @see org.eclipse.tptp.logging.events.cbe.Situation#setStopSituation(String,
     *      String,String)
     */
    public void setStopSituation(String reasoningScope, String situationQualifier, String successDisposition) {
        StopSituation ss = EventFactory.eINSTANCE.createStopSituation();
        ss.setReasoningScope(reasoningScope);
        ss.setSituationQualifier(situationQualifier);
        ss.setSuccessDisposition(successDisposition);
        setSituationType(ss);
        setCategoryName(STOP_SITUATION_CATEGORY);
    }

    /**
     *  
     * 
     */
    public String toString() {

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (categoryName: ");
        result.append(categoryName);
        result.append(", situationType: ");
        result.append(situationType);
        result.append(')');
        return result.toString();
    }

    /**
     * Checks whether the contents of the instance conform to the Common Base Event 
     * specification as described in "Canonical Situation Data Format: The Common Base Event 
     * V1.0.1".
     * <p>
     * 
     * @throws ValidationException If the event instance does not conform to the Common Base Event specification.
     */
    public void validate() throws ValidationException {

        synchronized(this){

            //Step 1:  Check for required properties:
            if(situationType == null){
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString("LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", "CommonBaseEvent.Situation.SituationType")); 
            }

            if(categoryName == null){
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString("LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", "CommonBaseEvent.Situation.CategoryName")); 
            }

            //Step 2:  Check content of each property:
            situationType.validate();
            
            if(categoryName.length() > 64){
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LENGTH_EXC_", "CommonBaseEvent.Situation.CategoryName", categoryName, new Integer(categoryName.length()), new Integer(64)));
            }

            if((!categoryName.equals(START_SITUATION_CATEGORY)) && (!categoryName.equals(STOP_SITUATION_CATEGORY)) && (!categoryName.equals(CONNECT_SITUATION_CATEGORY)) && (!categoryName.equals(CONFIGURE_SITUATION_CATEGORY)) && (!categoryName.equals(REQUEST_SITUATION_CATEGORY)) && (!categoryName.equals(FEATURE_SITUATION_CATEGORY)) && (!categoryName.equals(DEPENDENCY_SITUATION_CATEGORY)) && (!categoryName.equals(CREATE_SITUATION_CATEGORY)) && (!categoryName.equals(DESTROY_SITUATION_CATEGORY)) && (!categoryName.equals(REPORT_SITUATION_CATEGORY)) && (!categoryName.equals(AVAILABLE_SITUATION_CATEGORY)) && (!categoryName.equals(OTHER_SITUATION_CATEGORY))){
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_SITUATION_TYPE_EXC_", "CommonBaseEvent.Situation.CategoryName", categoryName, "[".concat(START_SITUATION_CATEGORY).concat(STOP_SITUATION_CATEGORY).concat(CONNECT_SITUATION_CATEGORY).concat(CONFIGURE_SITUATION_CATEGORY).concat(REQUEST_SITUATION_CATEGORY).concat(FEATURE_SITUATION_CATEGORY).concat(DEPENDENCY_SITUATION_CATEGORY).concat(CREATE_SITUATION_CATEGORY).concat(DESTROY_SITUATION_CATEGORY).concat(REPORT_SITUATION_CATEGORY).concat(AVAILABLE_SITUATION_CATEGORY).concat(OTHER_SITUATION_CATEGORY).concat("]")));
            }

            if ((categoryName.equals(START_SITUATION_CATEGORY) && !(situationType instanceof StartSituation))
                    || (categoryName.equals(STOP_SITUATION_CATEGORY) && !(situationType instanceof StopSituation))
                    || (categoryName.equals(CONNECT_SITUATION_CATEGORY) && !(situationType instanceof ConnectSituation))
                    || (categoryName.equals(CONFIGURE_SITUATION_CATEGORY) && !(situationType instanceof ConfigureSituation))
                    || (categoryName.equals(REQUEST_SITUATION_CATEGORY) && !(situationType instanceof RequestSituation))
                    || (categoryName.equals(FEATURE_SITUATION_CATEGORY) && !(situationType instanceof FeatureSituation))
                    || (categoryName.equals(DEPENDENCY_SITUATION_CATEGORY) && !(situationType instanceof DependencySituation))
                    || (categoryName.equals(CREATE_SITUATION_CATEGORY) && !(situationType instanceof CreateSituation))
                    || (categoryName.equals(DESTROY_SITUATION_CATEGORY) && !(situationType instanceof DestroySituation))
                    || (categoryName.equals(REPORT_SITUATION_CATEGORY) && !(situationType instanceof ReportSituation))
                    || (categoryName.equals(AVAILABLE_SITUATION_CATEGORY) && !(situationType instanceof AvailableSituation))
                    || (categoryName.equals(OTHER_SITUATION_CATEGORY) && !(situationType instanceof OtherSituation))) {
                    throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_CATEGORY_MISMATCH_EXC_",  "CommonBaseEvent.Situation.SituationType", categoryName, situationType.getClass().getName()));
            }
        }
    }

    /**
     * Overrides the <code>java.lang.Object</code>'s equals() API to 
     * determine if the parameter <code>object</code> is equal to this object.
     * <p>
     * 
     * @param object The <code>java.lang.Object</code> to be compared to this object.
     * @return True, if this object is the same as the parameter <code>object</code>, otherwise false.
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object object) {

        synchronized (this) {
            
            //Check if the parameter object is the same object reference as this object (e.g. equal):
            if (this == object){
                return true;
            }
            else {

                //Check if the parameter object is null and is the a different type as this object(e.g. not equal):
                if ((object != null) && (getClass() == object.getClass())) {

                    //Compare the value(s) of all object properties:
                    Object thisObjectsProperty = getCategoryName();
                    Object parameterObjectsProperty = ((SituationImpl) (object)).getCategoryName();

                    if (((thisObjectsProperty != null) && (thisObjectsProperty.equals(parameterObjectsProperty))) || ((thisObjectsProperty == null) && (parameterObjectsProperty == null))) {

                        thisObjectsProperty = getSituationType();
                        parameterObjectsProperty = ((SituationImpl) (object)).getSituationType();

                        if (((thisObjectsProperty != null) && (thisObjectsProperty.equals(parameterObjectsProperty))) || ((thisObjectsProperty == null) && (parameterObjectsProperty == null))){
                            return true;
                        }
                    }
                }
            }

            return false;
        }
    }

    /**
     * Return a cloned (copy by value) object of this object. 
     * <p>
     * This is a deep copy version, in which all the objects 
     * within this object will be copied by value.
     * <p>
     * 
     * @return Object The cloned (copy by value) object of this object.
     * @throws CloneNotSupportedException If a instance variable of this object does not implement the <code>Cloneable</code> interface.   
     */
    public Object clone() throws CloneNotSupportedException {

        synchronized (this) {

            SituationImpl copy = ((SituationImpl) (super.clone()));

            if(this.categoryName != null){
                copy.setCategoryName(new String(this.categoryName));                                
            }

            if(this.situationType != null){

                try {
                    copy.setSituationType(((SituationType) ((SituationTypeImpl) (this.situationType)).clone()));                
                } 
                catch (ClassCastException c) {
                    //Ignore since cloning is supported.
                }
            }
            
            return copy;
        }            
    }

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * All components are initialized to either zero or null.
     * 
     * @since 1.0
     */
    public void init() {

        setCategoryName(null);
        setSituationType(null);
    }
} 