package org.eclipse.tptp.logging.events.cbe.impl;

import org.eclipse.hyades.logging.core.LoggingCoreResourceBundle;
import org.eclipse.tptp.logging.events.cbe.MissingPropertyException;
import org.eclipse.tptp.logging.events.cbe.SituationType;
import org.eclipse.tptp.logging.events.cbe.ValidationException;

/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SituationTypeImpl.java,v 1.1 2006/09/06 17:54:04 cjin Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Interface representing a <code>SituationType</code>.
 * <p>
 * The following description is from the Common Base Event v1.0.1 specification
 * entitled "Canonical Situation Data Format: The Common Base Event V1.0.1":
 * <p>
 * The situationType specifies the type or category of the situation that caused
 * the event to be reported. The categorization of situations facilitates the
 * building of tools that focus on implementing the analysis and planning
 * functions rather than on product-specific data formats. The data type for
 * this property is a complex type. The situation types or categories are
 * defined below. SituationType is an abstract element that is used to define
 * all supported situation types (for example, StartSituation, StopSituation,
 * etc...).
 * <p>
 * The simplest way to understand the usefulness of categorization is by
 * providing a use case. For example, assume that a problem has been detected
 * with component 'A'. The first step in the root cause analysis might be to
 * check to see if 'x' was actually started, since it is known that 'A' has a
 * dependency on 'x'. One approach to determine if 'x' is running is to check
 * the log file for 'x' to see if it has started. The problem from a
 * programmatic perspective is that there is not standard way to check the log
 * files to see if 'x' has started. 'x' might log "Component 'x' started" or it
 * might log "Change server state from starting to running". The reality is that
 * both of these messages provide the same information, but they provide it
 * using different terminology, making it difficult for a program to use. Simple
 * checks like this would be much easier if all components reported, for
 * example, that they "started". Writing code to check dependencies would be
 * much easier and would be, largely, component independent. For example, if
 * product 'A' had dependencies on 'x' and 'y', the code to check the status of
 * 'x' and the code to check the status of 'y' would be the same, in both cases,
 * it would look for a 'started' message.
 * <p>
 * 
 * 
 * @author Paul E. Slauenwhite
 * @version February 5, 2006
 * @since 1.0.1
 */
public abstract class SituationTypeImpl implements SituationType {

    /** Automatically generated javadoc for: serialVersionUID */
    private static final long serialVersionUID = -8522169030887137276L;

    /**
     * The cached value of the '
     * {@link #getReasoningScope() <em>Reasoning Scope</em>}' attribute. <!--
     * begin-user-doc --> 
     * 
     * @see #getReasoningScope()
     */
    protected String reasoningScope = null;

    /**
     *  
     * 
     */
    protected SituationTypeImpl() {
        super();
    }

    /**
     *  
     * 
     */
    public String getReasoningScope() {
        return reasoningScope;
    }

    /**
     *  
     * 
     */
    public void setReasoningScope(String newReasoningScope) {
        reasoningScope = newReasoningScope;
    }

    /**
     *  
     * 
     */
    public String toString() {

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (reasoningScope: ");
        result.append(reasoningScope);
        result.append(')');
        return result.toString();
    }

    /**
     * Checks whether the contents of the instance conform to the Common Base Event 
     * specification as described in "Canonical Situation Data Format: The Common Base Event 
     * V1.0.1".
     * <p>
     * 
     * @throws ValidationException If the event instance does not conform to the Common Base Event specification.
     */
    public void validate() throws ValidationException {

        synchronized (this) {

            //Step 1:  Check for required properties:
            if(reasoningScope == null){
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString("LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", "CommonBaseEvent.Situation.SituationType.ReasoningScope")); 
            }

            //Step 2:  Check content of each property:
            if(reasoningScope.length() > 64){
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LENGTH_EXC_", "CommonBaseEvent.Situation.SituationType.ReasoningScope", reasoningScope, new Integer(reasoningScope.length()), new Integer(64)));
            }
        }
    }

    /**
     * Overrides the <code>java.lang.Object</code>'s equals() API to 
     * determine if the parameter <code>object</code> is equal to this object.
     * <p>
     * 
     * @param object The <code>java.lang.Object</code> to be compared to this object.
     * @return True, if this object is the same as the parameter <code>object</code>, otherwise false.
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object object) {

        synchronized (this) {
            
            //Check if the parameter object is the same object reference as this object (e.g. equal):
            if (this == object){
                return true;
            }
            else {

                //Check if the parameter object is null and is the a different type as this object(e.g. not equal):
                if ((object != null) && (getClass() == object.getClass())) {

                    //Compare the value(s) of all object properties:
                    Object thisObjectsProperty = getReasoningScope();
                    Object parameterObjectsProperty = ((SituationTypeImpl) (object)).getReasoningScope();

                    if (((thisObjectsProperty != null) && (thisObjectsProperty.equals(parameterObjectsProperty))) || ((thisObjectsProperty == null) && (parameterObjectsProperty == null))){
                        return true;
                    }
                }
            }

            return false;
        }
    }

    /**
     * Return a cloned (copy by value) object of this object. 
     * <p>
     * This is a deep copy version, in which all the objects 
     * within this object will be copied by value.
     * <p>
     * 
     * @return Object The cloned (copy by value) object of this object.
     * @throws CloneNotSupportedException If a instance variable of this object does not implement the <code>Cloneable</code> interface.   
     */
    public Object clone() throws CloneNotSupportedException {

        synchronized (this) {

            SituationTypeImpl copy = ((SituationTypeImpl) (super.clone()));

            if(this.reasoningScope != null){
                copy.setReasoningScope(new String(this.reasoningScope));                                
            }

            return copy;
        }            
    }

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * All components are initialized to either zero or null.
     * 
     * @since 1.0
     */
    public void init() {
        setReasoningScope(null);
    }
} 
