package org.eclipse.tptp.logging.events.cbe.impl;

import org.eclipse.hyades.logging.core.LoggingCoreResourceBundle;
import org.eclipse.tptp.logging.events.cbe.MissingPropertyException;
import org.eclipse.tptp.logging.events.cbe.StopSituation;
import org.eclipse.tptp.logging.events.cbe.ValidationException;

/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: StopSituationImpl.java,v 1.1 2006/09/06 17:54:04 cjin Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Interface representing a <code>StopSituation</code>.
 * <p>
 * The following description is from the Common Base Event v1.0.1 specification
 * entitled "Canonical Situation Data Format: The Common Base Event V1.0.1":
 * <p>
 * The StopSituation deals with the shutdown process for a component. Message
 * that indicate that a component has begun to stop, that it has stopped, or
 * that the stopping process has failed all fall into this category. Existing
 * messages include words like "stop", "stopping", "stopped", "completed", and
 * "exiting", for example:
 * <p>
 * <ul>
 * <li>WSVR0220I: Application stopped: {0}</li>
 * <br>
 * <li>WSVR0102E: An error occurred stopping, {0}</li>
 * <br>
 * <li>MSGS0657I: Stopping the MQJD JMS Provider</li>
 * </ul>
 * <p>
 * 
 * 
 * @author Paul E. Slauenwhite
 * @version February 5, 2006
 * @since 1.0.1
 */
public class StopSituationImpl extends SituationTypeImpl implements StopSituation {

    /** Automatically generated javadoc for: serialVersionUID */
    private static final long serialVersionUID = 751277197537638071L;

    /**
     * The cached value of the '
     * {@link #getSuccessDisposition() <em>Success Disposition</em>}'
     * attribute.  
     * 
     * @see #getSuccessDisposition()
     */
    protected String successDisposition = null;

    /**
     * The cached value of the '
     * {@link #getSituationQualifier() <em>Situation Qualifier</em>}'
     * attribute.  
     * 
     * @see #getSituationQualifier()
     */
    protected String situationQualifier = null;

    /**
     *  
     * 
     */
    protected StopSituationImpl() {
        super();
    }

    /**
     *  
     * 
     */
    public String getSuccessDisposition() {
        return successDisposition;
    }

    /**
     *  
     * 
     */
    public void setSuccessDisposition(String newSuccessDisposition) {
        successDisposition = newSuccessDisposition;
    }

    /**
     *  
     * 
     */
    public String getSituationQualifier() {
        return situationQualifier;
    }

    /**
     *  
     * 
     */
    public void setSituationQualifier(String newSituationQualifier) {
        situationQualifier = newSituationQualifier;
    }

    /**
     *  
     * 
     */
    public String toString() {

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (successDisposition: ");
        result.append(successDisposition);
        result.append(", situationQualifier: ");
        result.append(situationQualifier);
        result.append(')');
        return result.toString();
    }

    /**
     * Checks whether the contents of the instance conform to the Common Base Event 
     * specification as described in "Canonical Situation Data Format: The Common Base Event 
     * V1.0.1".
     * <p>
     * 
     * @throws ValidationException If the event instance does not conform to the Common Base Event specification.
     */
    public void validate() throws ValidationException {

        synchronized (this) {

            super.validate();

            //Step 1:  Check for required properties:
            if(successDisposition == null){
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString("LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", "CommonBaseEvent.Situation.StopSituation.SuccessDisposition")); 
            }

            if(situationQualifier == null){
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString("LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", "CommonBaseEvent.Situation.StopSituation.SituationQualifier")); 
            }

            //Step 2:  Check content of each property:
            if(successDisposition.length() > 64){
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LENGTH_EXC_", "CommonBaseEvent.Situation.StopSituation.SuccessDisposition", successDisposition, new Integer(successDisposition.length()), new Integer(64)));
            }

            if(situationQualifier.length() > 64){
                throw new ValidationException(LoggingCoreResourceBundle.getString("LOG_INVALID_LENGTH_EXC_", "CommonBaseEvent.Situation.StopSituation.SituationQualifier", situationQualifier, new Integer(situationQualifier.length()), new Integer(64)));
            }
        }
    }

    /**
     * Return a cloned (copy by value) object of this object. 
     * <p>
     * This is a deep copy version, in which all the objects 
     * within this object will be copied by value.
     * <p>
     * 
     * @return Object The cloned (copy by value) object of this object.
     * @throws CloneNotSupportedException If a instance variable of this object does not implement the <code>Cloneable</code> interface.   
     */
    public Object clone() throws CloneNotSupportedException {

        synchronized (this) {

            StopSituationImpl copy = ((StopSituationImpl) (super.clone()));

            if(this.situationQualifier != null){
                copy.setSituationQualifier(new String(this.situationQualifier));                                
            }

            if(this.successDisposition != null){
                copy.setSuccessDisposition(new String(this.successDisposition));                                
            }

            return copy;
        }            
    }

    /**
     * Overrides the <code>java.lang.Object</code>'s equals() API to
     * determine if the parameter <code>object</code> is equal to this object.
     * 
     * @param object
     *            The <code>java.lang.Object</code> to be compared to this
     *            object.
     * @return true if this object is the same as the parameter
     *         <code>object</code>, false otherwise.
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object object) {

        synchronized (this) {
            
            //Check if the parameter object is the same object reference as this object (e.g. equal):
            if (this == object){
                return true;
            }
            else {

                //Check if the parameter object is null and is the a different type as this object(e.g. not equal):
                if ((object != null) && (getClass() == object.getClass())) {

                    //Compare the value(s) of all object properties:
                    Object thisObjectsProperty = getSituationQualifier();
                    Object parameterObjectsProperty = ((StopSituationImpl) (object)).getSituationQualifier();

                    if (((thisObjectsProperty != null) && (thisObjectsProperty.equals(parameterObjectsProperty))) || ((thisObjectsProperty == null) && (parameterObjectsProperty == null))) {

                        thisObjectsProperty = getSuccessDisposition();
                        parameterObjectsProperty = ((StopSituationImpl) (object)).getSuccessDisposition();

                        if (((thisObjectsProperty != null) && (thisObjectsProperty.equals(parameterObjectsProperty))) || ((thisObjectsProperty == null) && (parameterObjectsProperty == null))){
                            return true;
                        }
                    }
                }
            }

            return false;
        }
    }

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * All components are initialized to either zero or null.
     * 
     * @since 1.0
     */
    public void init() {

        super.init();

        setSituationQualifier(null);
        setSuccessDisposition(null);
    }
}