package org.eclipse.tptp.logging.events.cbe.util;

import org.eclipse.tptp.logging.events.cbe.AssociationEngine;
import org.eclipse.tptp.logging.events.cbe.CommonBaseEvent;
import org.eclipse.tptp.logging.events.cbe.internal.util.EventHandler;
import org.eclipse.tptp.logging.events.cbe.internal.util.EventListenerImpl;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SAXEventHandler.java,v 1.3 2008/02/28 02:33:15 jkubasta Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Event handler used with a <a href="http://www.saxproject.org/">Simple API 
 * for XML (SAX)</a> parser for de-serializing Common Base Event XML documents.
 * <p>
 * 
 * 
 * @author     Paul E. Slauenwhite
 * @version    February 9, 2006
 * @since      1.0.1
 * @see        org.xml.sax.helpers.DefaultHandler
 * @see        org.eclipse.tptp.logging.events.cbe.util.EventFormatter
 * @deprecated As of TPTP V4.2.0, replaced by the <b>internal</b> 
 *             <code>org.eclipse.tptp.logging.events.cbe.internal.util.EventHandler</code> 
 *             class accessible through the {@link org.eclipse.tptp.logging.events.cbe.util.EventFormatter} 
 *             class.
 */
public final class SAXEventHandler extends EventHandler {

	/**
	 * The {@link org.eclipse.tptp.logging.events.cbe.internal.util.EventListenerImpl} for this event handler.
	 */
	protected EventListenerImpl eventListener = null;
	
    /**
     * No argument constructor.
     * <p>
     */
    public SAXEventHandler() {
    	
    	super();    	

        eventListener = new EventListenerImpl();
   
        addEventListener(eventListener);
    }
    
    /**
     * Initializes the event handler to a newly constructed state.
     * <p>
     */
    public void init() {

        super.init();

        eventListener.init();
        
        //Re-add the {@link org.eclipse.tptp.logging.events.cbe.internal.util.EventListenerImpl} to 
        //this event handler since the super.init() method removes the original instance:
        addEventListener(eventListener);
    }
    
    /**
     * Returns the list of one or more {@link org.eclipse.tptp.logging.events.cbe.CommonBaseEvent}s
     * created from de-serializing a Common Base Event XML document containing one or more Association 
     * Engine XML fragments.
     * <p>
     * 
     * @return Array of {@link org.eclipse.tptp.logging.events.cbe.CommonBaseEvent}s, otherwise <code>null</code>.
     */
    public CommonBaseEvent[] getCommonBaseEvents() {
    	return (eventListener.getCommonBaseEvents());
    }

    /**
     * Returns the list of one or more {@link org.eclipse.tptp.logging.events.cbe.AssociationEngine}s
     * created from de-serializing Common Base Event XML document containing one or more Association 
     * Engine XML fragments.
     * <p>
     * 
     * @return Array of {@link org.eclipse.tptp.logging.events.cbe.AssociationEngine}s, otherwise <code>null</code>.
     */
    public AssociationEngine[] getAssociationEngines() {
    	return (eventListener.getAssociationEngines());
    }
    
    /**
     * @see org.xml.sax.ContentHandler#setDocumentLocator(org.xml.sax.Locator)
     */
    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
    }

    /**
     * @see org.xml.sax.ContentHandler#characters(char[], int, int)
     */
    public void characters(char characters[], int start, int length) throws SAXException {
        super.characters(characters, start, length);
    }

    /**
     * @see org.xml.sax.ContentHandler#startPrefixMapping(java.lang.String,
     *      java.lang.String)
     */
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        super.startPrefixMapping(prefix, uri);
    }

    /**
     * @see org.xml.sax.ContentHandler#startElement(java.lang.String,
     *      java.lang.String, java.lang.String, org.xml.sax.Attributes)
     */
    public void startElement(String uri, String localName, String qalifiedName, Attributes attributes) throws SAXException {
    	super.startElement(uri, localName, qalifiedName, attributes);
    }

    /**
     * @see org.xml.sax.ContentHandler#endElement(java.lang.String,
     *      java.lang.String, java.lang.String)
     */
    public void endElement(String uri, String localName, String qalifiedName) throws SAXException {
    	super.endElement(uri, localName, qalifiedName);
    }

    /**
     * @see org.eclipse.tptp.logging.events.cbe.internal.util.EventHandler#warning(org.xml.sax.SAXParseException)
     */
    public void warning(SAXParseException saxParseException) throws SAXException {
       super.warning(saxParseException);
    }

    /**
     * @see org.eclipse.tptp.logging.events.cbe.internal.util.EventHandler#error(org.xml.sax.SAXParseException)
     */
    public void error(SAXParseException saxParseException) throws SAXException {
        super.error(saxParseException);
    }

    /**
     * @see org.eclipse.tptp.logging.events.cbe.internal.util.EventHandler#fatalError(org.xml.sax.SAXParseException)
     */
    public void fatalError(SAXParseException saxParseException) throws SAXException {
        super.fatalError(saxParseException);
    }
}
