package org.eclipse.hyades.internal.logging.core;

import java.net.InetAddress;
import java.net.UnknownHostException;

/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Constants.java,v 1.2 2006/09/28 17:39:08 cjin Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/** 
 * Constants class.
 * <p>
 * 
 * @author    Paul e. Slauenwhite
 * @version   April 14, 2005
 * @since     April 15, 2004
 */
public final class Constants { 

    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
     
    public static final String INDENT = "  ";
    
    /**
     * IP address (IPv4) of the local host, otherwise "127.0.0.1". 
     */
    public static String LOCAL_HOST_IP_ADDRESS = null;

    /**
     * Host name of the local host, otherwise "localhost". 
     */
    public static String LOCAL_HOST_NAME = null;

    static {
    
        try {
            LOCAL_HOST_IP_ADDRESS = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException u) {
            LOCAL_HOST_IP_ADDRESS = "127.0.0.1";
        }
        
        try {
            LOCAL_HOST_NAME = InetAddress.getByName(LOCAL_HOST_IP_ADDRESS).getHostName();
        } 
        catch (UnknownHostException u) {
            LOCAL_HOST_NAME = "localhost";
        }    
    }
}