package org.eclipse.hyades.logging.core;

/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IInternalizableFromXml.java,v 1.2 2006/09/28 17:39:01 cjin Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/** 
 * Interface for de-serializing XML fragments to the content of implementing <code>java.lang.Object</code>s.
 *  
 * 
 * @author		Richard Duggan
 * @author		Paul Slauenwhite
 * @version	March 7, 2003
 */
public interface IInternalizableFromXml {

    /**
     *	De-serializes an XML fragment to the content of the implementing <code>java.lang.Object</code>.
     *
     *	@param value The XML fragment to be de-serialized.
     */
    public void internalizeCanonicalXmlString(String value);

    /**
     *	De-serializes an XML document to the content of the implementing <code>java.lang.Object</code>.
     *
     *	@param value The XML document to be de-serialized.
     */
    public void internalizeCanonicalXmlDocString(String value);
}
