/**********************************************************************
 * Copyright (c) 2006, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: LoggingCBEPlugin.java,v 1.3 2008/01/24 02:29:32 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.logging.events;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle
 */
public class LoggingCBEPlugin extends Plugin {

	// The plug-in ID
	public static final String PLUGIN_ID = "org.eclipse.tptp.platform.logging.cbe";

	// The shared instance
	protected static LoggingCBEPlugin plugin;
	
	//Resource bundle:
	protected ResourceBundle resourceBundle = null;
	
	/**
	 * The constructor
	 */
	public LoggingCBEPlugin() {
		plugin = this;
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.core.runtime.Plugins#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.core.runtime.Plugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static LoggingCBEPlugin getDefault() {
		return plugin;
	}

	public ResourceBundle getResourceBundle() {
	    
	    if (resourceBundle == null) {

            try {
                resourceBundle = Platform.getResourceBundle(getBundle());
            } 
            catch (MissingResourceException m) {
                //Ignore since API will return null.
            }
        }

        return resourceBundle;
	}
}
