/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: InsufficientBufferLengthException.java,v 1.3 2005/06/01 12:02:03 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.collection.correlation.exceptions;

/**
 * This exception will be thrown if a given buffer is not sufficiently long for the data to be written.
 * 
 * @author Qiyan Li
 */
public class InsufficientBufferLengthException extends Exception {
	
    /**
     * Stream-Unique IDentifier (SUID) of this class.
     * <p>
     * NOTE:  This value MUST not be modified unless an incompatible 
     *        change is introduced.  
     * <p>
     * See the 'Java Object Serialization Specification' for more details.
     * <p>
     * Compatible changes include:
     * <ul>
     * <li>Adding, modifying access or modifying <code>static</code>/<code>transient</code> to non-<code>static</code>/non-<code>transient</code> of fields.</li>
     * <li>Adding or removing classes.</li>
     * <li>Adding or removing <code>writeObject</code>/<code>readObject</code> methods.</li>
     * <li>Adding <code>java.io.Serializable</code> inheritance.</li>
     * </ul>
     * <p>
     * Incompatible changes include:
     * <ul>
     * <li>Deleting, modifying non-<code>static</code>/non-<code>transient</code> to <code>static</code>/<code>transient</code> or modifying the declared type of fields.</li>
     * <li>Modifying the hierarchy or interchanging/removing <code>java.io.Serializable</code>/<code>java.io.Externalizable</code> inheritance of the class.</li>
     * <li>Modifying <code>writeObject</code>/<code>readObject</code> methods.</li>
     * <li>Adding <code>writeReplace</code>/<code>readResolve</code> methods.</li>
     * </ul>
     */
    private static final long serialVersionUID = -3899566263977670812L;
    
    protected int requiredLength; // the length which will prevent the same exception from occurring

    /**
     * Creates a new exception with the required length set.
     * 
     * @param requiredLength    the length which will prevent the same exception from occurring
     */
    public InsufficientBufferLengthException(int requiredLength) {
			this.requiredLength = requiredLength;
	}
	
    /**
     * Returns the required length.
     * 
     * @return  the required length.
     */
	public int getRequiredLength() {
		return requiredLength;
	}
}
