/**********************************************************************
Copyright (c) 2005, 2010 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: ConfigUtility.java,v 1.31 2010/01/28 03:35:08 jwest Exp $

Contributors:
 IBM Rational - initial implementation
**********************************************************************/
package org.eclipse.tptp.platform.agentcontroller.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.ibm.icu.util.ULocale;

public class ConfigUtility implements IConfigUtility{
	private static String resourceLocation = "org.eclipse.tptp.platform.agentcontroller.config.SetConfig";
	private static String lineSeparator = System.getProperty("line.separator");
	protected static ResourceBundle resource = null;

	public static String getString(String property) {
		String value;
		value = getString(resourceLocation, property);
		return value;
	}

	public static String getString(String res, String property) {
		try {
			resource = ResourceBundle.getBundle(res);
		}
		catch (MissingResourceException e) {
			Logger.err("Cannot find property: " + property + " in resource: " +  res + e.getMessage());
		}

		if(resource != null) {
			return resource.getString(property);
		}
		else {
			Logger.err("Cannot find resource bundle: " + res);
			return null;
		}
	}

	public static String getString(ClassLoader loader, String res, String property) {
		try {
			resource = ResourceBundle.getBundle(res, ULocale.getDefault().toLocale(), loader);
		}
		catch (MissingResourceException e) {
			Logger.err("Cannot find property: " + property + " in resource: " +  res + e.getMessage());
		}

		if(resource != null) {
			return resource.getString(property);
		}
		else {
			Logger.err("Cannot find resource bundle: " + res);
			return null;
		}
	}

	public static String printElement(Node node) {
		return print(node, 0, false);
	}

	public static String print(Node node) {
		return print(node, 0, true);
	}

	public static String print(Node node, int numTab, boolean deepPrint) {
		StringBuffer strbuf = new StringBuffer();

		// Sub elements
		NodeList elems = node.getChildNodes();

		// TEXT_NODEs were not being used until the new agent controller was being supported.
		if (node.getNodeType() == Node.TEXT_NODE) {
			strbuf.append(tabs(numTab) + node.getNodeValue());
			return strbuf.toString();
		}

		if (elems != null && elems.item(0) != null && elems.item(0).getNodeType() == Node.TEXT_NODE) {
			strbuf.append(tabs(numTab) + "<" + node.getNodeName() + ">" + elems.item(0).getNodeValue() + "</" + node.getNodeName() + ">" + ConfigUtility.lineSeparator);
			return strbuf.toString();
		}

		// Element start
		strbuf.append(tabs(numTab) + "<" + node.getNodeName());

		// Attributes
		NamedNodeMap attrs = node.getAttributes();

		if(attrs != null) {
			for(int i = 0; i < attrs.getLength(); i++) {
				if(attrs.item(i) instanceof Attr) {
					strbuf.append(" ");
					strbuf.append(((Attr)attrs.item(i)).getName());
					strbuf.append("=\"");
					strbuf.append(((Attr)attrs.item(i)).getValue());
					strbuf.append("\"");
				}
			}
		}

		//
		// Close element start if no sub elements
		//
		if(!deepPrint || (elems == null) || (elems.getLength() == 0)) {
			strbuf.append("/>" + ConfigUtility.lineSeparator);
		}
		else {
			strbuf.append(">" + ConfigUtility.lineSeparator);
			for(int i = 0; i < elems.getLength(); i++) {
				strbuf.append(print(elems.item(i), numTab + 1, true));
			}
			strbuf.append(tabs(numTab) + "</" + node.getNodeName() + ">" + ConfigUtility.lineSeparator);
		}

		return strbuf.toString();
	}

	protected static String tabs(int length) {
		StringBuffer strbuf = new StringBuffer();
		for(int i = 0; i < length; i++) {
			strbuf.append("\t");
		}
		return strbuf.toString();
	}

	public static String removeTrailings(String in) {
		String out = null;
		if(in != null) {
			out = in.trim();
			while(out.endsWith(PlatformObject.sr)) {
				out = out.substring(0, out.length()-1);
			}
		}
		return out;
	}

	public static String arrayToString(String[] array) {
		StringBuffer str = null;

		if(array != null) {
			str = new StringBuffer();
			for(int i = 0; i < array.length; i++) {
				str.append(array[i]);
				if(i < array.length - 1) {
					str.append(',');
				}
			}
		}

		if(str == null) {
			return null;
		}
		else {
			return str.toString();
		}
	}

	public static String[] stringToArray(String str) {
		String[] array = null;

		if(str != null) {
			StringTokenizer strtok = new StringTokenizer(str, " ,");
			array = new String[strtok.countTokens()];

			int i = 0;
			while(strtok.hasMoreTokens()) {
				array[i++] = strtok.nextToken();
			}
		}

		return array;
	}

	//
	// Return the user's input
	//
	public static String askUser(String defaultValue) {
		String input;
		BufferedReader bReader = new BufferedReader(new InputStreamReader(System.in));
		try {
			input = bReader.readLine();
		} catch (IOException e) {
			input = defaultValue;
		}
		if (input.equals("")) {
			input = defaultValue;
		}
		return removeTrailings(input);
	}

	public static String getJvmLib(String javaPath) throws IOException {
		String sr = PlatformObject.sr; // path separator
		String jvm = PlatformObject.jvmLib; // JVM library name
		String path;
		File f = null;

		//
		// Check "$javaPath/classic"
		//
		path = new String(javaPath + sr + "classic" + sr + jvm);
		f = new File(path);
		if((f != null) && f.exists()) {
			return f.getCanonicalPath();
		}

		//
		// Check "$javaPath/../jre/bin/classic"
		//
		path = new String(javaPath + sr + ".." + sr + "jre" + sr + "bin" + sr + "classic" + sr + jvm);
		f = new File(path);
		if((f != null) && f.exists()) {
			return f.getCanonicalPath();
		}

		//
		// Check "$javaPath/server"
		// - Sun JDK 1.4.2
		path = new String(javaPath + sr + "server" + sr + jvm);
		f = new File(path);
		if((f != null) && f.exists()) {
			return f.getCanonicalPath();
		}

		//
		// Check "$javaPath/../jre/bin/server"
		// - Sun JDK 1.4.2
		path = new String(javaPath + sr + ".." + sr + "jre" + sr + "bin" + sr + "server" + sr + jvm);
		f = new File(path);
		if((f != null) && f.exists()) {
			return f.getCanonicalPath();
		}

		// Bug 59518
		// Check "$javaPath/client"
		// - Sun JDK 1.4.2
		path = new String(javaPath + sr + "client" + sr + jvm);
		f = new File(path);
		if((f != null) && f.exists()) {
			return f.getCanonicalPath();
		}

		// Bug 59518
		// Check "$javaPath/../jre/bin/client"
		// - Sun JDK 1.4.2
		path = new String(javaPath + sr + ".." + sr + "jre" + sr + "bin" + sr + "client" + sr + jvm);
		f = new File(path);
		if((f != null) && f.exists()) {
			return f.getCanonicalPath();
		}

		// Sun JDK 1.4.2: Check "$javaPath/../lib/i386/server"
		path = new String(javaPath + sr + ".." + sr + "lib" + sr + "i386" + sr + "server" + sr + jvm);
		f = new File(path);
		if((f != null) && f.exists()) {
			return f.getCanonicalPath();
		}

		// Sun JDK 1.4.2: Check "$javaPath/../jre/lib/i386/server"
		path = new String(javaPath + sr + ".." + sr + "jre" + sr + "lib" + sr + "i386" + sr + "server" + sr + jvm);
		f = new File(path);
		if((f != null) && f.exists()) {
			return f.getCanonicalPath();
		}

		// Sun JDK 1.4.2: Check "$javaPath/../lib/i386/client"
		path = new String(javaPath + sr + ".." + sr + "lib" + sr + "i386" + sr + "client" + sr + jvm);
		f = new File(path);
		if((f != null) && f.exists()) {
			return f.getCanonicalPath();
		}

		// Sun JDK 1.4.2: Check "$javaPath/../jre/lib/i386/client"
		path = new String(javaPath + sr + ".." + sr + "jre" + sr + "lib" + sr + "i386" + sr + "client" + sr + jvm);
		f = new File(path);
		if((f != null) && f.exists()) {
			return f.getCanonicalPath();
		}


		// AIX 64-bit Java SR6: $javaPath/lib/ppc64/classic/libjvm.so
		path = new String(javaPath + sr + "lib" + sr + "ppc64" + sr + "classic" + sr + "libjvm.so");
		f = new File(path);
		if((f != null) && f.exists()) {
			return f.getCanonicalPath();
		}
				
		// AIX 64-bit Java SR6: $javaPath/../lib/ppc64/classic/libjvm.so
		path = new String(javaPath + sr + ".." + sr + "lib" + sr + "ppc64" + sr + "classic" + sr + "libjvm.so");
		f = new File(path);
		if((f != null) && f.exists()) {
			return f.getCanonicalPath();
		}

		// AIX 64-bit Java SR6: $javaPath/../jre/lib/ppc64/classic/libjvm.so
		path = new String(javaPath + sr + ".." + sr + "jre" + sr +"lib" + sr + "ppc64" + sr + "classic" + sr + "libjvm.so");
		f = new File(path);
		if((f != null) && f.exists()) {
			return f.getCanonicalPath();
		}

		// AIX 64-bit Java SR6: $javaPath/classic/libjvm.so
		path = new String(javaPath + sr + "classic" + sr + "libjvm.so");
		f = new File(path);
		if((f != null) && f.exists()) {
			return f.getCanonicalPath();
		}

		// AIX 64-bit Java SR6: $javaPath/bin/classic/libjvm.so
		path = new String(javaPath + sr + "bin" + sr + "classic" + sr + "libjvm.so");
		f = new File(path);
		if((f != null) && f.exists()) {
			return f.getCanonicalPath();
		}
		// Bug 178501: BEA JRockit JRE (Windows)
		// Bug 178501: BEA JRockit JDK (Windows) - using "jre/bin/java.exe"
		path = new String(javaPath + sr + "jrockit" + sr + jvm);
		f = new File(path);
		if((f != null) && f.exists()) {
			return f.getCanonicalPath();
		}

		// Bug 178501: BEA JRockit JRE (Linux)
		// Bug 178501: BEA JRockit JDK (Linux) - using "jre/bin/java"
		path = new String(javaPath + sr + ".." + sr + "lib" + sr + "i386" + sr + "jrockit" + sr + jvm);
		f = new File(path);
		if((f != null) && f.exists()) {
			return f.getCanonicalPath();
		}
		
		// Bug 218327: BEA JRockit JRE (Linux IPF)
		path = new String(javaPath + sr + ".." + sr + "lib" + sr + "ia64" + sr + "jrockit" + sr + jvm);
		f = new File(path);
		if((f != null) && f.exists()) {
			return f.getCanonicalPath();
		}

		// Bug 178501: BEA JRockit JDK (Windows) - using "bin/java.exe" 
		path = new String(javaPath + sr + ".." + sr + "jre" + sr + "bin" + sr + "jrockit" + sr + jvm);
		f = new File(path);
		if((f != null) && f.exists()) {
			return f.getCanonicalPath();
		}

		// Bug 178501: BEA JRockit JDK (Linux) - using "bin/java"
		path = new String(javaPath + sr + ".." + sr + "jre" + sr + "lib" + sr + "i386" + sr + "jrockit" + sr + jvm);
		f = new File(path);
		if((f != null) && f.exists()) {
			return f.getCanonicalPath();
		}

		// Bug 183195: Sun 64-bit Linux JRE/JDK (jre/lib/amd64/server/libjvm.so) - using "jre/bin/java"
		path = new String(javaPath + sr + ".." + sr + "lib" + sr + "amd64" + sr + "server" + sr + jvm);
		f = new File(path);
		if((f != null) && f.exists()) {
			return f.getCanonicalPath();
		}

		// Bug 183195: Sun 64-bit Linux JDK (jre/lib/amd64/server/libjvm.so) - using "bin/java"
		path = new String(javaPath + sr + ".." + sr + "jre" + sr + "lib" + sr + "amd64" + sr + "server" + sr + jvm);
		f = new File(path);
		if((f != null) && f.exists()) {
			return f.getCanonicalPath();
		}

		// Bug 183195: Sun 64-bit Linux JRE/JDK (jre/lib/ia64/server/libjvm.so) - using "jre/bin/java"
		path = new String(javaPath + sr + ".." + sr + "lib" + sr + "ia64" + sr + "server" + sr + jvm);
		f = new File(path);
		if((f != null) && f.exists()) {
			return f.getCanonicalPath();
		}


		// Bug 183195: Sun 64-bit Linux JDK (jre/lib/ia64/server/libjvm.so) - using "bin/java"
		path = new String(javaPath + sr + ".." + sr + "jre" + sr + "lib" + sr + "ia64" + sr + "server" + sr + jvm);
		f = new File(path);
		if((f != null) && f.exists()) {
			return f.getCanonicalPath();
		}

		// Bug 183195: IBM J9VM Windows JRE/JDK (jre\bin\j9vm\jvm.dll) - using "jre\bin\java.exe"
		// Bug 183195: IBM J9VM Linux JRE/JDK (jre/bin/j9vm/libjvm.so) - using "jre/bin/java"
		path = new String(javaPath + sr + "j9vm" + sr + jvm);
		f = new File(path);
		if((f != null) && f.exists()) {
			return f.getCanonicalPath();
		}

		// Bug 183195: IBM J9VM Windows JDK (jre\bin\j9vm\jvm.dll) - using "bin\java.exe"
		// Bug 183195: IBM J9VM Linux JDK (jre/bin/j9vm/libjvm.so) - using "bin/java"
		path = new String(javaPath + sr + ".." + sr + "jre" + sr + "bin" + sr + "j9vm" + sr + jvm);
		f = new File(path);
		if((f != null) && f.exists()) {
			return f.getCanonicalPath();
		}

		//
		// Platform specific JDK's
		//
		if(PlatformObject.name.equals("HP-UX")) {
			// HP-UX: Check "$javaPath/../lib/PA_RISC/classic"
			path = new String(javaPath + sr + ".." + sr + "lib" + sr + "PA_RISC" + sr + "classic" + sr + jvm);
			f = new File(path);
			if((f != null) && f.exists()) {
				return f.getCanonicalPath();
			}

			// HP-UX: Check "$javaPath/../jre/lib/PA_RISC/classic"
			path = new String(javaPath + sr + ".." + sr + "jre" + sr + "lib" + sr + "PA_RISC" + sr + "classic" + sr + jvm);
			f = new File(path);
			if((f != null) && f.exists()) {
				return f.getCanonicalPath();
			}

			// HP-UX: Check "$javaPath/../lib/PA_RISC/server"
			path = new String(javaPath + sr + ".." + sr + "lib" + sr + "PA_RISC" + sr + "server" + sr + jvm);
			f = new File(path);
			if((f != null) && f.exists()) {
				return f.getCanonicalPath();
			}

			// HP-UX: Check "$javaPath/../jre/lib/PA_RISC/server"
			path = new String(javaPath + sr + ".." + sr + "jre" + sr + "lib" + sr + "PA_RISC" + sr + "server" + sr + jvm);
			f = new File(path);
			if((f != null) && f.exists()) {
				return f.getCanonicalPath();
			}

			// HP-UX: Check "$javaPath/../lib/PA_RISC2.0/server"
			path = new String(javaPath + sr + ".." + sr + "lib" + sr + "PA_RISC2.0" + sr + "server" + sr + jvm);
			f = new File(path);
			if((f != null) && f.exists()) {
				return f.getCanonicalPath();
			}

			// HP-UX: Check "$javaPath/../jre/lib/PA_RISC2.0/server"
			path = new String(javaPath + sr + ".." + sr + "jre" + sr + "lib" + sr + "PA_RISC2.0" + sr + "server" + sr + jvm);
			f = new File(path);
			if((f != null) && f.exists()) {
				return f.getCanonicalPath();
			}
		}
		else if(PlatformObject.name.equals("SunOS")) {
			//91207: searching 1st: ~/client/libjvm.so, 2nd: ~/server/libjvm.so 3rd: ~/libjvm.so
			
			// Sun JDK 1.4.2: Check "$javaPath/../lib/sparc/client"
			path = new String(javaPath + sr + ".." + sr + "lib" + sr + "sparc" + sr + "client" + sr + jvm);
			f = new File(path);
			if((f != null) && f.exists()) {
				return f.getCanonicalPath();
			}

			// Sun JDK 1.4.2: Check "$javaPath/../jre/lib/sparc/client"
			path = new String(javaPath + sr + ".." + sr + "jre" + sr + "lib" + sr + "sparc" + sr + "client" + sr + jvm);
			f = new File(path);
			if((f != null) && f.exists()) {
				return f.getCanonicalPath();
			}			
			
			// Sun JDK 1.4.2: Check "$javaPath/../lib/sparc/server"
			path = new String(javaPath + sr + ".." + sr + "lib" + sr + "sparc" + sr + "server" + sr + jvm);
			f = new File(path);
			if((f != null) && f.exists()) {
				return f.getCanonicalPath();
			}

			// Sun JDK 1.4.2: Check "$javaPath/../jre/lib/sparc/server"
			path = new String(javaPath + sr + ".." + sr + "jre" + sr + "lib" + sr + "sparc" + sr + "server" + sr + jvm);
			f = new File(path);
			if((f != null) && f.exists()) {
				return f.getCanonicalPath();
			}			
			
			// ------------
			
			// SunSPARC: Check "$javaPath/../lib/sparc"
			path = new String(javaPath + sr + ".." + sr + "lib" + sr + "sparc" + sr + jvm);
			f = new File(path);
			if((f != null) && f.exists()) {
				return f.getCanonicalPath();
			}

			// SunSPARC: Check "$javaPath/../jre/lib/sparc"
			path = new String(javaPath + sr + ".." + sr + "jre" + sr + "lib" + sr + "sparc" + sr + jvm);
			f = new File(path);
			if((f != null) && f.exists()) {
				return f.getCanonicalPath();
			}
			
			// SunSPARC - 64-bit JDK: Check "$javaPath/../../../jre/lib/sparcv9/server/libjvm.so"
			path = new String(javaPath + sr + ".." + sr + ".." + sr + ".." + sr + "jre" + sr + "lib" + sr + "sparcv9" + sr + "server" + sr + jvm);
			f = new File(path);
			if((f != null) && f.exists()) {
				return f.getCanonicalPath();
			}
			
			// SunSPARC - 64-bit JDK: Check "$javaPath/../../jre/lib/sparcv9/server/libjvm.so"
			path = new String(javaPath + sr + ".." + sr + ".." + sr + "jre" + sr + "lib" + sr + "sparcv9" + sr + "server" + sr + jvm);
			f = new File(path);
			if((f != null) && f.exists()) {
				return f.getCanonicalPath();
			}
			
			// ----------
						
			// Solaris x86 (AMD) - 64-bit JDK: Check "$javaPath/../../lib/amd64/server/libjvm.so"
			path = new String(javaPath + sr + ".." + sr + ".." + sr + "lib" + sr + "amd64" + sr + "server" + sr + jvm);
			f = new File(path);
			
			if((f != null) && f.exists()) {
				return f.getCanonicalPath();
			}
			
			// Solaris x86 (AMD) - 64-bit JDK: Check "$javaPath/../../jre/lib/amd64/server/libjvm.so"
			path = new String(javaPath + sr + ".." + sr + ".." + sr + "jre" + sr + "lib" + sr + "amd64" + sr + "server" + sr + jvm);
			f = new File(path);
			
			if((f != null) && f.exists()) {
				return f.getCanonicalPath();
			}
		}

		return null;
	}

	public static String getKeytool(String javaPath) throws IOException {
		String sr = PlatformObject.sr; // path separator
		String keytool = PlatformObject.keytool; // keytool program name
		String path;
		File f = null;

		//
		// Check "$javaPath" in case keytool is in the same dir as java
		//
		path = new String(javaPath + sr + keytool);
		f = new File(path);
		if((f != null) && f.exists()) {
			return f.getCanonicalPath();
		}

		//
		// Check "$javaPath/../jre/bin" in case the java path is $JAVA_HOME/bin
		//
		path = new String(javaPath + sr + ".." + sr + "jre" + sr + "bin" + sr + keytool);
		f = new File(path);
		if((f != null) && f.exists()) {
			return f.getCanonicalPath();
		}

		//
		// Check "$javaPath/../../bin" in case the java path is $JAVA_HOME/jre/bin
		//
		path = new String(javaPath + sr + ".." + sr + ".." + sr + "bin" + sr + keytool);
		f = new File(path);
		if((f != null) && f.exists()) {
			return f.getCanonicalPath();
		}

		return keytool; // return without the FQ path
	}

	public String resolveAbsolutePath(String path, String pluginAlias) {
		StringBuffer classpathBuffer = new StringBuffer();
		String classpath = null;

		if(path != null) {
			File pluginDir = new File(path);
			if(pluginDir.exists() && pluginDir.isDirectory()) {
				File[] plugins;
				
				//@author Paul E. Slauenwhite
				//The SWT file does not follow the same naming convention used by all other 
				//Agent Controller plug-ins.  For example, org.eclipse name space).  A custom 
				//conditional is required to resolve the name of the SWT JAR file.
				//TODO: Remove custom conditional under defect https://bugs.eclipse.org/bugs/show_bug.cgi?id=143725.
				if(pluginAlias.equals("org.eclipse.swt")) {
					plugins = pluginDir.listFiles(new FileFilterImpl("swt.jar")); // special case for SWT
					
					/* NM - bugzilla 173330: For IAC, the SWT plugins do start with org.eclipse.swt */
					if (plugins.length == 0)
						plugins = findLatestVersionPlugin(pluginDir, pluginAlias);
				}
				else {					
					//bug 233812, removed older version of the plugin from the  File[] plugins
					plugins = findLatestVersionPlugin(pluginDir, pluginAlias);
								
				}

				for(int i = 0; i < plugins.length; i++) {
					if(plugins[i].isDirectory()) {
						File[] pluginJars;
						/*
						 * Add the jar files
						 */
						pluginJars = plugins[i].listFiles(new FileFilterImpl(".*\\x2Ejar$"));
						for(int j = 0; j < pluginJars.length; j++) {
							classpathBuffer.append(pluginJars[j].getAbsolutePath() + File.pathSeparator);
						}

						/*
						 * Add the zip files
						 */
						pluginJars = plugins[i].listFiles(new FileFilterImpl(".*\\x2Ezip$"));
						for(int j = 0; j < pluginJars.length; j++) {
							classpathBuffer.append(pluginJars[j].getAbsolutePath() + File.pathSeparator);
						}
						
						//@author Paul E. Slauenwhite
						//The Apache Commons JAR file is in the lib directory of the 
						//Apache Commons plug-in (org.apache.commons_logging).  A custom 
						//conditional is required to resolve the location of the Apache 
						//Commons JAR file in the lib directory of the Apache Commons plug-in.
						//TODO: Remove custom conditional under defect https://bugs.eclipse.org/bugs/show_bug.cgi?id=143725.
						if(pluginAlias.equals("org.apache.commons_logging")) {

							File libDirectory = new File(plugins[i].getAbsolutePath(),"lib");
							
							if(libDirectory.isDirectory()){
	
								//Add the jar files in the lib directory of the Apache Commons plug-in (org.apache.commons_logging):
								pluginJars = libDirectory.listFiles(new FileFilterImpl(".*\\x2Ejar$"));
							
								for(int j = 0; j < pluginJars.length; j++) {
									classpathBuffer.append(pluginJars[j].getAbsolutePath() + File.pathSeparator);
								}
							}
						}
					}
					else {
						classpathBuffer.append(plugins[i].getAbsolutePath() + File.pathSeparator);
					}
				}
			}
		}

		classpath = classpathBuffer.toString();
		if(classpath.length() > 1) {
			return classpath.substring(0, classpath.length() - 1); // removing the last ";"
		}
		else {
			return new String("null");
		}
	}
	
	/**
	 * 
	 * @param pluginDir  A directory which will be searched for the plugin
	 * @param pluginName   name of plugin that will be used for searching.
	 * @return
	 * 
	 */
	private File[] findLatestVersionPlugin(File pluginDir, String pluginName) {
		
		File latestPlugin;
		
		//first, grab all versions of this plugin
		File[] pluginsCandidates = pluginDir.listFiles(new FileFilterImpl("^" + pluginName + "_.*"));
		
		if(pluginsCandidates.length == 0){
			return (new File[0]);
		}else if(pluginsCandidates.length == 1){
			latestPlugin = pluginsCandidates[0];
		}else{
			latestPlugin  = pluginsCandidates[0];
			for(int i = 0; i < pluginsCandidates.length; i++){				
				if(latestPlugin.getName().compareTo(pluginsCandidates[i].getName()) < 0){
					latestPlugin = pluginsCandidates[i];
				}
			}
		}
		
		//Now chop the string to find the version.  All plugins are named as <plugin_name>_<version>.V<build_date> or 
		//plugin_name>_<version>.I<build_date>.
		//Some of the plugins found are directories and some are jar files.
		String latestVersion = latestPlugin.getName().substring(pluginName.length());
		int lastIndex = latestVersion.indexOf("v");
		if(lastIndex == -1){
			lastIndex = latestVersion.indexOf("I");
			if(lastIndex == -1)
				lastIndex = latestVersion.length()+1;
		}
		latestVersion = latestVersion.substring(1, lastIndex-1);
		
		if("org.eclipse.swt".equalsIgnoreCase(pluginName))
			//for swt, need to return multiple jar file.
			return pluginDir.listFiles(new FileFilterImpl("^" + pluginName + ".*"+latestVersion+".*"));
		else		
			return pluginDir.listFiles(new FileFilterImpl("^" + pluginName + "_"+latestVersion+".*"));	
		
	}	        	
	
	/**
	 * This should only be called by stand-alone AC or when user uses IAC in stand-alone mode.
	 */
	public File getACConfigDirectory(String home, boolean isInvokedByWorkbench, boolean isIACConfig){
		
		return new File(home + File.separator + "config");
		
	}
	
	/**
	 *  this function shouldn't be called for standalone AC or IAC invoked from command line. 
	 *  In those scenarios, <AC>/plugins or plugins under <Eclipse>/dropins/eclipse/plugins should be used.
	 */
	public File getPluginPropertyDirectory(boolean isInvokedByWorkbench){
		
		return null;
	}
	
	

}
