/**********************************************************************
 Copyright (c) 2007, 2008 IBM Corporation and others.
 All rights reserved.  This program and the accompanying materials
 are made available under the terms of the Eclipse Public License v1.0
 which accompanies this distribution, and is available at
 http://www.eclipse.org/legal/epl-v10.html
 $Id: Constants.java,v 1.5 2008/10/10 21:54:48 jcayne Exp $
 
 Contributors:
  IBM Rational - initial implementation
 **********************************************************************/
package org.eclipse.tptp.platform.agentcontroller.config;

/**
 * Defines a set of common constants 
 * @author Navid Mehregani
 *
 */
public class Constants {
	
	/* Key for the location of the plugins folder */
	public static final String PLUGINS_HOME = "PLUGINS_HOME";
	
	/* Key for the location of AC */
	public static final String RASERVER_HOME = "RASERVER_HOME";
	
	/* Key for the location of JVM */
	public static final String JAVA_PATH = "JAVA_PATH";
	
	/* Key for the allowed field */
	public static final String ALLOWS = "ALLOW";
	
	
	public static final String ALLOW_HOST_TYPE = "TYPE";
	
	/* Key that indicates the custom hosts that are allowed access to AC */
	public static final String HOSTS = "HOSTS"; 
	
	/* Key that indicates whether or not security should be enabled */
	public static final String SECURITY = "SECURITY";
	
	/* Key that indicates the users that should be given access to AC */
	public static final String USERS = "USERS";
	public static final String USERTYPE = "USERTYPE";
	public static final String USERLIST = "USERLIST";
	
	/* These are the valid values for the ALLOW field of AC's configuration file */
	public static final String ALLOW_ALL = "ALL";
	public static final String ALLOW_LOCAL = "LOCAL";
	public static final String ALLOW_CUSTOM = "CUSTOM";
	
	/* Valid value used for the USER field of AC's configuration file */
	public static final String USER_ALL = "ANY";
	public static final String USER_CUSTOM = "CUSTOM";
	
	/* Valid values for the SECURITY field */
	public static final String SECURITY_ON = "TRUE";
	public static final String SECURITY_OFF = "FALSE";
	
	/* Silent flag */
	public static final String SILENT_FLAG = "-silent";
	
	public static final String PLUGIN_PROPERTY_DIR = "PLUGIN_PROPERTY_DIR";
}
