/**********************************************************************
Copyright (c) 2005, 2006 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: FileFilterImpl.java,v 1.1 2006/02/08 19:28:38 samwai Exp $

Contributors:
 IBM Rational - initial implementation
**********************************************************************/

package org.eclipse.tptp.platform.agentcontroller.config;

import java.io.File;
import java.io.FileFilter;
import java.util.regex.Pattern;

public class FileFilterImpl implements FileFilter {
	private String _regExp;

	public FileFilterImpl(String regExp) {
		_regExp = regExp;
	}

	public boolean accept(File f) {
		if(Pattern.matches(_regExp, f.getName())) {
			return true;
		}
		else {
			return false;
		}
	}
}
