/**********************************************************************
Copyright (c) 2005 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: HashUtility.java,v 1.2 2005/02/25 22:17:34 hleung Exp $

Contributors:
 IBM Rational - initial implementation
**********************************************************************/
package org.eclipse.tptp.platform.agentcontroller.config;

import java.util.Hashtable;

public class HashUtility {
	//
	// Check if a parameter exist
	//
	public static boolean exist(Hashtable hash, String tag) {
		return hash.containsKey(tag);
	}

	//
	// Return the value specified by the parameter
	//
	public static String getValue(Hashtable hash, String tag) {
		if (hash.containsKey(tag)) {
			return (String) hash.get(tag);
		} else {
			return null;
		}
	}

	//
	// Set the value specified by the parameter
	//
	public static void setValue(Hashtable hash, String tag, String value) {
		hash.put(tag, value);
	}

	public static void removeKey(Hashtable hash, String tag) {
		hash.remove(tag);
	}

}
