/**********************************************************************
Copyright (c) 2005 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: Logger.java,v 1.2 2005/02/25 22:17:34 hleung Exp $

Contributors:
 IBM Rational - initial implementation
**********************************************************************/
package org.eclipse.tptp.platform.agentcontroller.config;

import java.io.FileOutputStream;
import java.io.PrintStream;

public class Logger {
	private static boolean debug = false;
	protected static PrintStream out = System.out;
	protected static PrintStream err = System.err;

	static {
		if(System.getProperty("debug") != null) {
			debug = true;
		}
	}

	public static void out(String str) {
		if(debug) {
			out.println("OUT Log: " + str);
		}
	}

	public static void err(String str) {
		if(debug) {
			err.println("ERR Log: " + str);
		}
	}

	public static void setDebug(boolean b) {
		debug = b;
	}

	public static void setLogFile(String string) {
		try {
			err = out = new PrintStream(new FileOutputStream(string), true);
		} catch (Exception e) {
			// Set it back to System.out and System.err
			out = System.out;
			err = System.err;
		}
	}
}
