/**********************************************************************
Copyright (c) 2005, 2010 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: PlatformObject.java,v 1.7 2010/04/22 17:31:23 jcayne Exp $

Contributors:
 IBM Rational - initial implementation
**********************************************************************/
package org.eclipse.tptp.platform.agentcontroller.config;

import java.io.File;

public class PlatformObject {
	public final static String name = System.getProperty("os.name", "Unknown");
	public final static String sr = File.separator;
	public final static String pr = File.pathSeparator;
	public final static String encoding = getEncoding();
	public final static String libEnv = getLibEnv();
	public final static String libPath = getLibPath();
	public final static String exeExt = getExeExt();
	public final static String dataSize = getDataSize();
	public final static String tempDir = ConfigUtility.removeTrailings(System.getProperty("java.io.tmpdir", "%RASERVER_HOME%"));
	// Bug 308169
	public final static String javaExecutable = getJavaExecutable();
	public final static String jvmLib = getJvmLib();
	public final static String keytool = getKeytool();
	public final static String quote = getQuote();

	private static String getEncoding() {
		if(name.equals("z/OS") || name.equals("OS/390")) {
//			return "ibm-1047-s390"; // Bug 99057
//			return "IBM037";
			return System.getProperty("file.encoding");
		}
		else {
			return "UTF-8";
		}
	}

	private static String getLibEnv() {
		if(name.equals("AIX") || name.equals("OS/400") || name.equals("z/OS") || name.equals("OS/390")) {
			return "LIBPATH";
		}
		else if(name.equals("HP-UX")) {
			return "SHLIB_PATH";
		}
		else if(name.startsWith("Windows")) {
			return "PATH";
		}
		else {
			return "LD_LIBRARY_PATH";
		}
	}

	private static String getLibPath() {
		if(name.startsWith("Windows")) {
			return "bin";
		}
		else {
			return "lib";
		}
	}

	private static String getExeExt() {
		if(name.startsWith("Windows")) {
			return ".exe";
		}
		else {
			return "";
		}
	}

	// Bug 308169 - Use javaw on Windows, otherwise applications which print multi-byte 
	//  Unicode characters (e.g. Japanese characters) to System.out will see ?s instead
	private static String getJavaExecutable() {
		if(name.startsWith("Windows")) {
			return "javaw";
		}
		else {
			return "java";
		}
	}

	private static String getDataSize() {
		if(name.startsWith("Windows")) {
			return "64M";
		}
		else {
			return "30M";
		}
	}

	private static String getJvmLib() {
		if(name.startsWith("Windows")) {
			return "jvm.dll";
		}
		else if(name.equals("AIX")) {
			return "libjvm.a";
		}
		else if(name.equals("HP-UX")) {
			return "libjvm.sl";
		}
		else {
			return "libjvm.so";
		}
	}

	private static String getKeytool() {
		if(name.startsWith("Windows")) {
			return "keytool.exe";
		}
		else {
			return "keytool";
		}
	}

	private static String getQuote() {
		if(name.startsWith("Windows")) {
			return "\"";
		}
		else {
			return "'";
		}
	}
}
