/**********************************************************************
 Copyright (c) 2005, 2009 IBM Corporation and others.
 All rights reserved.  This program and the accompanying materials
 are made available under the terms of the Eclipse Public License v1.0
 which accompanies this distribution, and is available at
 http://www.eclipse.org/legal/epl-v10.html
 $Id: SetConfigSkeleton.java,v 1.17 2009/01/12 21:35:16 jkubasta Exp $
 
 Contributors:
  IBM Rational - initial implementation
 **********************************************************************/
package org.eclipse.tptp.platform.agentcontroller.config;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.Vector;

public abstract class SetConfigSkeleton {
	public ConfigFile configFile = null; // the actual config file object

	public static String sr = PlatformObject.sr; // separator char for this

	// platform

	public static String pr = PlatformObject.pr;

	public static boolean silent = false; // run the generator silently

	public static boolean overwrite = false; // overwrite existing config

	// file

	public static boolean isNewAC = false; // will be set in askUser after

	public static boolean wantsBC = false; // will be set in askUser after

	// RASERVER_HOME validated

	public static boolean verify = true;
	
	static final String[] NLJAR_PREFIX = {".nl1", ".nl2", ".nl2a"};

	/* Navid Mehregani - bugzilla 173330: Will hold the location of the 'plugins' folder */ 
	private String pluginsHome = null;	
	
	private String pluginPropertyDir = null;
	
	private String pluginName = null;

	protected String fileName = null; // FQ file name

	private ClassLoader loader = null; // class loader for this class

	private String home;

	public abstract void askUser();

	public abstract void generateConfiguration();

	public abstract void printHelp();

	public abstract void printExamples();

	/**
	 * Holds the command line arguments for this set configuration usage
	 */
	protected Hashtable arguments;

	/**
	 * Validate the primary configuration file, outputs findings to standard
	 * out, this is experimental and provisional for now but is much needed to
	 * minimize time taken for debugging issues
	 * 
	 * @param fileName
	 *            the file name of the configuration file
	 */
	public void validate(Boolean showAll) {
		if (new File(this.fileName).exists()) {
			new ConfigFile(this.fileName).validate(showAll);
		} else {
			System.out.println("Configuration file " + this.fileName
					+ " does not yet exist");
		}
		System.out.println();
	}

	
	public void init(Hashtable hash) {
		
		File configDir;
		
		this.arguments = hash;
		home = HashUtility.getValue(hash, "RASERVER_HOME");
		/* NM - bugzilla 173330 */
		pluginsHome = HashUtility.getValue(hash, Constants.PLUGINS_HOME);
		//bug 227779  create pluginconfig.xml for sub-plugins used by AC
		pluginPropertyDir = HashUtility.getValue(hash, Constants.PLUGIN_PROPERTY_DIR);
		if(pluginPropertyDir == null)
			pluginPropertyDir = pluginsHome;
		
		//bug 242559 create new plugin config dir only for IAC invoked from workbench.
		if(!new File(pluginPropertyDir+ sr + pluginName).exists()){	
			String pluginDirName = "";
			if (pluginName.indexOf('_') != -1) {
				pluginDirName = pluginName.substring(0, pluginName.indexOf('_'));
			}else
				pluginDirName = pluginName;
		
			configDir = new File(pluginPropertyDir + sr + pluginDirName + sr + "config");
			configDir.mkdirs();
		}else{
			configDir = new File(pluginsHome + sr + pluginName + sr + "config");
		}
		setFileName(configDir.getAbsolutePath() + sr + "pluginconfig.xml");
		
	}

	public void run(Hashtable hash) {
		run(hash, false, false);
	}

	public void run(Hashtable hash, boolean bSilent, boolean bOverwrite) {
		silent = bSilent;
		overwrite = bOverwrite;

		if (fileName != null) {
			configFile = new ConfigFile(fileName);
			configFile.init(hash);

			askUser();
			generateConfiguration();
		}
	}

	public SetConfigSkeleton() {
		this(null);
	}

	public SetConfigSkeleton(String pluginName) {
		if (pluginName != null) {
			this.pluginName = pluginName;
		}
	}

	public void setLoader(ClassLoader _loader) {
		loader = _loader;
	}

	public ClassLoader getLoader() {
		return loader;
	}

	/**
	 * Return the resource string associated with the class
	 * 
	 * @param tag
	 *            The tag of the string
	 * @return The resolved string
	 */
	public String getString(String tag) {
		String rc = null;

		if (loader == null) {
			rc = ConfigUtility.getString(tag);
		} else {
			try {
				Logger.out("Looking for resource under " + pluginName
						+ " for SetConfig");
				rc = ConfigUtility.getString(loader, pluginName.substring(0,
						pluginName.lastIndexOf('_'))
						+ ".SetConfig", tag);
			} catch (MissingResourceException e) {
				rc = ConfigUtility.getString(tag);
			}
		}
		return rc;
	}

	/**
	 * Trimming off the leading and trailing white spaces
	 * 
	 * @param str
	 *            String to be trimmed
	 * @return The resulting string
	 */
	public String trim(String str) {
		if ((str == null) || (str.length() == 0)) {
			return null;
		} else {
			int start = 0; // position of the first non-quote and non-space
			// char
			int end = str.length() - 1; // position of the last non-quote and
			// non-space char

			while ((start < end)
					&& ((str.charAt(start) == ' ')
							|| (str.charAt(start) == '\"') || (str
							.charAt(start) == '\''))) {
				start++;
			}

			while ((end > start)
					&& ((str.charAt(end) == ' ') || (str.charAt(end) == '\"') || (str
							.charAt(end) == '\''))) {
				end--;
			}

			return str.substring(start, end + 1);
			
		}
	}

	/**
	 * @param fileName
	 *            The fileName to set.
	 */
	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

	/**
	 * Set the plugin name (the directory with version)
	 * 
	 * @param name
	 */
	public void setPluginName(String name) {
		this.pluginName = name;
	}

	/**
	 * Retrieve the plugin name (the directory with version)
	 * 
	 * @return
	 */
	public String getPluginName() {
		return this.pluginName;
	}

	/**
	 * Bug 93461 Retrieve the list of jar files inside the NL plugin
	 */
	public Enumeration getNLFiles() {
		/* NM - bugzilla 173330: Changed hardcoded plugins location */
		return getNLFiles(new File(pluginsHome),pluginName);
	}
	
	public Enumeration getNLFiles(File pDir,String plugin){
		
		String rawPluginName;
		String prefix;
		int posVersion;
		Vector nlFiles = new Vector();
		File pluginDir;

		posVersion = plugin.lastIndexOf("_");
		if (posVersion < 0) {
			return null;
		} else {
			pluginDir =  pDir;
			rawPluginName = plugin.substring(0, posVersion);
			prefix = rawPluginName;

			/*
			 * Look for NL directories
			 */
			File[] nlDirs = pluginDir.listFiles(new LocalFileFilter(prefix, null));
			for(int i = 0; i < nlDirs.length; i++) {
				if(nlDirs[i].isDirectory()) {
					File[] contents = nlDirs[i].listFiles(new LocalFileFilter(null, ".jar"));
					for(int j = 0; j < contents.length; j++) {
						if(isNLJar(contents[j])){
							nlFiles.add(contents[j].getAbsolutePath());
						}
					}
				}
			}

			/*
			 * Look for NL jars
			 */
			File[] nlJars = pluginDir.listFiles(new LocalFileFilter(prefix, ".jar"));
			for(int i = 0; i < nlJars.length; i++) {
				if(nlJars[i].isFile()) {
					if(isNLJar(nlJars[i])){
						nlFiles.add(nlJars[i].getAbsolutePath());
					}
				}
			}

			return nlFiles.elements();
		}
	}


	/**
	 * 
	 * @param f
	 * @return true if f is a valid NL jar; otherwise return false.
	 * 
	 * There is no naming convention for NL jars.  This is the best we can do for now.
	 */
	private boolean isNLJar(File f){
			
		if(!f.exists() || f.isDirectory())
			return false;
		
		for(int i = 0; i < NLJAR_PREFIX.length; i++){
			if(f.getName().toUpperCase().indexOf(NLJAR_PREFIX[i].toUpperCase()) != -1)
				return true;
		}
		
		return false;
		
	}
	
	
}

class LocalFileFilter implements FilenameFilter {
	private String _prefix;
	private String _suffix;

	public LocalFileFilter(String prefix, String suffix) {
		_prefix = prefix;
		_suffix = suffix;
	}

	public boolean accept(File dir, String name) {
		boolean match = false;

		if((_prefix == null) && (_suffix == null)) {
			match = true;
		}
		else if((_prefix == null) && (_suffix != null)) {
			match = name.endsWith(_suffix);
		}
		else if((_prefix != null) && (_suffix == null)) {
			match = name.startsWith(_prefix);
		}
		else if((_prefix != null) && (_suffix != null)) {
			match = name.startsWith(_prefix) && name.endsWith(_suffix);
		}

		return match;
	}
}
