/**********************************************************************
Copyright (c) 2005, 2007 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: TestJvm.java,v 1.9 2007/04/12 18:48:22 nmehrega Exp $

Contributors:
 IBM Rational - initial implementation
**********************************************************************/
package org.eclipse.tptp.platform.agentcontroller.config;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class TestJvm {

	public static boolean isSupportedJava(String path, String minVersion) {
		String ver = jvmVersion(path);

		if (ver == null) {
			return false;
		}
		return isMinimumVersion(minVersion, ver);
	}

	private static String jvmVersion(String path) {
		try {
			Runtime rt = Runtime.getRuntime();
			String cp = System.getProperty("java.class.path");
//			String env[] = new String[] {
//					"CLASSPATH=" + cp
//			};
			
			/* NM: If path has spaces, include quotes */
			String quote = "";
			
			if (cp.indexOf(" ") != -1)
				quote = "\"";
			
			String arg[] = new String[] {
					path,
					"org.eclipse.tptp.platform.agentcontroller.config.GetJavaVersion"
			};
			String cmd = arg[0]+" "+"-cp " + quote + cp + quote + " "+arg[1];//90554
			
			Process p = rt.exec(cmd);//90554

			BufferedReader bout = new BufferedReader(new InputStreamReader(p.getInputStream()));

			return bout.readLine();
		} catch (IOException e) {
			e.printStackTrace();
		}

		return null;
	}

	public static boolean isMinimumVersion(String req, String ver) {
		StringTokenizer stReq = new StringTokenizer(req, "._");
		StringTokenizer stVer = new StringTokenizer(ver, "._");

		try {
			/*
			 * Check major version
			 */
			int majReq = 0;
			int majVer = -1;
			// Get the major versions
			if(stReq.hasMoreTokens() && stVer.hasMoreTokens()) {
				majReq = Integer.valueOf(stReq.nextToken()).intValue();
				majVer = Integer.valueOf(stVer.nextToken()).intValue();
			}
			else {
				return false; // can't find major version
			}

			if(majVer < majReq) {
				return false;
			}
			else if(majVer > majReq) {
				return true;
			}

			/*
			 * Optional: check minor version
			 */
			int minReq = 0;
			int minVer = -1;
			// Get the minor versions
			if(stReq.hasMoreTokens()) { // do this only if minor version exists
				minReq = Integer.valueOf(stReq.nextToken()).intValue();
				if(stVer.hasMoreTokens()) {
					minVer = Integer.valueOf(stVer.nextToken()).intValue();
					if(minVer < minReq) {
						return false;
					}
					else if(minVer > minReq) {
						return true;
					}
				}
				else {
					return false; // can't find minor version of the current
				}
			}
			else {
				return true;
			}

			/*
			 * Optional: check maint version
			 */
			int mntReq = 0;
			int mntVer = -1;
			// Get the maint versions
			if(stReq.hasMoreTokens()) { // do this only if maint version exists
				mntReq = Integer.valueOf(stReq.nextToken()).intValue();
				if(stVer.hasMoreTokens()) {
					mntVer = Integer.valueOf(stVer.nextToken()).intValue();
					if(mntVer < mntReq) {
						return false;
					}
					else if(mntVer >= mntReq) {
						return true;
					}
				}
				else {
					return false; // can't find maint version of the current
				}
			}
			else {
				return true;
			}
		}
		catch(Exception e) {
			// Cannt convert string to number
		}

		return false;
	}

}
