/**********************************************************************
Copyright (c) 2005 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: Variable.java,v 1.2 2005/02/25 22:17:34 hleung Exp $

Contributors:
 IBM Rational - initial implementation
**********************************************************************/
package org.eclipse.tptp.platform.agentcontroller.config;

import org.w3c.dom.Element;

public class Variable extends ConfigElement {
	public final static String TAG = ConfigUtility.getString("Config.Variable.Tag");

	public static void setName(Element elem, String value) {
		elem.setAttribute(ConfigUtility.getString("Config.Variable.Name.Tag"), value);
	}

	public static String getName(Element elem) {
		return elem.getAttribute(ConfigUtility.getString("Config.Variable.Name.Tag"));
	}

	public static void setValue(Element elem, String value) {
		elem.setAttribute(ConfigUtility.getString("Config.Variable.Value.Tag"), value);
	}

	public static String getValue(Element elem) {
		return elem.getAttribute(ConfigUtility.getString("Config.Variable.Value.Tag"));
	}

	public static void setPosition(Element elem, String value) {
		elem.setAttribute(ConfigUtility.getString("Config.Variable.Position.Tag"), value);
	}

	public static String getPosition(Element elem) {
		return elem.getAttribute(ConfigUtility.getString("Config.Variable.Position.Tag"));
	}

}
