/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: JavaParser.java,v 1.2 2006/04/06 15:48:13 samwai Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.agentcontroller.internal.config.parser;

import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class JavaParser extends DefaultHandler {
	private native void endDocument0();
	private native void endElement0(String elemName);
	private native void startDocument0();
	private native void startElement0(String elemName, String[] attrNames, String[] attrValues, int attrCount);
	private native void warning0(String file, int line, int col, String message);
	private native void error0(String file, int line, int col, String message);
	private native void fatalError0(String file, int line, int col, String message);

	public int processConfiguration(String fileName) {
		SAXParser saxp = null;
		XMLReader parser = null;

//		System.out.println("Parsing XML file: " + fileName);
		try {
			saxp = SAXParserFactory.newInstance().newSAXParser();
			parser = saxp.getXMLReader();
			parser.setContentHandler(this);
			parser.setErrorHandler(this);
		} catch (Exception e) {
			System.err.println("Error creating parser: " + parser);
			e.printStackTrace(System.err);
			return -1;
		}

		if((parser != null) && (fileName != null)) {
			try {
				parser.parse(fileName);
			} catch (Exception e) {
				System.err.println("Error parsing file: " + fileName);
				e.printStackTrace(System.err);
				return -1;
			}
			return 0;
		}
		else {
			System.err.println("Error parsing file: " + fileName);
			return -1;
		}

	}

	public void characters(char[] ch, int start, int length) throws SAXException {
		// Not used
	}

	public void endDocument() throws SAXException {
		try {
			endDocument0();
		} catch(UnsatisfiedLinkError e) {
			System.err.println("Cannot find native method endDocument0()");
		}
	}

	public void startDocument() throws SAXException {
		try {
			startDocument0();
		} catch(UnsatisfiedLinkError e) {
			System.err.println("Cannot find native method startDocument0()");
		}
	}

	public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
		try {
			endElement0(qName);
		} catch(UnsatisfiedLinkError e) {
			System.err.println("Cannot find native method endElement0()");
		}
	}

	public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
		int len = atts.getLength();
		String[] attrNames = new String[len];
		String[] attrValues = new String[len];

		for(int i = 0; i < len; i++) {
			attrNames[i] = atts.getQName(i);
			attrValues[i] = atts.getValue(i);
		}

		try {
			startElement0(qName, attrNames, attrValues, len);
		} catch(UnsatisfiedLinkError e) {
			System.err.println("Cannot find native method startElement0()");
		}
	}

	public void error(SAXParseException e) throws SAXException {
		try {
			error0(e.getSystemId(), e.getLineNumber(), e.getColumnNumber(), e.getMessage());
		} catch(UnsatisfiedLinkError e1) {
			System.err.println("Cannot find native method error0()");
		}
	}

	public void fatalError(SAXParseException e) throws SAXException {
		try {
			fatalError0(e.getSystemId(), e.getLineNumber(), e.getColumnNumber(), e.getMessage());
		} catch(UnsatisfiedLinkError e1) {
			System.err.println("Cannot find native method fatalError0()");
		}
	}

	public void warning(SAXParseException e) throws SAXException {
		try {
			warning0(e.getSystemId(), e.getLineNumber(), e.getColumnNumber(), e.getMessage());
		} catch(UnsatisfiedLinkError e1) {
			System.err.println("Cannot find native method warning0()");
		}
	}
}
