/**********************************************************************
 * Copyright (c) 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SSLKeyManager.java,v 1.2 2008/01/25 19:37:28 jcayne Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.agentcontroller.jsse;

import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;

import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;

public class SSLKeyManager implements X509KeyManager {
	private X509KeyManager _km = null;

	public SSLKeyManager(KeyStore ks, char[] password) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
		KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
		kmf.init(ks, password);
		KeyManager[] kms = kmf.getKeyManagers();

		if (kms != null) {
			_km = (X509KeyManager) kms[0];
		}
	}

	public PrivateKey getPrivateKey(String s) {
		return _km.getPrivateKey(s);
	}

	public X509Certificate[] getCertificateChain(String s) {
		return _km.getCertificateChain(s);
	}

	public String[] getClientAliases(String keyType, Principal[] issuers) {
		return _km.getClientAliases(keyType, issuers);
	}

	public String[] getServerAliases(String keyType, Principal[] issuers) {
		return _km.getServerAliases(keyType, issuers);
	}

	public String chooseServerAlias(String keyType, Principal[] issuers, Socket sock) {
		return _km.chooseServerAlias(keyType, issuers, null);
	}

	public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket sock) {
		return _km.chooseClientAlias(keyType, issuers, null);
	}
}
