/**********************************************************************
 * Copyright (c) 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SSLKeyStore.java,v 1.2 2008/01/25 19:37:28 jcayne Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.agentcontroller.jsse;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

public class SSLKeyStore {
	private static String _ksType = "JKS";
	private KeyStore _keyStore;
	private String _filename;
	private char[] _password;

	public SSLKeyStore(String filename, char[] password) {
		_filename = filename;
		_password = password;
	}

	public KeyStore getKeyStore() {
		return _keyStore;
	}

	public void loadKeyStore() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException {
		boolean ksExist = false;
		
		_keyStore = KeyStore.getInstance(_ksType);
		File ksFile = new File(_filename);
		ksExist = ksFile.exists();
	
		if(ksExist) {
			_keyStore.load(new FileInputStream(_filename), _password);
		} else {
			_keyStore.load(null, _password);
		}
	}

	public void saveKeyStore() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
		FileOutputStream fos = new FileOutputStream(_filename);
		_keyStore.store(fos, _password);
		fos.close();
	}
}
