/*******************************************************************************
 * Copyright (c) 2005 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Andy Kaylor, Intel - Initial implementation
 *
 * $Id: Extractor.h,v 1.3 2005/06/02 00:56:46 vnaikawadi Exp $
 *******************************************************************************/ 

#ifndef __EXTRACTOR_H__
#define __EXTRACTOR_H__

#include "tptp/TPTPTypes.h"
#include "tptp/MsgPipeline.h"

#ifdef __cplusplus
extern "C" {
#endif

/**
 ******************************************************************
 *
 * @brief
 *    common interface to instantiate a command extractor object
 *
 * @return
 *    0 - Success
 *    nonzero - Error.
 ******************************************************************/
tptp_int32 createCommandExtractor( tptp_object* cmo, command_extractor_data_t * pExtractorData, tptp_object* cxo ); 


/**
 ******************************************************************
 *
 * @brief
 *    common interface to destroy a command extractor object
 *
 * @return
 *    0 - Success
 *    nonzero - Error.
 ******************************************************************/
tptp_int32 destroyCommandExtractor( tptp_object* cxo );


/**
 ******************************************************************
 *
 * @brief
 *    common interface to request processing of a message block
 *
 * @return
 *    0 - Success
 *    nonzero - Error.
 ******************************************************************/
tptp_int32 processMessage(tptp_object* cmo, tptp_uint32 size, const tptp_string *pPayLoad);



#ifdef __cplusplus
}
#endif

#endif /* __EXTRACTOR_H__ */

