/*******************************************************************************
 * Copyright (c) 2005, 2008 Intel Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Andy Kaylor, Intel - Initial re-implementation of Agent Controller
 *
 * $Id: MsgPipeline.h,v 1.12 2008/06/16 20:58:05 jkubasta Exp $
 *******************************************************************************/ 

#ifndef __MSG_PIPELINE_H__
#define __MSG_PIPELINE_H__

/* Functions provided by the Agent Controller */
typedef tptp_int32 (*addConnectionEntry_ptr_t)(tptp_object* cmo, tptp_uint32 transportID, tptp_uint32 *pConnectionID);
typedef tptp_int32 (*removeConnectionEntry_ptr_t)(tptp_object* cmo, tptp_uint32 connectionID);
typedef tptp_int32 (*addDataConnectionEntry_ptr_t)(tptp_object* cmo, tptp_uint32 transportID, tptp_uint32 flags, tptp_uint32 *pConnectionID);
typedef tptp_int32 (*addDirectDataConnectionEntry_ptr_t)(tptp_object* cmo, tptp_uint32 transportID, tptp_uint32 flags, tptp_uint32 descriptor, tptp_uint32 *pConnectionID);
typedef tptp_int32 (*removeDataConnectionEntry_ptr_t)(tptp_object* cmo, tptp_uint32 connectionID);
typedef tptp_int32 (*logEventEntry_ptr_t)( tptp_object* cmo, 
                                           tptp_string* subcomponent,
                                           tptp_uint32  instanceId,
                                           tptp_string* filename,
                                           tptp_int32   lineNum,
                                           tptp_int32   severity, 
                                           tptp_string* event );
typedef tptp_uint32 (*processCommand_ptr_t)( tptp_object*, tptp_uint32 dest, const tptp_string* cmd );

/* Structure used in command extractor initialization */
typedef struct {
   processCommand_ptr_t  processCommandEntry;
   logEventEntry_ptr_t   logEventEntry;
} command_extractor_data_t;

/* Functions provided by the command extractor */
typedef tptp_int32 (*createCommandExtractor_ptr_t)( tptp_object* cmo, command_extractor_data_t * pExtractorData, tptp_object* cxo ); 
typedef tptp_int32 (*destroyCommandExtractor_ptr_t)( tptp_object* cxo );
typedef tptp_int32 (*processMessage_ptr_t)(tptp_object* cmo, tptp_uint32 size, tptp_string *pPayLoad);

/* Structure used in transport layer initialization */
typedef struct {
   tptp_uint32                         transportID;
   const tptp_string*                  configurationData;
   addConnectionEntry_ptr_t            addConnectionEntry;
   removeConnectionEntry_ptr_t         removeConnectionEntry;
   addDataConnectionEntry_ptr_t        addDataConnectionEntry;
   addDirectDataConnectionEntry_ptr_t  addDirectDataConnectionEntry;
   removeDataConnectionEntry_ptr_t     removeDataConnectionEntry;
   logEventEntry_ptr_t                 logEventEntry;
} transport_layer_data_t;

/* Functions provided by the transport layer */
typedef tptp_int32 (*createTransportListener_ptr_t)( tptp_object* cmo, transport_layer_data_t * pTransportData, tptp_object* tlo ); 
typedef tptp_int32 (*destroyTransportListener_ptr_t)( tptp_object* tlo );
typedef tptp_int32 (*setProcessMessageFunc_ptr_t)( tptp_object* tlo, tptp_object* nexto, processMessage_ptr_t func );
typedef tptp_int32 (*startTransportListener_ptr_t)( tptp_object* tlo ); 
typedef tptp_int32 (*stopTransportListener_ptr_t)( tptp_object* tlo );
typedef tptp_int32 (*terminateConnection_ptr_t)( tptp_object* tlo, tptp_uint32 connectionID );
typedef tptp_int32 (*sendMessage_ptr_t)( tptp_object* tlo, tptp_uint32 connectionID, tptp_uint32 size, const tptp_string* pCmdBlock);
typedef tptp_int32 (*sendData_ptr_t)( tptp_object* tlo, tptp_uint32 connectionID, tptp_uint32 size, void * pDataBlock);
typedef tptp_int32 (*setIncomingDataFunc_ptr_t)( tptp_object* tlo, tptp_uint32 connectionID, tptp_uint32 partnerID, tptp_object* partner, sendData_ptr_t newDataFunc );
typedef tptp_int32 (*setDataDescriptor_ptr_t)( tptp_object* tlo, tptp_uint32 connectionID, tptp_uint32 partnerID, tptp_object* partner, tptp_uint32 descriptor );
typedef tptp_int32 (*terminateDataConnection_ptr_t)( tptp_object* tlo, tptp_uint32  connectionID);

/* Structure used to override peer monitoring defaults */
typedef struct PeerAttachInfo_tag
{
	int           usePeerAttachPort;
	int           peerAttachPort;
	int           usePeerAttachAddress;
	unsigned int  peerAttachAddress;	
} PeerAttachInfo_t;

/*
typedef struct {
	char * transportType;
	tptp_list_t hostList;
	int port;
} PeerIPv6Connection_t;
*/

/* Optional functions provided by TLs involved in peer monitoring */
typedef tptp_int32 (*setPeerAttachInfo_ptr_t)( tptp_object* tlo, PeerAttachInfo_t* peerInfo );
typedef tptp_int32 (*getPeerConnectionInfo_ptr_t)( tptp_object* tlo, tptp_string* type, tptp_string** ci );
typedef tptp_int32 (*createPeerConnection_ptr_t)( tptp_object* tlo, tptp_string* ci, tptp_uint32* connectionID );


#define TPTP_MAX_MSG_SIZE 8192

#endif /* __MSG_PIPELINE_H__ */
