/*******************************************************************************
 * Copyright (c) 2005, 2006 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Andy Kaylor, Intel - Complete replacement of logging macros
 *
 * $Id: NoLog.h,v 1.2 2006/04/21 00:49:03 kcallaghan Exp $ 
 ******************************************************************************/ 


#ifndef __TPTPLOG_H__
#define __TPTPLOG_H__

/* TODO: Replace this or remove the code that uses it */

/* 
 * AK -- This file is a temporary workaround to disable logging in places that 
 *       have no access to the standard logging mechanisms 
 */


#include <stdio.h>

enum _tptpLogLevel {
	TPTP_DEBUG = 5,
	TPTP_INFORMATION = 10,
	TPTP_HARMLESS = 20,
	TPTP_WARNING = 30,
	TPTP_MINOR = 40,
	TPTP_CRITICAL = 50,
	TPTP_SEVERE = 55,
	TPTP_FATAL = 60
};

typedef enum _tptpLogLevel TPTPLogLevel;

//Define DISPLAY_NOLOG_MSGS either here or in specific files the include NoLog.h
//to print debug messages that do not get logged to the common log file.
//#define DISPLAY_NOLOG_MSGS
#ifndef DISPLAY_NOLOG_MSGS
#define TPTP_LOG_MSG(sev, msg)
#define TPTP_LOG_MSG1(sev, msgFormat, par1)
#define TPTP_LOG_MSG2(sev, msgFormat, par1, par2)
#define TPTP_LOG_MSG3(sev, msgFormat, par1, par2, par3)
#define TPTP_LOG_MSG4(sev, msgFormat, par1, par2, par3, par4)
#define TPTP_LOG_MSG5(sev, msgFormat, par1, par2, par3, par4, par5)
#else
#define TPTP_LOG_MSG(sev, msg) { printf("%s\n",msg); }
#define TPTP_LOG_MSG1(sev, msgFormat, par1)	{ printf(msgFormat, par1); printf("\n"); }
#define TPTP_LOG_MSG2(sev, msgFormat, par1, par2) { printf(msgFormat, par1, par2); printf("\n"); }
#define TPTP_LOG_MSG3(sev, msgFormat, par1, par2, par3) { printf(msgFormat, par1, par2, par3); printf("\n"); }
#define TPTP_LOG_MSG4(sev, msgFormat, par1, par2, par3, par4)  { printf(msgFormat, par1, par2, par3, par4); printf("\n"); }
#define TPTP_LOG_MSG5(sev, msgFormat, par1, par2, par3, par4, par5)  { printf(msgFormat, par1, par2, par3, par4, par5); printf("\n"); }
#endif

/* Macros for logging TPTP_SEVERE message 
*  There are overloaded macros that take 1-5 parameters alongwith format like printf
*/
#define TPTP_LOG_SEVERE_MSG(msg) TPTP_LOG_MSG(TPTP_SEVERE, msg)
#define TPTP_LOG_SEVERE_MSG1(msgFormat, par1) TPTP_LOG_MSG1(TPTP_SEVERE, msgFormat, par1)
#define TPTP_LOG_SEVERE_MSG2(msgFormat, par1, par2) TPTP_LOG_MSG2(TPTP_SEVERE, msgFormat, par1, par2)
#define TPTP_LOG_SEVERE_MSG3(msgFormat, par1, par2, par3) TPTP_LOG_MSG3(TPTP_SEVERE, msgFormat, par1, par2, par3)
#define TPTP_LOG_SEVERE_MSG4(msgFormat, par1, par2, par3, par4) TPTP_LOG_MSG4(TPTP_SEVERE, msgFormat, par1, par2, par3, par4)
#define TPTP_LOG_SEVERE_MSG5(msgFormat, par1, par2, par3, par4, par5) TPTP_LOG_MSG5(TPTP_SEVERE, msgFormat, par1, par2, par3, par4, par5)


/* Macros for logging TPTP_ERROR message 
*  There are overloaded macros that take 1-5 parameters alongwith format like printf
*/
#define TPTP_LOG_ERROR_MSG(msg) TPTP_LOG_MSG(TPTP_CRITICAL, msg)
#define TPTP_LOG_ERROR_MSG1(msgFormat, par1) TPTP_LOG_MSG1(TPTP_CRITICAL, msgFormat, par1)
#define TPTP_LOG_ERROR_MSG2(msgFormat, par1, par2) TPTP_LOG_MSG2(TPTP_CRITICAL, msgFormat, par1, par2)
#define TPTP_LOG_ERROR_MSG3(msgFormat, par1, par2, par3) TPTP_LOG_MSG3(TPTP_CRITICAL, msgFormat, par1, par2, par3)
#define TPTP_LOG_ERROR_MSG4(msgFormat, par1, par2, par3, par4) TPTP_LOG_MSG4(TPTP_CRITICAL, msgFormat, par1, par2, par3, par4)
#define TPTP_LOG_ERROR_MSG5(msgFormat, par1, par2, par3, par4, par5) TPTP_LOG_MSG5(TPTP_CRITICAL, msgFormat, par1, par2, par3, par4, par5)


/* Macros for logging TPTP_WARNING message 
*  There are overloaded macros that take 1-5 parameters alongwith format like printf
*/
#define TPTP_LOG_WARNING_MSG(msg) TPTP_LOG_MSG(TPTP_WARNING, msg)
#define TPTP_LOG_WARNING_MSG1(msgFormat, par1) TPTP_LOG_MSG1(TPTP_WARNING, msgFormat, par1)
#define TPTP_LOG_WARNING_MSG2(msgFormat, par1, par2) TPTP_LOG_MSG2(TPTP_WARNING, msgFormat, par1, par2)
#define TPTP_LOG_WARNING_MSG3(msgFormat, par1, par2, par3) TPTP_LOG_MSG3(TPTP_WARNING, msgFormat, par1, par2, par3)
#define TPTP_LOG_WARNING_MSG4(msgFormat, par1, par2, par3, par4) TPTP_LOG_MSG4(TPTP_WARNING, msgFormat, par1, par2, par3, par4)
#define TPTP_LOG_WARNING_MSG5(msgFormat, par1, par2, par3, par4, par5) TPTP_LOG_MSG5(TPTP_WARNING, msgFormat, par1, par2, par3, par4, par5)


/* Macros for logging TPTP_DEBUG message 
*  There are overloaded macros that take 1-5 parameters alongwith format like printf
*/
#define TPTP_LOG_DEBUG_MSG(msg) TPTP_LOG_MSG(TPTP_DEBUG, msg)
#define TPTP_LOG_DEBUG_MSG1(msgFormat, par1) TPTP_LOG_MSG1(TPTP_DEBUG, msgFormat, par1)
#define TPTP_LOG_DEBUG_MSG2(msgFormat, par1, par2) TPTP_LOG_MSG2(TPTP_DEBUG, msgFormat, par1, par2)
#define TPTP_LOG_DEBUG_MSG3(msgFormat, par1, par2, par3) TPTP_LOG_MSG3(TPTP_DEBUG, msgFormat, par1, par2, par3)
#define TPTP_LOG_DEBUG_MSG4(msgFormat, par1, par2, par3, par4) TPTP_LOG_MSG4(TPTP_DEBUG, msgFormat, par1, par2, par3, par4)
#define TPTP_LOG_DEBUG_MSG5(msgFormat, par1, par2, par3, par4, par5) TPTP_LOG_MSG5(TPTP_DEBUG, msgFormat, par1, par2, par3, par4, par5)


/* Macros for logging TPTP_INFO message 
*  There are overloaded macros that take 1-5 parameters alongwith format like printf
*/
#define TPTP_LOG_INFO_MSG(msg) TPTP_LOG_MSG(TPTP_INFORMATION, msg)
#define TPTP_LOG_INFO_MSG1(msgFormat, par1) TPTP_LOG_MSG1(TPTP_INFORMATION, msgFormat, par1)
#define TPTP_LOG_INFO_MSG2(msgFormat, par1, par2) TPTP_LOG_MSG2(TPTP_INFORMATION, msgFormat, par1, par2)
#define TPTP_LOG_INFO_MSG3(msgFormat, par1, par2, par3) TPTP_LOG_MSG3(TPTP_INFORMATION, msgFormat, par1, par2, par3)
#define TPTP_LOG_INFO_MSG4(msgFormat, par1, par2, par3, par4) TPTP_LOG_MSG4(TPTP_INFORMATION, msgFormat, par1, par2, par3, par4)
#define TPTP_LOG_INFO_MSG5(msgFormat, par1, par2, par3, par4, par5) TPTP_LOG_MSG5(TPTP_INFORMATION, msgFormat, par1, par2, par3, par4, par5)


#endif /* __TPTPLOG_H__ */


